/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.relyingparty.ui.openid;

import com.google.step2.AuthRequestHelper;
import com.google.step2.AuthResponseHelper;
import com.google.step2.ConsumerHelper;
import com.google.step2.Step2;
import com.google.step2.discovery.IdpIdentifier;
import com.google.step2.openid.ui.UiMessageRequest;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openid4java.OpenIDException;
import org.openid4java.consumer.ConsumerAssociationStore;
import org.openid4java.consumer.InMemoryConsumerAssociationStore;
import org.openid4java.discovery.DiscoveryInformation;
import org.openid4java.discovery.Identifier;
import org.openid4java.message.AuthRequest;
import org.openid4java.message.AuthSuccess;
import org.openid4java.message.Message;
import org.openid4java.message.MessageExtension;
import org.openid4java.message.ParameterList;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.relyingparty.stub.dto.ClaimDTO;
import org.wso2.carbon.identity.relyingparty.stub.dto.OpenIDDTO;
import org.wso2.carbon.identity.relyingparty.ui.openid.ConsumerFactory;
import org.wso2.carbon.identity.relyingparty.ui.openid.OpenIDAuthenticationRequest;
import org.wso2.carbon.identity.relyingparty.ui.openid.OpenIDExtensionFactory;
import org.wso2.carbon.identity.relyingparty.ui.openid.extensions.OpenIDExtension;
import org.wso2.carbon.ui.CarbonUIUtil;
import org.wso2.carbon.utils.CarbonUtils;

public class OpenIDConsumer {
    private static volatile OpenIDConsumer consumer;
    private static volatile ConsumerHelper consumerHelper;
    private static Log log;

    public OpenIDConsumer() throws IdentityException {
        try {
            ConsumerFactory factory = new ConsumerFactory((ConsumerAssociationStore)new InMemoryConsumerAssociationStore());
            consumerHelper = factory.getConsumerHelper();
        }
        catch (Exception e) {
            log.error((Object)"Relying Party initialization failed", (Throwable)e);
            throw new IdentityException("Relying Party initialization failed", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OpenIDConsumer getInstance() throws IdentityException {
        if (consumer != null) return consumer;
        Class<OpenIDConsumer> clazz = OpenIDConsumer.class;
        synchronized (OpenIDConsumer.class) {
            if (consumer != null) return consumer;
            consumer = new OpenIDConsumer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return consumer;
        }
    }

    public String doOpenIDAuthentication(OpenIDAuthenticationRequest request) throws IdentityException {
        if (request == null) {
            throw new IdentityException("Invalid OpenID authentication request");
        }
        if (request.getReturnUrl() == null) {
            request.setReturnUrl(request.getRequest().getParameter("returnUrl"));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Return_to url :" + request.getReturnUrl()));
        }
        return this.authRequest(request);
    }

    public Message verifyOpenID(HttpServletRequest request, ParameterList openidResp, String receivingURL) throws OpenIDException, IdentityException {
        AuthResponseHelper authResponse;
        DiscoveryInformation discovered = null;
        String queryString = null;
        HttpSession session = null;
        session = request.getSession();
        discovered = (DiscoveryInformation)session.getAttribute("openid-disc");
        String cssLocation = request.getParameter("css");
        if ("null".equals(cssLocation)) {
            cssLocation = null;
        }
        String pageTitle = request.getParameter("title");
        String forwardPage = request.getParameter("forwardPage");
        if (receivingURL == null) {
            receivingURL = this.getAdminConsoleURL(request) + "relyingparty/openid_accept.jsp";
            if (cssLocation != null) {
                receivingURL = receivingURL + "?forwardPage=" + forwardPage + "&css=" + cssLocation + "&title=" + pageTitle;
            }
        }
        queryString = request.getQueryString();
        if (log.isDebugEnabled()) {
            log.debug((Object)("OpenID receiving url from the reponse: " + receivingURL));
            log.debug((Object)("OpenID query string from the reponse: " + queryString));
        }
        if ((authResponse = consumerHelper.verify(receivingURL, openidResp, discovered)).getAuthResultType() == AuthResponseHelper.ResultType.AUTH_SUCCESS) {
            return authResponse.getAuthResponse();
        }
        log.error((Object)"OpenID verification failed");
        throw new IdentityException("OpenID verification failed");
    }

    protected String authRequest(OpenIDAuthenticationRequest request) throws IdentityException {
        try {
            IdpIdentifier openId = new IdpIdentifier(request.getOpenIDUrl());
            AuthRequestHelper helper = consumerHelper.getAuthRequestHelper((Identifier)openId, request.getReturnUrl());
            this.addAttributes(helper, request);
            HttpSession session = request.getRequest().getSession();
            AuthRequest authReq = helper.generateRequest();
            UiMessageRequest uiExtension = new UiMessageRequest();
            uiExtension.setIconRequest(true);
            authReq.addExtension((MessageExtension)uiExtension);
            session.setAttribute("openid-disc", (Object)helper.getDiscoveryInformation());
            if (request.getRealm() != null && request.getRealm().trim().length() != 0) {
                authReq.setRealm(request.getRealm());
            }
            for (String type : request.getRequestTypes()) {
                authReq.addExtension(OpenIDExtensionFactory.getInstance().getExtension(type).getMessageExtension(request));
            }
            String value = authReq.getDestinationUrl(true);
            return value;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new IdentityException(e.getMessage(), (Throwable)e);
        }
    }

    void addAttributes(AuthRequestHelper helper, OpenIDAuthenticationRequest request) {
        if (request.getRequestClaimsFromIdP()) {
            List<String> claims = request.getRequiredClaimURIs();
            Iterator<String> ite = claims.iterator();
            while (ite.hasNext()) {
                helper.requestAxAttribute(Step2.AxSchema.ofTypeUri((String)ite.next()), true);
            }
        }
    }

    public OpenIDDTO validateOpenIDAuthentication(HttpServletRequest request, String requestURL) throws IdentityException {
        ParameterList response = null;
        AuthSuccess authSuccess = null;
        String mode = null;
        OpenIDExtension extension = null;
        ArrayList<ClaimDTO> claimList = null;
        OpenIDDTO openID = null;
        try {
            response = new ParameterList(request.getParameterMap());
            mode = response.getParameterValue("openid.mode");
            if (mode != null && "cancel".equals(mode)) {
                throw new IdentityException("User has denied sending his profile info");
            }
            authSuccess = (AuthSuccess)this.verifyOpenID(request, response, requestURL);
            claimList = new ArrayList<ClaimDTO>();
            for (Object alias : authSuccess.getExtensions()) {
                extension = OpenIDExtensionFactory.getInstance().getExtension((String)alias, authSuccess);
                if (extension == null) continue;
                extension.setSessionAttributes(claimList);
            }
            openID = new OpenIDDTO();
            openID.setOpenID(authSuccess.getIdentity());
            openID.setClaims(claimList.toArray(new ClaimDTO[claimList.size()]));
            return openID;
        }
        catch (OpenIDException e) {
            log.error((Object)e.getMessage());
            throw new IdentityException("OpenID authentication failed", (Throwable)e);
        }
    }

    public String getAdminConsoleURL(HttpServletRequest request) {
        String webContextRoot = CarbonUtils.getServerConfiguration().getFirstProperty("WebContextRoot");
        return CarbonUIUtil.getAdminConsoleURL((String)webContextRoot);
    }

    static {
        log = LogFactory.getLog(OpenIDConsumer.class);
    }
}

