/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.relyingparty.ui.openid;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.relyingparty.ui.openid.AuthPolicyType;
import org.wso2.carbon.identity.relyingparty.ui.openid.OpenIDAxAttribute;

public class OpenIDAuthenticationRequest {
    private String returnUrl;
    private HttpServletResponse reponse;
    private HttpServletRequest request;
    private String openIDUrl;
    private List<String> requiredClaimURIs = new ArrayList<String>();
    private List<String> optionalClaimURIs = new ArrayList<String>();
    private List<OpenIDAxAttribute> requiredClaims = new ArrayList<OpenIDAxAttribute>();
    private List<OpenIDAxAttribute> optionalClaims = new ArrayList<OpenIDAxAttribute>();
    private String realm;
    private ArrayList<String> requestTypes = new ArrayList();
    private ArrayList<AuthPolicyType> authTypes = new ArrayList();
    private int maxAuthAge;
    private boolean requestClaimsFromIdP = false;

    public OpenIDAuthenticationRequest(HttpServletRequest request, HttpServletResponse reponse) {
        this.reponse = reponse;
        this.request = request;
    }

    public String getOpenIDUrl() {
        return this.openIDUrl;
    }

    public void setOpenIDUrl(String openIDUrl) {
        this.openIDUrl = openIDUrl;
    }

    public ArrayList<String> getRequestTypes() {
        return this.requestTypes;
    }

    public HttpServletResponse getReponse() {
        return this.reponse;
    }

    public void setReponse(HttpServletResponse reponse) {
        this.reponse = reponse;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }

    public String getReturnUrl() {
        return this.returnUrl;
    }

    public void setReturnUrl(String returnurl) {
        this.returnUrl = returnurl;
    }

    public int getMaxAuthAge() {
        return this.maxAuthAge;
    }

    public void setMaxAuthAge(int maxAuthAge) {
        this.maxAuthAge = maxAuthAge;
    }

    public ArrayList<AuthPolicyType> getAuthTypes() {
        return this.authTypes;
    }

    public boolean getRequestClaimsFromIdP() {
        return this.requestClaimsFromIdP;
    }

    public void setRequestClaimsFromIdP(boolean requestClaimsFromIdP) {
        this.requestClaimsFromIdP = requestClaimsFromIdP;
    }

    public void addAuthPolicy(AuthPolicyType policyType) {
        if (!this.authTypes.contains((Object)policyType)) {
            this.authTypes.add(policyType);
        }
    }

    public void addRequestType(String requestType) {
        if (!this.requestTypes.contains(requestType)) {
            this.requestTypes.add(requestType);
        }
    }

    public void addRequiredClaims(String attribute) throws IdentityException {
        this.addClaims(attribute, this.requiredClaimURIs);
    }

    public void addOptionalClaims(String attribute) throws IdentityException {
        this.addClaims(attribute, this.optionalClaimURIs);
    }

    public void addRequiredClaims(String attribute, String namespace) throws IdentityException {
        this.addClaims(attribute, namespace, this.requiredClaims);
    }

    public void addOptionalClaims(String attribute, String namespace) throws IdentityException {
        this.addClaims(attribute, namespace, this.optionalClaims);
    }

    private void addClaims(String attribute, String namespace, List<OpenIDAxAttribute> claims) throws IdentityException {
        OpenIDAxAttribute axAttribute = null;
        if (attribute == null || attribute.trim().length() == 0 || namespace == null || namespace.trim().length() == 0) {
            throw new IdentityException("invalidInputParams");
        }
        axAttribute = new OpenIDAxAttribute(attribute, namespace);
        for (OpenIDAxAttribute element : claims) {
            OpenIDAxAttribute attr;
            if (!(element instanceof OpenIDAxAttribute) || !(attr = element).getAttributeName().equalsIgnoreCase(attribute) && !attr.getNamespace().equalsIgnoreCase(namespace)) continue;
            throw new IdentityException("duplicatedAttributes");
        }
        if (!this.requestTypes.contains("ax")) {
            this.requestTypes.add("ax");
        }
        claims.add(axAttribute);
    }

    private void addClaims(String attribute, List<String> claims) throws IdentityException {
        if (attribute == null || attribute.trim().length() == 0) {
            throw new IdentityException("invalidInputParams");
        }
        if (claims.contains(attribute)) {
            throw new IdentityException("duplicatedAttributes");
        }
        if (!this.requestTypes.contains("sreg")) {
            this.requestTypes.add("sreg");
        }
        claims.add(attribute);
    }

    public String getRealm() {
        return this.realm;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public List<String> getRequiredClaimURIs() {
        return this.requiredClaimURIs;
    }

    public List<String> getOptionalClaimURIs() {
        return this.optionalClaimURIs;
    }

    public List<OpenIDAxAttribute> getRequiredClaims() {
        return this.requiredClaims;
    }

    public List<OpenIDAxAttribute> getOptionalClaims() {
        return this.optionalClaims;
    }
}

