/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.relyingparty.ui.openid;

import com.google.inject.AbstractModule;
import com.google.inject.CreationException;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.step2.discovery.DefaultHostMetaFetcher;
import com.google.step2.discovery.HostMetaFetcher;
import com.google.step2.hybrid.HybridOauthMessage;
import com.google.step2.openid.ax2.AxMessage2;
import com.google.step2.xmlsimplesign.CertValidator;
import com.google.step2.xmlsimplesign.CnConstraintCertValidator;
import com.google.step2.xmlsimplesign.DefaultCertValidator;
import com.google.step2.xmlsimplesign.DisjunctiveCertValidator;
import org.openid4java.consumer.ConsumerAssociationStore;
import org.openid4java.message.Message;
import org.openid4java.message.MessageException;
import org.wso2.carbon.identity.relyingparty.ui.openid.GoogleHostedHostMetaFetcher;

public class GuiceModule
extends AbstractModule {
    ConsumerAssociationStore associationStore;

    public GuiceModule(ConsumerAssociationStore associationStore) {
        this.associationStore = associationStore;
    }

    protected void configure() {
        try {
            Message.addExtensionFactory(AxMessage2.class);
        }
        catch (MessageException e) {
            throw new CreationException(null);
        }
        try {
            Message.addExtensionFactory(HybridOauthMessage.class);
        }
        catch (MessageException e) {
            throw new CreationException(null);
        }
        this.bind(ConsumerAssociationStore.class).toInstance((Object)this.associationStore);
    }

    private boolean isRunningOnAppengine() {
        if (System.getSecurityManager() == null) {
            return false;
        }
        return System.getSecurityManager().getClass().getCanonicalName().startsWith("com.google");
    }

    @Provides
    @Singleton
    public CertValidator provideCertValidator(DefaultCertValidator defaultValidator) {
        CnConstraintCertValidator hardCodedValidator = new CnConstraintCertValidator(){

            protected String getRequiredCn(String authority) {
                return "hosted-id.google.com";
            }
        };
        return new DisjunctiveCertValidator(new CertValidator[]{defaultValidator, hardCodedValidator});
    }

    @Provides
    @Singleton
    public HostMetaFetcher provideHostMetaFetcher(DefaultHostMetaFetcher fetcher1, GoogleHostedHostMetaFetcher fetcher2) {
        return fetcher2;
    }
}

