/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.relyingparty.ui.client;

import java.rmi.RemoteException;
import java.util.ArrayList;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.authenticator.stub.AuthenticationAdminStub;
import org.wso2.carbon.identity.relyingparty.stub.auth.LoggedUserInfoAdminStub;
import org.wso2.carbon.identity.relyingparty.stub.auth.loggeduserinfo.LoggedUserInfo;
import org.wso2.carbon.utils.multitenancy.MultitenantConstants;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class AuthenticationServiceClient {
    private AuthenticationAdminStub stub;
    private static final Log log = LogFactory.getLog(AuthenticationServiceClient.class);

    public AuthenticationServiceClient(String cookie, String backendServerURL, ConfigurationContext configCtx) throws AxisFault {
        String serviceURL = backendServerURL + "AuthenticationAdmin";
        this.stub = new AuthenticationAdminStub(configCtx, serviceURL);
        ServiceClient client = this.stub._getServiceClient();
        Options option = client.getOptions();
        option.setManageSession(true);
        option.setProperty("Cookie", (Object)cookie);
    }

    public static void setUserInformation(HttpSession session, String cookie, HttpServletRequest request, String userName) throws RemoteException {
        try {
            String backendServerURL = (String)session.getAttribute("ServerURL");
            ServletContext servletContext = session.getServletContext();
            ConfigurationContext configContext = (ConfigurationContext)servletContext.getAttribute("ConfigurationContext");
            LoggedUserInfoAdminStub stub = new LoggedUserInfoAdminStub(configContext, backendServerURL + "LoggedUserInfoAdmin");
            ServiceClient client = stub._getServiceClient();
            Options options = client.getOptions();
            options.setManageSession(true);
            options.setProperty("Cookie", (Object)cookie);
            LoggedUserInfo userInfo = stub.getUserInfo();
            String[] permissionArray = userInfo.getUIPermissionOfUser();
            ArrayList<String> list = new ArrayList<String>();
            for (String permission : permissionArray) {
                list.add(permission);
            }
            session.setAttribute("user-permissions", list);
            if (userInfo.getPasswordExpiration() != null) {
                session.setAttribute("passwordExpires", (Object)userInfo.getPasswordExpiration());
            }
            session.setAttribute("wso2carbon.admin.service.cookie", (Object)cookie);
            String tenantAwareUserName = MultitenantUtils.getTenantAwareUsername((String)userName);
            if (userName.equals(tenantAwareUserName)) {
                session.setAttribute(MultitenantConstants.IS_MASTER_TENANT, (Object)"true");
            }
            session.setAttribute("logged-user", (Object)tenantAwareUserName);
            session.getServletContext().setAttribute("logged-user", (Object)tenantAwareUserName);
        }
        catch (AxisFault e) {
            throw e;
        }
        catch (RemoteException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AxisFault("Exception occured", (Throwable)e);
        }
    }
}

