/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.provider.openid.ui;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.provider.openid.stub.dto.OpenIDProviderInfoDTO;
import org.wso2.carbon.identity.provider.openid.ui.client.OpenIDAdminClient;
import org.wso2.carbon.identity.provider.openid.ui.handlers.OpenIDHandler;
import org.wso2.carbon.identity.provider.openid.ui.handlers.OpenIDUtil;
import org.wso2.carbon.ui.CarbonUIUtil;

public class OpenIDUserServlet
extends HttpServlet {
    private static final long serialVersionUID = -2306630174647697559L;
    private static Log log = LogFactory.getLog(OpenIDUserServlet.class);

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String serverUrl = null;
        String user = null;
        String back = "";
        OpenIDAdminClient opClient = null;
        OpenIDProviderInfoDTO opInfo = null;
        String backendServerURL = null;
        ConfigurationContext configContext = null;
        String tenantDomain = null;
        String mainCSS = "";
        tenantDomain = req.getSession().getAttribute("tenantDomain") != null ? (String)req.getSession().getAttribute("tenantDomain") : (String)req.getAttribute("tenantDomain");
        if (tenantDomain != null) {
            String themeRoot = "../../../../t/" + tenantDomain + "/registry/resource" + "/_system/governance" + "/repository";
            mainCSS = themeRoot + "/theme/admin/main.css";
            if (req.getSession().getAttribute("theme-suffix") != null) {
                mainCSS = mainCSS + "?rsuffix=" + req.getSession().getAttribute("theme-suffix");
            }
        } else {
            mainCSS = "../carbon/styles/css/main.css";
        }
        String errorBack = "<html><head><link media=\"all\" type=\"text/css\" rel=\"stylesheet\" href=\"../carbon/openid-provider/css/openid-provider.css\" /><link media=\"all\" type=\"text/css\" rel=\"stylesheet\" href=\"../carbon/admin/css/global.css\" /><link media=\"all\" type=\"text/css\" rel=\"stylesheet\" href=\"" + mainCSS + "\">\n" + "</head>" + "<body>" + "<table cellspacing=\"0\" border=\"0\" id=\"main-table\">" + "<tbody>" + "<tr>" + "<td colspan=\"2\" id=\"header\">" + "<div id=\"header-div\">" + "<div class=\"right-logo\">Management Console</div>" + "<div class=\"left-logo\"><a class=\"header-home\" href=\"../carbon/admin/index.jsp\"><img height=\"32\" width=\"300\" src=\"../carbon/admin/images/1px.gif\"/></a>" + "</div>" + "</div>" + "</td>" + "</tr>" + "<tr>" + "<td valign=\"top\" id=\"menu-panel\">" + "<table cellspacing=\"0\" border=\"0\" id=\"menu-table\">" + "<tbody><tr><td id=\"region1\"><div id=\"menu\"><ul class=\"main\"><li class=\"menu-home\">&nbsp;</li></ul></div></td></tr></tbody>" + "</table>" + "</td>" + "<td id=\"middle-content\">" + "<div class=\"openid-box-top\"></div>" + "<table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" class=\"openid-box\">" + "<tr><td class=\"openid-box-08\"></td>" + "<td class=\"openid-box-back\" style=\"color:#c55825;\">" + "<img src=\"../carbon/openid-provider/images/openid-biguser-fishy.gif\" align=\"middle\" hspace=\"50\" />You are trying to do something fishy !!! " + "</td>" + "<td class=\"openid-box-04\"></td>" + "</tr>" + "<tr><td class=\"openid-box-07\"></td><td class=\"openid-box-06\"></td><td class=\"openid-box-05\"></td></tr>" + "</table>" + "</td>" + "</tr>" + "<tr>" + "<td colspan=\"2\" id=\"footer\">" + "<div id=\"footer-div\">" + "<div class=\"footer-content\">" + "<div class=\"copyright\">\u00a9 2008 - 2009 WSO2 Inc. All Rights Reserved.</div>" + "</div>" + "<img height=\"1\" width=\"985\" src=\"images/1px.gif\"/>" + "</div>" + "</td>" + "</tr>" + "</tbody>" + "</table>" + "</body></html>";
        try {
            user = OpenIDUtil.getUserName(req.getRequestURL().toString());
            if (log.isDebugEnabled()) {
                log.debug((Object)("OpenID url hit for the user " + user));
            }
        }
        catch (IdentityException e) {
            log.error((Object)"Failed to retreive the user name corresponding to the provided OpenID", (Throwable)e);
            resp.setContentType("text/html");
            this.printOutput(resp, errorBack);
            return;
        }
        backendServerURL = CarbonUIUtil.getServerURL((ServletContext)this.getServletConfig().getServletContext(), (HttpSession)req.getSession());
        configContext = (ConfigurationContext)this.getServletConfig().getServletContext().getAttribute("ConfigurationContext");
        opClient = new OpenIDAdminClient(configContext, backendServerURL, null);
        try {
            opInfo = opClient.getOpenIDProviderInfo(user, req.getRequestURL().toString());
        }
        catch (Exception e) {
            log.error((Object)"Failed to retreive the user name corresponding to the provided OpenID", (Throwable)e);
            resp.setContentType("text/html");
            this.printOutput(resp, errorBack);
            return;
        }
        serverUrl = opInfo.getOpenIDProviderServerUrl();
        OpenIDHandler.getInstance(serverUrl);
        resp.setContentType("text/html");
        back = "<html><head><link media=\"all\" type=\"text/css\" rel=\"stylesheet\" href=\"../carbon/openid-provider/css/openid-provider.css\" /><link media=\"all\" type=\"text/css\" rel=\"stylesheet\" href=\"../carbon/admin/css/global.css\" /><link media=\"all\" type=\"text/css\" rel=\"stylesheet\" href=\"" + mainCSS + "\">\n" + "<link rel='openid2.provider' href='" + serverUrl + "'/>\n" + "<link rel='openid.server' href='" + serverUrl + "'/>\n" + "</head>" + "<body>" + "<table cellspacing=\"0\" border=\"0\" id=\"main-table\">" + "<tbody>" + "<tr>" + "<td colspan=\"2\" id=\"header\">" + "<div id=\"header-div\">" + "<div class=\"right-logo\">Management Console</div>" + "<div class=\"left-logo\"><a class=\"header-home\" href=\"../carbon/admin/index.jsp\"><img height=\"32\" width=\"300\" src=\"../carbon/admin/images/1px.gif\"/></a>" + "</div>" + "</div>" + "</td>" + "</tr>" + "<tr>" + "<td valign=\"top\" id=\"menu-panel\">" + "<table cellspacing=\"0\" border=\"0\" id=\"menu-table\">" + "<tbody><tr><td id=\"region1\"><div id=\"menu\"><ul class=\"main\"><li class=\"menu-home\">&nbsp;</li></ul></div></td></tr></tbody>" + "</table>" + "</td>" + "<td id=\"middle-content\">" + "<div class=\"openid-box-top\"></div>" + "<table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" class=\"openid-box\">" + "<tr><td class=\"openid-box-08\"></td>" + "<td class=\"openid-box-back\">" + "<img src=\"../carbon/openid-provider/images/openid-biguser.gif\" align=\"middle\" hspace=\"50\" />This is the OpenID Url of user, <span class=\"openid-box-username\">" + user + "</span>" + "</td>" + "<td class=\"openid-box-04\"></td>" + "</tr>" + "<tr><td class=\"openid-box-07\"></td><td class=\"openid-box-06\"></td><td class=\"openid-box-05\"></td></tr>" + "</table>" + "</td>" + "</tr>" + "<tr>" + "<td colspan=\"2\" id=\"footer\">" + "<div id=\"footer-div\">" + "<div class=\"footer-content\">" + "<div class=\"copyright\">\u00a9 2008 - 2009 WSO2 Inc. All Rights Reserved.</div>" + "</div>" + "<img height=\"1\" width=\"985\" src=\"images/1px.gif\"/>" + "</div>" + "</td>" + "</tr>" + "</tbody>" + "</table>" + "</body></html>";
        this.printOutput(resp, back);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printOutput(HttpServletResponse resp, String output) throws IOException {
        PrintWriter out = null;
        try {
            out = resp.getWriter();
            out.write(output);
            out.flush();
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }
}

