/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.provider.openid.ui.handlers;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openid4java.message.Parameter;
import org.openid4java.message.ParameterList;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.provider.openid.stub.dto.OpenIDParameterDTO;
import org.wso2.carbon.ui.CarbonUIUtil;
import org.wso2.carbon.utils.TenantUtils;

public class OpenIDUtil {
    private static Log log = LogFactory.getLog(OpenIDUtil.class);
    private static final Set<Character> UNRESERVED_CHARACTERS = new HashSet<Character>();

    public static String getUserName(String rquestUrl) throws IdentityException {
        String caller = null;
        String path = null;
        URI uri = null;
        String contextPath = "/openid/";
        try {
            uri = new URI(rquestUrl);
            path = uri.getPath();
        }
        catch (URISyntaxException e) {
            throw new IdentityException("Invalid OpenID", (Throwable)e);
        }
        caller = path.substring(path.indexOf(contextPath) + contextPath.length(), path.length());
        return caller;
    }

    public static String generateOpenID(String user, String openIDUserUrl) throws IdentityException {
        String openID = null;
        URI uri = null;
        URL url = null;
        user = OpenIDUtil.normalizeUrlEncoding(user);
        openID = String.format(openIDUserUrl, user);
        try {
            uri = new URI(openID);
        }
        catch (URISyntaxException e) {
            log.error((Object)("Invalid OpenID URL :" + openID), (Throwable)e);
            throw new IdentityException("Invalid OpenID URL");
        }
        try {
            url = uri.normalize().toURL();
            if (url.getQuery() != null || url.getRef() != null) {
                log.error((Object)("Invalid user name for OpenID :" + openID));
                throw new IdentityException("Invalid user name for OpenID");
            }
        }
        catch (MalformedURLException e) {
            log.error((Object)("Malformed OpenID URL :" + openID), (Throwable)e);
            throw new IdentityException("Malformed OpenID URL");
        }
        openID = url.toString();
        if (log.isDebugEnabled()) {
            log.debug((Object)("OpenID generated successfully : " + openID));
        }
        return openID;
    }

    private static String normalizeUrlEncoding(String text) {
        if (text == null) {
            return null;
        }
        int len = text.length();
        StringBuffer normalized = new StringBuffer(len);
        for (int i = 0; i < len; ++i) {
            char current = text.charAt(i);
            if (current == '%' && i < len - 2) {
                String percentCode = text.substring(i, i + 3).toUpperCase();
                try {
                    String str = URLDecoder.decode(percentCode, "ISO-8859-1");
                    char chr = str.charAt(0);
                    if (UNRESERVED_CHARACTERS.contains(Character.valueOf(chr))) {
                        normalized.append(chr);
                    } else {
                        normalized.append(percentCode);
                    }
                }
                catch (UnsupportedEncodingException e) {
                    normalized.append(percentCode);
                }
                i += 2;
                continue;
            }
            normalized.append(current);
        }
        return normalized.toString();
    }

    public static String getRelyingPartyUrl(String rpUrl) throws IdentityException {
        URI uri = null;
        URL url = null;
        try {
            uri = new URI(rpUrl);
        }
        catch (URISyntaxException e) {
            log.error((Object)("Invalid relying party URL :" + rpUrl), (Throwable)e);
            throw new IdentityException("Invalid relying party URL");
        }
        try {
            url = uri.normalize().toURL();
            url = new URL(url.getProtocol().toLowerCase(), url.getHost().toLowerCase(), url.getPort(), url.getPath());
            return url.toString();
        }
        catch (MalformedURLException e) {
            log.error((Object)("Malformed relying party URL :" + rpUrl), (Throwable)e);
            throw new IdentityException("Malformed relying party URL");
        }
    }

    public static OpenIDParameterDTO[] getOpenIDAuthRequest(ParameterList request) {
        OpenIDParameterDTO[] params = null;
        List list = null;
        list = request.getParameters();
        params = new OpenIDParameterDTO[list.size()];
        int i = 0;
        for (Object object : list) {
            Parameter param = (Parameter)object;
            OpenIDParameterDTO openIDParameterDTO = new OpenIDParameterDTO();
            openIDParameterDTO.setName(param.getKey());
            openIDParameterDTO.setValue(param.getValue());
            params[i++] = openIDParameterDTO;
        }
        return params;
    }

    public static OpenIDParameterDTO[] getOpenIDAuthRequest(HttpServletRequest request) {
        List<OpenIDParameterDTO> params = null;
        params = OpenIDUtil.getOpenIDAuthRequestAsList(request);
        return params.toArray(new OpenIDParameterDTO[params.size()]);
    }

    public static List<OpenIDParameterDTO> getOpenIDAuthRequestAsList(HttpServletRequest request) {
        Map parameterMap = null;
        Iterator keysIter = null;
        ArrayList<OpenIDParameterDTO> params = null;
        OpenIDParameterDTO param = null;
        parameterMap = request.getParameterMap();
        keysIter = parameterMap.keySet().iterator();
        params = new ArrayList<OpenIDParameterDTO>();
        while (keysIter.hasNext()) {
            String value;
            String name = (String)keysIter.next();
            Object v = parameterMap.get(name);
            if (v instanceof String[]) {
                String[] values = (String[])v;
                if (values.length > 1 && name.startsWith("openid.")) {
                    throw new IllegalArgumentException("Multiple parameters with the same name: " + values);
                }
                value = values.length > 0 ? values[0] : null;
            } else {
                value = v instanceof String ? (String)v : "";
            }
            param = new OpenIDParameterDTO();
            param.setName(name);
            param.setValue(value);
            params.add(param);
        }
        return params;
    }

    public static String getOpenID(String userName) throws Exception {
        return OpenIDUtil.generateOpenID(userName, "");
    }

    public static String getFronEndUrl(String openId, HttpServletRequest request, String relativeUrl) throws Exception {
        String tenant = TenantUtils.getDomainNameFromOpenId((String)openId);
        if (OpenIDUtil.getHostName().equals(tenant)) {
            tenant = null;
        }
        String frontEndUrl = OpenIDUtil.getAdminConsoleURL(request) + relativeUrl;
        if (tenant != null && tenant.trim().length() > 0) {
            return frontEndUrl.replace("/carbon/", "/t/" + tenant + "/carbon/");
        }
        return frontEndUrl;
    }

    public static String getAdminConsoleURL(HttpServletRequest request) {
        String url = CarbonUIUtil.getAdminConsoleURL((HttpServletRequest)request);
        if (url.indexOf("/openidserver/") != -1) {
            url = url.replace("/openidserver", "");
        }
        return url;
    }

    private static String getHostName() {
        ServerConfiguration serverConfig = ServerConfiguration.getInstance();
        if (serverConfig.getFirstProperty("HostName") != null) {
            return TenantUtils.getDomainNameFromOpenId((String)serverConfig.getFirstProperty("HostName"));
        }
        return "localhost";
    }
}

