/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.provider.openid.ui.handlers;

import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openid4java.message.DirectError;
import org.openid4java.message.ParameterList;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.provider.openid.stub.dto.OpenIDAuthRequestDTO;
import org.wso2.carbon.identity.provider.openid.stub.dto.OpenIDAuthResponseDTO;
import org.wso2.carbon.identity.provider.openid.stub.dto.OpenIDParameterDTO;
import org.wso2.carbon.identity.provider.openid.stub.dto.PapeInfoRequestDTO;
import org.wso2.carbon.identity.provider.openid.stub.dto.PapeInfoResponseDTO;
import org.wso2.carbon.identity.provider.openid.ui.client.OpenIDAdminClient;
import org.wso2.carbon.identity.provider.openid.ui.handlers.OpenIDUtil;
import org.wso2.carbon.ui.CarbonUIUtil;
import org.wso2.carbon.utils.TenantUtils;

public class OpenIDHandler {
    private String frontEndUrl;
    private String opAddress;
    private static OpenIDHandler provider;
    private static Log log;

    private OpenIDHandler(String serverUrl) {
        this.opAddress = serverUrl;
    }

    public static OpenIDHandler getInstance(String serverUrl) {
        if (provider == null) {
            provider = new OpenIDHandler(serverUrl);
        }
        return provider;
    }

    public void setFrontEndUrl(String frontEndUrl) {
        this.frontEndUrl = frontEndUrl;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Authentication page set to :" + this.frontEndUrl));
        }
    }

    public String getOpAddress() {
        return this.opAddress;
    }

    public String processRequest(HttpServletRequest request, HttpServletResponse response) throws IdentityException {
        if (request.getParameter("logoutUrl") != null && request.getSession().getAttribute("authenticatedOpenID") != null) {
            log.info((Object)("OpenID Single Logout for " + request.getSession().getAttribute("authenticatedOpenID")));
            request.getSession().setAttribute("authenticatedOpenID", null);
            Cookie[] cookies = request.getCookies();
            Object token = null;
            if (cookies != null) {
                Cookie curCookie = null;
                for (int x = 0; x < cookies.length; ++x) {
                    curCookie = cookies[x];
                    if (!curCookie.getName().equalsIgnoreCase("openidtoken")) continue;
                    curCookie.setMaxAge(0);
                    response.addCookie(curCookie);
                    break;
                }
            }
            return request.getParameter("logoutUrl");
        }
        ParameterList paramList = null;
        String responseText = null;
        HttpSession session = null;
        OpenIDAdminClient client = null;
        String cookie = null;
        ConfigurationContext configContext = null;
        String serverURL = null;
        if (request == null || response == null) {
            throw new IdentityException("Required attributes missing");
        }
        try {
            String mode;
            session = request.getSession();
            serverURL = CarbonUIUtil.getServerURL((ServletContext)session.getServletContext(), (HttpSession)session);
            configContext = (ConfigurationContext)session.getServletContext().getAttribute("ConfigurationContext");
            cookie = (String)session.getAttribute("OPENID_ADMIN_COOKIE");
            client = new OpenIDAdminClient(configContext, serverURL, cookie);
            paramList = "complete".equals(session.getAttribute("_action")) || "cancel".equals(session.getAttribute("_action")) ? (ParameterList)session.getAttribute("parameterlist") : new ParameterList(request.getParameterMap());
            if (paramList == null) {
                responseText = this.getErrorResponseText("Invalid OpenID authentication request");
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Invalid OpenID authentication request :" + responseText));
                }
                this.directResponse(response, responseText);
                return null;
            }
            String string = mode = paramList.hasParameter("openid.mode") ? paramList.getParameterValue("openid.mode") : null;
            if (log.isDebugEnabled()) {
                log.debug((Object)("OpenID authentication mode :" + mode));
            }
            if ("associate".equals(mode)) {
                responseText = client.getOpenIDAssociationResponse(OpenIDUtil.getOpenIDAuthRequest(request));
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Association created successfully");
                }
            } else {
                if ("checkid_setup".equals(mode) || "checkid_immediate".equals(mode)) {
                    return this.checkSetupOrImmediate(request, paramList);
                }
                if ("check_authentication".equals(mode)) {
                    responseText = client.verify(OpenIDUtil.getOpenIDAuthRequest(request));
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Authentication verified successfully");
                    }
                } else {
                    responseText = this.getErrorResponseText("No valid OpenID found in the authentication request");
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"No valid OpenID found in the authentication request");
                    }
                }
            }
        }
        catch (Exception e) {
            responseText = this.getErrorResponseText(e.getMessage());
        }
        try {
            this.directResponse(response, responseText);
        }
        catch (IOException e) {
            log.error((Object)e.getMessage());
            throw new IdentityException("OpenID redirect reponse failed");
        }
        return null;
    }

    private String checkSetupOrImmediate(HttpServletRequest request, ParameterList params) throws Exception {
        String openIdInSession;
        boolean authenticated = false;
        String userSelectedClaimedId = null;
        String openId = null;
        HttpSession session = null;
        String profileName = null;
        session = request.getSession();
        String string = openId = params.hasParameter("openid.identity") ? params.getParameterValue("openid.identity") : null;
        if (openId != null && openId.endsWith("/openid/") && (openIdInSession = (String)session.getAttribute("openId")) != null && !"".equals(openIdInSession.trim())) {
            openId = openIdInSession;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Authentication check for OpenID " + openId));
        }
        if (openId == null) {
            throw new IdentityException("Required attributes missing");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Authentication check for user " + openId));
        }
        boolean completed = "complete".equals(session.getAttribute("_action"));
        boolean approved = "true".equals(session.getAttribute("userApproved"));
        String serverURL = CarbonUIUtil.getServerURL((ServletContext)session.getServletContext(), (HttpSession)session);
        ConfigurationContext configContext = (ConfigurationContext)session.getServletContext().getAttribute("ConfigurationContext");
        OpenIDAdminClient openIDAdmin = new OpenIDAdminClient(configContext, serverURL, (String)session.getAttribute("OPENID_ADMIN_COOKIE"));
        if (completed && approved) {
            session.removeAttribute("userApproved");
            session.removeAttribute("_action");
            profileName = (String)session.getAttribute("profile");
            session.removeAttribute("profile");
            authenticated = true;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Authenticated and user confirmed :" + openId));
            }
            if ((profileName = (String)session.getAttribute("selectedProfile")) == null) {
                profileName = "default";
            }
            boolean alwaysApprovedRp = Boolean.parseBoolean((String)session.getAttribute("userApprovedAlways")) ? true : Boolean.parseBoolean(request.getParameter("hasApprovedAlways"));
            openIDAdmin.updateOpenIDUserRPInfo(params.getParameterValue("openid.return_to"), alwaysApprovedRp, profileName, openId);
        }
        if ("cancel".equals(session.getAttribute("_action"))) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("User cancelled :" + openId));
            }
            authenticated = false;
        } else if (!authenticated) {
            session.setAttribute("parameterlist", (Object)params);
            if (log.isDebugEnabled()) {
                log.debug((Object)("User not authenticated. Redirecting to the authentication page :" + openId));
            }
            PapeInfoRequestDTO papeInfoRequestDTO = new PapeInfoRequestDTO();
            papeInfoRequestDTO.setParamList(OpenIDUtil.getOpenIDAuthRequest(params));
            papeInfoRequestDTO.setOpenID(openId);
            PapeInfoResponseDTO papeInfoResponseDTO = openIDAdmin.getPapeInfo(papeInfoRequestDTO);
            OpenIDParameterDTO[] parameterSet = papeInfoResponseDTO.getPolicies();
            String tenant = TenantUtils.getDomainNameFromOpenId((String)openId);
            String returnUrl = null;
            if (parameterSet[0].getValue().equals("true") || parameterSet[1].getValue().equals("true")) {
                returnUrl = CarbonUIUtil.getAdminConsoleURL((HttpServletRequest)request) + "openid-provider/PAPE_info.jsp";
                session.setAttribute("papePhishingResistance", (Object)parameterSet[0].getValue());
                session.setAttribute("multiFactorAuth", (Object)parameterSet[1].getValue());
                session.setAttribute("infoCardBasedMultiFacotrAuth", (Object)parameterSet[2].getValue());
                session.setAttribute("xmppBasedMultiFacotrAuth", (Object)parameterSet[3].getValue());
                if (tenant != null && tenant.trim().length() > 0) {
                    return returnUrl.replace("/carbon/", "/t/" + tenant + "/carbon/");
                }
                return returnUrl;
            }
            returnUrl = this.frontEndUrl;
            Cookie[] cookies = request.getCookies();
            String token = null;
            if (cookies != null) {
                Cookie curCookie = null;
                Cookie[] arr$ = cookies;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    Cookie cookie;
                    curCookie = cookie = arr$[i$];
                    params.getParameterValue("openid.return_to");
                    if (!curCookie.getName().equalsIgnoreCase("openidtoken")) continue;
                    token = curCookie.getValue();
                    break;
                }
            }
            if (token != null && !"null".equals(token) || session.getAttribute("authenticatedOpenID") != null && session.getAttribute("authenticatedOpenID").equals(openId)) {
                session.setAttribute("openId", (Object)openId);
                returnUrl = returnUrl.replace("openid-provider/openid_auth.jsp", "openid-provider/openid_auth_submit.jsp");
            }
            if (tenant != null && tenant.trim().length() > 0) {
                return returnUrl.replace("/carbon/", "/t/" + tenant + "/carbon/");
            }
            return returnUrl;
        }
        session.removeAttribute("parameterlist");
        String opLocalId = null;
        OpenIDAuthRequestDTO openIDAuthRequest = null;
        OpenIDAuthResponseDTO openIDAuthResponse = null;
        openIDAuthRequest = new OpenIDAuthRequestDTO();
        if ("true".equals(session.getAttribute("phishingResistanceAuthentication"))) {
            openIDAuthRequest.setPhishiingResistanceAuthRequest(true);
            session.removeAttribute("phishingResistanceAuthentication");
        }
        if ("true".equals(session.getAttribute("multifactorlogin"))) {
            openIDAuthRequest.setMultiFactorAuthRequested(true);
            session.removeAttribute("multifactorlogin");
        }
        openIDAuthRequest.setParams(OpenIDUtil.getOpenIDAuthRequest(params));
        openIDAuthRequest.setOpLocalId(opLocalId);
        openIDAuthRequest.setUserSelectedClaimedId(userSelectedClaimedId);
        openIDAuthRequest.setAuthenticated(authenticated);
        openIDAuthRequest.setOpenID(openId);
        openIDAuthRequest.setProfileName(profileName);
        openIDAuthResponse = openIDAdmin.getOpenIDAuthResponse(openIDAuthRequest);
        if (openIDAuthResponse != null) {
            return openIDAuthResponse.getDestinationUrl();
        }
        return null;
    }

    private String getErrorResponseText(String message) {
        log.error((Object)message);
        return DirectError.createDirectError((String)message).keyValueFormEncoding();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void directResponse(HttpServletResponse httpResp, String response) throws IOException {
        ServletOutputStream stream = null;
        try {
            stream = httpResp.getOutputStream();
            stream.write(response.getBytes());
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    static {
        log = LogFactory.getLog(OpenIDHandler.class);
    }
}

