/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.provider.openid.ui.client;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openid4java.message.Parameter;
import org.openid4java.message.ParameterList;
import org.wso2.carbon.identity.provider.openid.stub.OpenIDProviderServiceStub;
import org.wso2.carbon.identity.provider.openid.stub.dto.InfoCardDTO;
import org.wso2.carbon.identity.provider.openid.stub.dto.InfoCardSignInDTO;
import org.wso2.carbon.identity.provider.openid.stub.dto.OpenIDAuthRequestDTO;
import org.wso2.carbon.identity.provider.openid.stub.dto.OpenIDAuthResponseDTO;
import org.wso2.carbon.identity.provider.openid.stub.dto.OpenIDClaimDTO;
import org.wso2.carbon.identity.provider.openid.stub.dto.OpenIDParameterDTO;
import org.wso2.carbon.identity.provider.openid.stub.dto.OpenIDProviderInfoDTO;
import org.wso2.carbon.identity.provider.openid.stub.dto.OpenIDRememberMeDTO;
import org.wso2.carbon.identity.provider.openid.stub.dto.OpenIDUserProfileDTO;
import org.wso2.carbon.identity.provider.openid.stub.dto.OpenIDUserRPDTO;
import org.wso2.carbon.identity.provider.openid.stub.dto.PapeInfoRequestDTO;
import org.wso2.carbon.identity.provider.openid.stub.dto.PapeInfoResponseDTO;
import org.wso2.carbon.identity.provider.openid.ui.handlers.OpenIDHandler;

public class OpenIDAdminClient {
    public static final String OPENID_ADMIN_COOKIE = "OPENID_ADMIN_COOKIE";
    private OpenIDProviderServiceStub stub;
    private String newCookieValue;
    private static Log log = LogFactory.getLog(OpenIDHandler.class);

    public String getNewCookieValue() {
        return this.newCookieValue;
    }

    public void setNewCookieValue(String newCookieValue) {
        this.newCookieValue = newCookieValue;
    }

    public OpenIDAdminClient(ConfigurationContext context, String backendServerURL, String cookie) throws AxisFault {
        if (backendServerURL.indexOf("${carbon.context}") != -1) {
            String contextPath = null;
            contextPath = context.getContextRoot();
            if ("/".equals(contextPath)) {
                contextPath = "";
            }
            backendServerURL = backendServerURL.replace("${carbon.context}", contextPath);
        }
        String serviceURL = backendServerURL + "OpenIDProviderService";
        this.stub = new OpenIDProviderServiceStub(context, serviceURL);
        this.stub._getServiceClient().getOptions().setTimeOutInMilliSeconds(120000L);
        if (cookie != null) {
            this.stub._getServiceClient().getOptions().setProperty("Cookie", (Object)cookie);
        }
    }

    public OpenIDProviderInfoDTO getOpenIDProviderInfo(String userName, String openID) throws Exception {
        return this.stub.getOpenIDProviderInfo(userName, openID);
    }

    public boolean authenticateWithOpenID(String openId, String password, HttpSession session, HttpServletRequest request, HttpServletResponse response, boolean useRememberMe) {
        String cookie = null;
        boolean isAuthenticated = false;
        OpenIDRememberMeDTO dto = null;
        try {
            Cookie[] cookies = request.getCookies();
            String token = null;
            if (cookies != null) {
                Cookie curCookie = null;
                for (int x = 0; x < cookies.length; ++x) {
                    curCookie = cookies[x];
                    if (!curCookie.getName().equalsIgnoreCase("openidtoken")) continue;
                    token = curCookie.getValue();
                    break;
                }
            }
            if (token != null && !"null".equals(token) || useRememberMe) {
                dto = this.stub.authenticateWithOpenIDRememberMe(openId.trim(), password, request.getRemoteAddr(), token);
                if (dto != null && dto.getAuthenticated()) {
                    this.newCookieValue = dto.getNewCookieValue();
                }
                isAuthenticated = dto.getAuthenticated();
            } else {
                isAuthenticated = this.stub.authenticateWithOpenID(openId.trim(), password);
            }
            cookie = (String)this.stub._getServiceClient().getServiceContext().getProperty("Cookie");
            session.setAttribute(OPENID_ADMIN_COOKIE, (Object)cookie);
        }
        catch (Exception e) {
            return false;
        }
        return isAuthenticated;
    }

    public Map<String, OpenIDClaimDTO> getClaimValues(String openId, String profileId, ParameterList requredClaims) throws Exception {
        int i;
        HashMap<String, OpenIDClaimDTO> map = null;
        map = new HashMap<String, OpenIDClaimDTO>();
        OpenIDClaimDTO[] claims = null;
        OpenIDParameterDTO[] params = null;
        List list = null;
        try {
            list = requredClaims.getParameters();
            params = new OpenIDParameterDTO[list.size()];
            i = 0;
            for (Object object : list) {
                Parameter param = (Parameter)object;
                OpenIDParameterDTO openIDParameterDTO = new OpenIDParameterDTO();
                openIDParameterDTO.setName(param.getKey());
                openIDParameterDTO.setValue(param.getValue());
                params[i++] = openIDParameterDTO;
            }
            claims = this.stub.getClaimValues(openId.trim(), profileId, params);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (claims != null) {
            for (i = 0; i < claims.length; ++i) {
                if (claims[i] == null) continue;
                map.put(claims[i].getClaimUri(), claims[i]);
            }
        }
        return map;
    }

    public OpenIDAuthResponseDTO getOpenIDAuthResponse(OpenIDAuthRequestDTO authRequest) throws Exception {
        return this.stub.getOpenIDAuthResponse(authRequest);
    }

    public String getOpenIDAssociationResponse(OpenIDParameterDTO[] params) throws Exception {
        return this.stub.getOpenIDAssociationResponse(params);
    }

    public String verify(OpenIDParameterDTO[] params) throws Exception {
        return this.stub.verify(params);
    }

    public InfoCardSignInDTO signInWithInfoCard(InfoCardDTO inforCard) throws Exception {
        return this.stub.signInWithInfoCard(inforCard);
    }

    public String getCookie() {
        return (String)this.stub._getServiceClient().getServiceContext().getProperty("Cookie");
    }

    public PapeInfoResponseDTO getPapeInfo(PapeInfoRequestDTO reqDTO) throws Exception {
        return this.stub.retrievePapeInfo(reqDTO);
    }

    public boolean doxmppBasedMultiFactorAuthForInfoCards(String userId) throws Exception {
        return this.stub.doXMPPBasedMultiFactorAuthForInfocard(userId);
    }

    public OpenIDUserProfileDTO[] getUserProfiles(String openid, ParameterList requredClaims) throws Exception {
        OpenIDParameterDTO[] params = null;
        List list = null;
        list = requredClaims.getParameters();
        params = new OpenIDParameterDTO[list.size()];
        int i = 0;
        for (Object object : list) {
            Parameter param = (Parameter)object;
            OpenIDParameterDTO openIDParameterDTO = new OpenIDParameterDTO();
            openIDParameterDTO.setName(param.getKey());
            openIDParameterDTO.setValue(param.getValue());
            params[i++] = openIDParameterDTO;
        }
        return this.stub.getUserProfiles(openid, params);
    }

    public void updateOpenIDUserRPInfo(String rpUrl, boolean isTrustedAlways, String defaultProfileName, String openID) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Updating RP " + rpUrl + "info for " + openID));
        }
        OpenIDUserRPDTO rpdto = new OpenIDUserRPDTO();
        rpdto.setRpUrl(rpUrl);
        rpdto.setTrustedAlways(isTrustedAlways);
        rpdto.setDefaultProfileName(defaultProfileName);
        rpdto.setOpenID(openID);
        this.stub.updateOpenIDUserRPInfo(rpdto);
    }

    public OpenIDUserRPDTO[] getOpenIDUserRPs(String openID) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Getting OpenID User RP DTOs for " + openID));
        }
        return this.stub.getOpenIDUserRPs(openID);
    }

    public OpenIDUserRPDTO getOpenIDUserRPDTO(String openID, String rpUrl) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Getting OpenID User RP DTO for " + openID + "for RP " + rpUrl));
        }
        return this.stub.getOpenIDUserRPInfo(openID, rpUrl);
    }

    public String[] getOpenIDUserRPInfo(String openID, String rpUrl) throws Exception {
        OpenIDUserRPDTO rpdto = this.stub.getOpenIDUserRPInfo(openID, rpUrl);
        String[] rpInfo = new String[7];
        if (rpdto != null) {
            rpInfo[0] = new Boolean(rpdto.getTrustedAlways()).toString();
            rpInfo[1] = rpdto.getDefaultProfileName();
            rpInfo[2] = rpdto.getOpenID();
            rpInfo[3] = rpdto.getRpUrl();
            rpInfo[4] = rpdto.getUserName();
            rpInfo[5] = Integer.toString(rpdto.getVisitCount());
            if (rpdto.getLastVisit() == null) {
                rpdto.setLastVisit(new Date());
            }
            rpInfo[6] = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").format(rpdto.getLastVisit());
        } else {
            rpInfo[0] = "false";
        }
        return rpInfo;
    }

    public boolean isOpenIDUserApprovalBypassEnabled() throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Checking OpenIDUserApprovalBypass settings in identity.xml");
        }
        return this.stub.isOpenIDUserApprovalBypassEnabled();
    }
}

