/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.relyingparty.ui.openid.extensions;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openid4java.message.AuthSuccess;
import org.openid4java.message.MessageException;
import org.openid4java.message.MessageExtension;
import org.openid4java.message.pape.PapeRequest;
import org.openid4java.message.pape.PapeResponse;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.relyingparty.stub.dto.ClaimDTO;
import org.wso2.carbon.identity.relyingparty.ui.openid.AuthPolicyType;
import org.wso2.carbon.identity.relyingparty.ui.openid.OpenIDAuthenticationRequest;
import org.wso2.carbon.identity.relyingparty.ui.openid.extensions.OpenIDExtension;

public class OpenIDPape
implements OpenIDExtension {
    private AuthSuccess authSuccess;
    private static Log log = LogFactory.getLog(OpenIDPape.class);

    public OpenIDPape() {
    }

    public OpenIDPape(AuthSuccess authSuccess) {
        this.authSuccess = authSuccess;
    }

    @Override
    public MessageExtension getMessageExtension(OpenIDAuthenticationRequest request) throws IdentityException {
        PapeRequest papeReq = null;
        papeReq = PapeRequest.createPapeRequest();
        for (AuthPolicyType authType : request.getAuthTypes()) {
            switch (authType) {
                case PAPE_POLICY_MULTI_FACTOR: {
                    papeReq.addPreferredAuthPolicy("http://schemas.openid.net/pape/policies/2007/06/multi-factor");
                    break;
                }
                case PAPE_POLICY_MULTI_FACTOR_PHYSICAL: {
                    papeReq.addPreferredAuthPolicy("http://schemas.openid.net/pape/policies/2007/06/multi-factor-physical");
                    break;
                }
                case PAPE_POLICY_PHISHING_RESISTANT: {
                    papeReq.addPreferredAuthPolicy("http://schemas.openid.net/pape/policies/2007/06/phishing-resistant");
                    break;
                }
            }
        }
        return papeReq;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setSessionAttributes(List<ClaimDTO> claimList) throws IdentityException {
        try {
            PapeResponse papeResponse = null;
            if (!this.authSuccess.hasExtension("http://specs.openid.net/extensions/pape/1.0")) return;
            papeResponse = (PapeResponse)this.authSuccess.getExtension("http://specs.openid.net/extensions/pape/1.0");
            if (papeResponse == null) return;
        }
        catch (MessageException e) {
            log.error((Object)"Error while adding retrieved user attributes to the session in OpenIDPape", (Throwable)e);
            throw new IdentityException("Error while adding retrieved user attributes to the session in OpenIDPape", (Throwable)e);
        }
    }
}

