/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.relyingparty.ui.openid;

import org.openid4java.message.AuthSuccess;
import org.wso2.carbon.identity.relyingparty.ui.openid.extensions.OpenIDAttributeExchange;
import org.wso2.carbon.identity.relyingparty.ui.openid.extensions.OpenIDExtension;
import org.wso2.carbon.identity.relyingparty.ui.openid.extensions.OpenIDPape;
import org.wso2.carbon.identity.relyingparty.ui.openid.extensions.OpenIDSimpleReg;

public class OpenIDExtensionFactory {
    private static OpenIDExtensionFactory factory = new OpenIDExtensionFactory();

    private OpenIDExtensionFactory() {
    }

    public static OpenIDExtensionFactory getInstance() {
        return factory;
    }

    public OpenIDExtension getExtension(String type) {
        if ("ax".equals(type)) {
            return new OpenIDAttributeExchange();
        }
        if ("sreg".equals(type)) {
            return new OpenIDSimpleReg();
        }
        if ("pape".equals(type)) {
            return new OpenIDPape();
        }
        return null;
    }

    public OpenIDExtension getExtension(String alias, AuthSuccess auth) {
        if (alias.equals("http://openid.net/srv/ax/1.0") || alias.equals("http://openid.net/srv/ax/1.0")) {
            return new OpenIDAttributeExchange(auth);
        }
        if (alias.equals("http://openid.net/sreg/1.0") || alias.equals("http://openid.net/sreg/1.0") || alias.equals("http://openid.net/extensions/sreg/1.1")) {
            return new OpenIDSimpleReg(auth);
        }
        if (alias.equals("http://specs.openid.net/extensions/pape/1.0")) {
            return new OpenIDPape(auth);
        }
        return null;
    }
}

