/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.relyingparty.ui.client;

import com.google.step2.Step2;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.neethi.Policy;
import org.wso2.carbon.identity.base.IdentityBaseUtil;
import org.wso2.carbon.identity.relyingparty.stub.RelyingPartyServiceStub;
import org.wso2.carbon.identity.relyingparty.stub.dto.ClaimDTO;
import org.wso2.carbon.identity.relyingparty.stub.dto.InfoCardAuthInfoDTO;
import org.wso2.carbon.identity.relyingparty.stub.dto.InfoCardDTO;
import org.wso2.carbon.identity.relyingparty.stub.dto.InfoCardSignInDTO;
import org.wso2.carbon.identity.relyingparty.stub.dto.OpenIDAuthInfoDTO;
import org.wso2.carbon.identity.relyingparty.stub.dto.OpenIDDTO;
import org.wso2.carbon.identity.relyingparty.stub.dto.OpenIDSignInDTO;
import org.wso2.carbon.identity.relyingparty.ui.openid.OpenIDAuthenticationRequest;

public class RelyingPartyServiceClient {
    private RelyingPartyServiceStub stub;
    private static final Log log = LogFactory.getLog(RelyingPartyServiceClient.class);

    public RelyingPartyServiceClient(String cookie, String backendServerURL, ConfigurationContext configCtx) throws AxisFault {
        String serviceURL = backendServerURL + "RelyingPartyService";
        try {
            this.stub = new RelyingPartyServiceStub(configCtx, serviceURL);
            ServiceClient client = this.stub._getServiceClient();
            client.engageModule("rampart");
            Policy rampartConfig = IdentityBaseUtil.getDefaultRampartConfig();
            Policy signOnly = IdentityBaseUtil.getSignOnlyPolicy();
            Policy mergedPolicy = signOnly.merge(rampartConfig);
            Options option = client.getOptions();
            option.setProperty("rampartPolicy", (Object)mergedPolicy);
            option.setManageSession(true);
            if (cookie != null) {
                option.setProperty("Cookie", (Object)cookie);
            }
        }
        catch (Exception e) {
            this.handleException("Error initializing Relying Party Client", e);
        }
    }

    public InfoCardSignInDTO signInWithInfoCard(InfoCardDTO infocard) throws AxisFault {
        try {
            return this.stub.signInWithInfoCard(infocard);
        }
        catch (Exception e) {
            this.handleException("Error ouccured while siging in with InfoCard", e);
            return null;
        }
    }

    public String getCookie() {
        return (String)this.stub._getServiceClient().getServiceContext().getProperty("Cookie");
    }

    public OpenIDAuthenticationRequest getOpenIDAuthInfo(HttpServletRequest request, HttpServletResponse response, String dialect) throws AxisFault {
        OpenIDAuthInfoDTO dto = null;
        OpenIDAuthenticationRequest authRequest = null;
        try {
            if (dialect == null) {
                dialect = "http://schema.openid.net/2007/05/claims";
            }
            dto = this.stub.getOpenIDAuthInfo(dialect);
            authRequest = new OpenIDAuthenticationRequest(request, response);
            if (dto != null) {
                for (String requestType : dto.getRequestTypes()) {
                    authRequest.addRequestType(requestType);
                }
                for (String optionalClaim : dto.getOptionalClaims()) {
                    authRequest.addOptionalClaims(optionalClaim);
                }
                for (String reqClaim : dto.getRequiredClaims()) {
                    authRequest.addRequiredClaims(reqClaim);
                }
                authRequest.setRealm(dto.getRealm());
                authRequest.setRequestClaimsFromIdP(dto.getRequestClaimsFromIdP());
            }
        }
        catch (Exception e) {
            this.handleException(" Error while retrieving OpenID login info. " + e.getMessage(), e);
        }
        return authRequest;
    }

    public OpenIDSignInDTO signInWithOpenID(OpenIDDTO openID) throws AxisFault {
        try {
            return this.stub.signInWithOpenID(openID);
        }
        catch (Exception e) {
            this.handleException("Error while signing in. " + e.getMessage(), e);
            return null;
        }
    }

    public void signInGAppUser(HttpServletRequest request, HttpServletResponse response, OpenIDDTO openId, String gappDomainName) throws Exception {
        try {
            ClaimDTO[] claims = openId.getClaims();
            String username = null;
            for (ClaimDTO claim : claims) {
                if (!claim.getClaimUri().equals(Step2.AxSchema.EMAIL.getUri())) continue;
                username = claim.getClaimValue();
            }
            ServiceClient client = this.stub._getServiceClient();
            Options options = client.getOptions();
            options.setManageSession(true);
            this.stub.signInGAppUser(openId, gappDomainName);
            request.setAttribute("gapp.openid.username", (Object)username);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new Exception(e.getMessage(), e);
        }
    }

    public InfoCardAuthInfoDTO getInfoCardAuthInfo() throws AxisFault {
        try {
            return this.stub.getInfoCardAuthInfo();
        }
        catch (Exception e) {
            this.handleException("Error ouccured retrieving information card authnetication information", e);
            return null;
        }
    }

    public boolean addOpenIDToProfile(OpenIDDTO dto) throws AxisFault {
        try {
            return this.stub.addOpenIdToProfile(dto);
        }
        catch (Exception e) {
            this.handleException("Error occured when trying to associate the OpenId with the user profile.", e);
            return false;
        }
    }

    private void handleException(String msg, Exception e) throws AxisFault {
        log.error((Object)msg, (Throwable)e);
        throw new AxisFault(msg, (Throwable)e);
    }
}

