/*
 * Decompiled with CFR 0.152.
 */
package com.google.step2.openid.ui;

import com.google.step2.openid.ui.UiMessage;
import java.util.Locale;
import org.openid4java.message.Parameter;
import org.openid4java.message.ParameterList;

public class UiMessageRequest
extends UiMessage {
    private String language = null;
    private UiMessage.UiMode mode = null;
    private Boolean icon = null;

    public ParameterList getParameters() {
        ParameterList list = new ParameterList();
        if (this.language != null) {
            list.set(new Parameter("lang", this.language));
        }
        if (this.mode != null) {
            list.set(new Parameter("mode", this.mode.getMode()));
        }
        if (this.icon != null) {
            list.set(new Parameter("icon", this.icon.toString()));
        }
        return list;
    }

    public void setParameters(ParameterList params) {
        this.setLanguage(params);
        this.setMode(params);
        this.setIcon(params);
    }

    public void setLanguage(Locale locale) {
        this.language = locale.toString();
    }

    public void setUiMode(UiMessage.UiMode uiMode) {
        this.mode = uiMode;
    }

    public void setIconRequest(boolean requestIcon) {
        this.icon = requestIcon;
    }

    private void setIcon(ParameterList params) {
        String iconValue = params.getParameterValue("icon");
        if (iconValue == null || iconValue.trim().equals("")) {
            return;
        }
        this.icon = Boolean.valueOf(iconValue);
    }

    private void setMode(ParameterList params) {
        String modeString = params.getParameterValue("mode");
        if (modeString == null || modeString.trim().equals("")) {
            return;
        }
        if (modeString.equals(UiMessage.UiMode.POPUP.getMode())) {
            this.mode = UiMessage.UiMode.POPUP;
        }
    }

    private void setLanguage(ParameterList params) {
        String languageString = params.getParameterValue("lang");
        if (languageString == null || languageString.trim().equals("")) {
            return;
        }
        this.language = languageString;
    }
}

