/*
 * Decompiled with CFR 0.152.
 */
package com.google.step2.openid.ax2;

import com.google.step2.openid.ax2.FetchRequest2;
import com.google.step2.openid.ax2.FetchResponse2;
import com.google.step2.openid.ax2.Mode;
import org.openid4java.message.MessageException;
import org.openid4java.message.MessageExtension;
import org.openid4java.message.ParameterList;
import org.openid4java.message.ax.AxMessage;

public class AxMessage2
extends AxMessage {
    static final String MODE = "mode";
    public static final String OPENID_NS_AX_FINAL = "http://openid.net/srv/ax/1.0";

    public String getTypeUri() {
        return OPENID_NS_AX_FINAL;
    }

    public AxMessage2() {
    }

    public AxMessage2(ParameterList params) {
        super(params);
    }

    public boolean providesIdentifier() {
        return true;
    }

    public boolean signRequired() {
        return true;
    }

    public MessageExtension getExtension(ParameterList parameterList, boolean isRequest) throws MessageException {
        if (parameterList.hasParameter(MODE)) {
            String mode = parameterList.getParameterValue(MODE);
            Mode modeEnum = Mode.getMode(mode);
            switch (modeEnum) {
                case FETCH_REQUEST: {
                    return FetchRequest2.createFetchRequest2(parameterList);
                }
                case FETCH_RESPONSE: {
                    return FetchResponse2.createFetchResponse2(parameterList);
                }
            }
            return super.getExtension(parameterList, isRequest);
        }
        throw new MessageException("Attribure exchange message is missing a mode.");
    }
}

