/*
 * Decompiled with CFR 0.152.
 */
package com.google.step2.hybrid;

import com.google.step2.hybrid.HybridOauthMessage;
import java.util.Arrays;
import java.util.List;
import org.openid4java.message.MessageException;
import org.openid4java.message.Parameter;
import org.openid4java.message.ParameterList;

public class HybridOauthResponse
extends HybridOauthMessage {
    private static final List<String> requiredFields = Arrays.asList(new Object[0]);
    private static final List<String> optionalFields = Arrays.asList("scope", "request_token");

    HybridOauthResponse(ParameterList parameters) throws MessageException {
        this.parameters = parameters;
        if (!this.isValid()) {
            throw new MessageException("Invalid parameters for Oauth fetch");
        }
    }

    public HybridOauthResponse(String requestToken, String scope) {
        if (scope != null && scope.trim().length() > 0) {
            this.parameters.set(new Parameter("scope", scope.trim()));
        }
        if (requestToken != null && requestToken.trim().length() > 0) {
            this.parameters.set(new Parameter("request_token", requestToken.trim()));
        }
    }

    public String getRequestToken() {
        return this.getParameter("request_token");
    }

    boolean isValid() {
        return this.isValid(requiredFields, optionalFields);
    }
}

