/*
 * Decompiled with CFR 0.152.
 */
package com.google.step2;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.step2.http.FetchException;
import com.google.step2.http.FetchRequest;
import com.google.step2.http.FetchResponse;
import com.google.step2.http.HttpFetcher;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.Map;
import net.oauth.client.OAuthClient;
import net.oauth.http.HttpClient;
import net.oauth.http.HttpMessage;
import net.oauth.http.HttpResponseMessage;

@Singleton
public class Step2OAuthClient
extends OAuthClient {
    @Inject
    public Step2OAuthClient(HttpFetcher httpFetcher) {
        super(Step2OAuthClient.convertFetcherToOAuthHttpClient(httpFetcher));
    }

    private static HttpClient convertFetcherToOAuthHttpClient(HttpFetcher httpFetcher) {
        return new Step2HttpClient(httpFetcher);
    }

    private static class Step2HttpResponseMessage
    extends HttpResponseMessage {
        private final FetchResponse fetchResponse;

        public Step2HttpResponseMessage(FetchResponse response, HttpMessage request) {
            super(request.method, request.url);
            this.fetchResponse = response;
        }

        public int getStatusCode() {
            return this.fetchResponse.getStatusCode();
        }

        protected InputStream openBody() throws IOException {
            try {
                return this.fetchResponse.getContentAsStream();
            }
            catch (FetchException e) {
                throw new IOException("could not fetch contents from " + this.url);
            }
        }
    }

    private static class Step2HttpClient
    implements HttpClient {
        private final HttpFetcher httpFetcher;

        public Step2HttpClient(HttpFetcher httpFetcher) {
            this.httpFetcher = httpFetcher;
        }

        public HttpResponseMessage execute(HttpMessage request, Map<String, Object> clientParams) throws IOException {
            try {
                FetchRequest fetchRequest = "post".equals(request.method.toLowerCase()) ? FetchRequest.createPostRequest(request.url.toURI()) : ("head".equals(request.method.toLowerCase()) ? FetchRequest.createHeadRequest(request.url.toURI()) : FetchRequest.createGetRequest(request.url.toURI()));
                FetchResponse response = this.httpFetcher.fetch(fetchRequest);
                return new Step2HttpResponseMessage(response, request);
            }
            catch (URISyntaxException e) {
                throw new IOException("couldn't convert " + request.url.toString() + " into a URI: " + e.getMessage());
            }
            catch (FetchException e) {
                throw new IOException("couldn't fetch data from " + request.url.toString() + ": " + e.getMessage());
            }
        }
    }
}

