/*
 * Decompiled with CFR 0.152.
 */
package com.google.step2;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.step2.AuthRequestHelper;
import com.google.step2.AuthResponseHelper;
import com.google.step2.VerificationException;
import com.google.step2.discovery.Discovery2;
import com.google.step2.discovery.SecureDiscoveryInformation;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openid4java.association.Association;
import org.openid4java.association.AssociationException;
import org.openid4java.consumer.ConsumerManager;
import org.openid4java.consumer.VerificationResult;
import org.openid4java.discovery.Discovery;
import org.openid4java.discovery.DiscoveryException;
import org.openid4java.discovery.DiscoveryInformation;
import org.openid4java.discovery.Identifier;
import org.openid4java.discovery.UrlIdentifier;
import org.openid4java.message.AuthSuccess;
import org.openid4java.message.MessageException;
import org.openid4java.message.ParameterList;

@Singleton
public class ConsumerHelper {
    private static Log log = LogFactory.getLog(ConsumerHelper.class);
    private final ConsumerManager consumerManager;

    @Inject
    public ConsumerHelper(ConsumerManager consumerManager, Discovery2 discovery) {
        this.consumerManager = consumerManager;
        this.consumerManager.setDiscovery((Discovery)discovery);
    }

    public AuthRequestHelper getAuthRequestHelper(Identifier openId, String returnToUrl) {
        log.info((Object)("OpenId: " + openId + " Return URL: " + returnToUrl));
        return new AuthRequestHelper(this.consumerManager, openId, returnToUrl);
    }

    public AuthResponseHelper verify(String receivingUrl, ParameterList authResponse, DiscoveryInformation discovered) throws MessageException, AssociationException, DiscoveryException, VerificationException {
        log.info((Object)("Receiving URL: " + receivingUrl));
        SecureDiscoveryInformation d2 = this.getDiscoveryInfoForClaimedId(authResponse, discovered);
        VerificationResult verification = this.consumerManager.verify(receivingUrl, authResponse, (DiscoveryInformation)d2);
        if (verification.getAuthResponse() instanceof AuthSuccess && verification.getVerifiedId() == null) {
            throw new VerificationException("something went wrong during response verification, such as nonce or signature checking. Check your debug logs.");
        }
        boolean secure = this.checkResponse(d2, verification);
        return new AuthResponseHelper(verification, secure);
    }

    private boolean checkResponse(SecureDiscoveryInformation d2, VerificationResult verification) {
        UrlIdentifier claimedIdWithoutFragment;
        if (d2 == null) {
            return false;
        }
        try {
            claimedIdWithoutFragment = new UrlIdentifier(verification.getVerifiedId().getIdentifier(), true);
        }
        catch (DiscoveryException e) {
            return false;
        }
        if (d2.getClaimedIdentifier() == null) {
            return false;
        }
        if (!d2.getClaimedIdentifier().getIdentifier().equals(claimedIdWithoutFragment.getIdentifier())) {
            return false;
        }
        return d2.isSecure();
    }

    private SecureDiscoveryInformation getDiscoveryInfoForClaimedId(ParameterList authResponse, DiscoveryInformation discovered) throws DiscoveryException, MessageException {
        if (!"id_res".equals(authResponse.getParameterValue("openid.mode"))) {
            return null;
        }
        AuthSuccess authResp = AuthSuccess.createAuthSuccess((ParameterList)authResponse);
        if (authResp == null || !authResp.isVersion2() || authResp.getIdentity() == null || authResp.getClaimed() == null) {
            return null;
        }
        String assertId = authResp.getIdentity();
        Identifier respClaimed = this.consumerManager.getDiscovery().parseIdentifier(authResp.getClaimed(), true);
        String respEndpoint = authResp.getOpEndpoint();
        if (discovered instanceof SecureDiscoveryInformation && discovered.hasClaimedIdentifier() && discovered.getClaimedIdentifier().equals(respClaimed)) {
            String opSpecific;
            String string = opSpecific = discovered.hasDelegateIdentifier() ? discovered.getDelegateIdentifier() : discovered.getClaimedIdentifier().getIdentifier();
            if (opSpecific.equals(assertId) && discovered.isVersion2() && discovered.getOPEndpoint().toString().equals(respEndpoint)) {
                return (SecureDiscoveryInformation)discovered;
            }
        }
        List discoveries = this.consumerManager.getDiscovery().discover(respClaimed);
        SecureDiscoveryInformation firstServiceMatch = null;
        for (SecureDiscoveryInformation service : discoveries) {
            Association assoc;
            String opSpecific;
            if ("http://specs.openid.net/auth/2.0/server".equals(service.getVersion()) || !(opSpecific = service.hasDelegateIdentifier() ? service.getDelegateIdentifier() : service.getClaimedIdentifier().getIdentifier()).equals(assertId) || !service.isVersion2() || !service.getOPEndpoint().toString().equals(respEndpoint)) continue;
            if (firstServiceMatch == null) {
                firstServiceMatch = service;
            }
            if ((assoc = this.consumerManager.getPrivateAssociationStore().load(service.getOPEndpoint().toString(), authResp.getHandle())) == null) continue;
            return service;
        }
        return firstServiceMatch;
    }
}

