/*
 * Decompiled with CFR 0.152.
 */
package com.google.step2;

import com.google.step2.AuthRequestHelper;
import com.google.step2.Step2;
import com.google.step2.discovery.SecureUrlIdentifier;
import com.google.step2.hybrid.HybridOauthResponse;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openid4java.consumer.VerificationResult;
import org.openid4java.discovery.DiscoveryException;
import org.openid4java.discovery.Identifier;
import org.openid4java.message.AuthFailure;
import org.openid4java.message.AuthImmediateFailure;
import org.openid4java.message.AuthSuccess;
import org.openid4java.message.Message;
import org.openid4java.message.MessageException;
import org.openid4java.message.MessageExtension;
import org.openid4java.message.ax.AxMessage;
import org.openid4java.message.ax.FetchResponse;

public class AuthResponseHelper {
    private static Logger log = Logger.getLogger(AuthRequestHelper.class.getName());
    private final VerificationResult result;
    private final boolean isSecure;

    AuthResponseHelper(VerificationResult verification, boolean isSecure) {
        this.result = verification;
        this.isSecure = isSecure;
    }

    public ResultType getAuthResultType() {
        log.info(this.result.getAuthResponse().toString());
        if (this.result.getAuthResponse() instanceof AuthSuccess) {
            return ResultType.AUTH_SUCCESS;
        }
        if (this.result.getAuthResponse() instanceof AuthImmediateFailure) {
            return ResultType.SETUP_NEEDED;
        }
        if (this.result.getAuthResponse() instanceof AuthFailure) {
            return ResultType.AUTH_FAILURE;
        }
        return ResultType.UNKNOWN;
    }

    public Message getAuthResponse() {
        return this.result.getAuthResponse();
    }

    public String getIdpSetupUrl() {
        log.info(this.result.getOPSetupUrl());
        return this.result.getOPSetupUrl();
    }

    public String getStatusMsg() {
        log.info(this.result.getStatusMsg());
        return this.result.getStatusMsg();
    }

    public Identifier getClaimedId() {
        if (this.getAuthResultType() != ResultType.AUTH_SUCCESS) {
            return null;
        }
        try {
            return this.isSecure ? new SecureUrlIdentifier(this.result.getVerifiedId()) : this.result.getVerifiedId();
        }
        catch (DiscoveryException e) {
            log.log(Level.WARNING, "could not create SecureUrlIdentifier from UrlIdentifier", e);
            return null;
        }
    }

    private <T extends MessageExtension> T getExtension(Class<T> type, String typeUri) throws MessageException {
        if (!this.getAuthResponse().hasExtension(typeUri)) {
            throw new MessageException("Response does not have extension for type: " + typeUri);
        }
        MessageExtension ext = this.getAuthResponse().getExtension(typeUri);
        if (type.isAssignableFrom(ext.getClass())) {
            return (T)ext;
        }
        throw new MessageException("Cannot cast type " + ext.getClass().getName() + " to " + type.getName());
    }

    public boolean hasHybridOauthExtension() {
        return this.getAuthResponse().hasExtension("http://specs.openid.net/extensions/oauth/1.0");
    }

    public HybridOauthResponse getHybridOauthResponse() throws MessageException {
        return this.getExtension(HybridOauthResponse.class, "http://specs.openid.net/extensions/oauth/1.0");
    }

    public Class<? extends AxMessage> getAxExtensionType() throws MessageException {
        MessageExtension extension;
        Message resp = this.getAuthResponse();
        if (resp.hasExtension("http://openid.net/srv/ax/1.0") && (extension = resp.getExtension("http://openid.net/srv/ax/1.0")) instanceof FetchResponse) {
            return FetchResponse.class;
        }
        return null;
    }

    public boolean hasAxExtension() {
        return this.getAuthResponse().hasExtension("http://openid.net/srv/ax/1.0");
    }

    public FetchResponse getAxFetchResponse() throws MessageException {
        return this.getExtension(FetchResponse.class, "http://openid.net/srv/ax/1.0");
    }

    public List<String> getAxFetchAttributeValues(String alias) {
        FetchResponse resp;
        try {
            resp = this.getAxFetchResponse();
        }
        catch (MessageException e) {
            return Collections.emptyList();
        }
        List result = resp.getAttributeValues(alias);
        if (result.size() == 1 && null == result.get(0)) {
            return Collections.emptyList();
        }
        return result;
    }

    public String getAxFetchAttributeValue(String alias) {
        List<String> values = this.getAxFetchAttributeValues(alias);
        if (values.isEmpty()) {
            return null;
        }
        return values.get(0);
    }

    public String getAxFetchAttributeValue(Step2.AxSchema schema) {
        return this.getAxFetchAttributeValue(schema.getShortName());
    }

    public static enum ResultType {
        AUTH_SUCCESS,
        AUTH_FAILURE,
        SETUP_NEEDED,
        UNKNOWN;

    }
}

