/*
 * Decompiled with CFR 0.152.
 */
package com.google.step2;

import com.google.step2.Step2;
import com.google.step2.hybrid.HybridOauthRequest;
import com.google.step2.openid.ax2.FetchRequest2;
import com.google.step2.openid.ui.UiMessageRequest;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openid4java.consumer.ConsumerException;
import org.openid4java.consumer.ConsumerManager;
import org.openid4java.discovery.Discovery;
import org.openid4java.discovery.DiscoveryException;
import org.openid4java.discovery.DiscoveryInformation;
import org.openid4java.discovery.Identifier;
import org.openid4java.message.AuthRequest;
import org.openid4java.message.MessageException;
import org.openid4java.message.MessageExtension;

public class AuthRequestHelper {
    private static Log log = LogFactory.getLog(AuthRequestHelper.class);
    private final ConsumerManager consumerManager;
    private final Identifier openId;
    private final String returnToUrl;
    private FetchRequest2 axFetchRequest = null;
    private UiMessageRequest uiRequest = null;
    private HybridOauthRequest hybridOauthRequest = null;
    private DiscoveryInformation discovered = null;

    AuthRequestHelper(ConsumerManager consumerManager, Identifier openId, String returnToUrl) {
        log.info((Object)("OpenId: " + openId + " ReturnToUrl: " + returnToUrl));
        this.consumerManager = consumerManager;
        this.openId = openId;
        this.returnToUrl = returnToUrl;
    }

    public DiscoveryInformation getDiscoveryInformation() throws DiscoveryException {
        if (this.discovered == null) {
            Discovery discovery = this.consumerManager.getDiscovery();
            List discoveries = discovery.discover(this.openId);
            if (discoveries == null || discoveries.size() == 0) {
                throw new DiscoveryException("discovery on " + this.openId.getIdentifier() + " failed.");
            }
            this.discovered = this.consumerManager.associate(discoveries);
        }
        return this.discovered;
    }

    public AuthRequestHelper requestOauthAuthorization(String consumerKey, String scope) {
        log.info((Object)"Requesting OauthAuthorization");
        this.hybridOauthRequest = new HybridOauthRequest(consumerKey, scope);
        return this;
    }

    public AuthRequestHelper requestAxAttribute(String alias, String typeUri, boolean required) {
        log.info((Object)("Request AX Attribute Alias: " + alias));
        return this.requestAxAttribute(alias, typeUri, required, 1);
    }

    public AuthRequestHelper requestAxAttribute(Step2.AxSchema schema, boolean required) {
        return this.requestAxAttribute(schema.getShortName(), schema.getUri(), required);
    }

    public AuthRequestHelper requestAxAttribute(String alias, String typeUri, boolean required, int count) {
        log.info((Object)("Request AX Attribute Alias: " + alias));
        if (this.axFetchRequest == null) {
            this.axFetchRequest = new FetchRequest2();
        }
        try {
            this.axFetchRequest.addAttribute(alias, typeUri, required, count);
        }
        catch (MessageException e) {
            log.warn((Object)"Unable to add attribute to AX fetch request.");
            this.axFetchRequest = null;
        }
        return this;
    }

    public AuthRequestHelper requestUxIcon(boolean showIcon) {
        UiMessageRequest ui = this.getOrCreateUiRequest();
        ui.setIconRequest(showIcon);
        return this;
    }

    private UiMessageRequest getOrCreateUiRequest() {
        if (this.uiRequest == null) {
            this.uiRequest = new UiMessageRequest();
        }
        return this.uiRequest;
    }

    public AuthRequest generateRequest() throws DiscoveryException, MessageException, ConsumerException {
        DiscoveryInformation discovered = this.getDiscoveryInformation();
        AuthRequest authReq = this.consumerManager.authenticate(discovered, this.returnToUrl, null);
        if (this.axFetchRequest != null) {
            authReq.addExtension((MessageExtension)this.axFetchRequest);
        }
        if (this.hybridOauthRequest != null) {
            authReq.addExtension((MessageExtension)this.hybridOauthRequest);
        }
        if (this.uiRequest != null) {
            authReq.addExtension((MessageExtension)this.uiRequest);
        }
        log.info((Object)authReq);
        return authReq;
    }
}

