/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.provider.openid.extensions;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openid4java.message.AuthRequest;
import org.openid4java.message.MessageException;
import org.openid4java.message.MessageExtension;
import org.openid4java.message.pape.PapeRequest;
import org.openid4java.message.pape.PapeResponse;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.provider.dto.OpenIDParameterDTO;
import org.wso2.carbon.identity.provider.openid.extensions.OpenIDExtension;
import org.wso2.carbon.identity.provider.openid.handlers.OpenIDAuthenticationRequest;

public class OpenIDPape
extends OpenIDExtension {
    private OpenIDAuthenticationRequest request;
    private static Log log = LogFactory.getLog(OpenIDPape.class);

    public OpenIDPape(OpenIDAuthenticationRequest request) throws IdentityException {
        if (request == null) {
            log.debug((Object)"Request cannot be null while initializing OpenIDPape");
            throw new IdentityException("Request cannot be null while initializing OpenIDPape");
        }
        this.request = request;
    }

    @Override
    public void addRequiredAttributes(List<String> requiredAttributes) throws IdentityException {
    }

    @Override
    public MessageExtension getMessageExtension(String userId, String profileName) throws IdentityException {
        MessageExtension message = null;
        PapeResponse papeResponse = null;
        AuthRequest authRequest = null;
        try {
            authRequest = this.request.getAuthRequest();
            if (authRequest != null && (message = authRequest.getExtension("http://specs.openid.net/extensions/pape/1.0")) instanceof PapeRequest) {
                papeResponse = PapeResponse.createPapeResponse();
                if (this.request.isPhishingResistanceLogin()) {
                    papeResponse.addAuthPolicy("http://schemas.openid.net/pape/policies/2007/06/phishing-resistant");
                }
                if (this.request.isMultifactorLogin()) {
                    papeResponse.addAuthPolicy("http://schemas.openid.net/pape/policies/2007/06/multi-factor");
                }
            }
        }
        catch (MessageException e) {
            log.error((Object)"Failed to create message extension for PAPE", (Throwable)e);
            throw new IdentityException("Failed to create message extension for PAPE", (Throwable)e);
        }
        return papeResponse;
    }

    public static String[] getAuthenticationPolicies(AuthRequest authRequest) throws Exception {
        MessageExtension message = null;
        PapeRequest papeRequest = null;
        List preferredPolicies = null;
        try {
            if (authRequest.hasExtension("http://specs.openid.net/extensions/pape/1.0") && (message = authRequest.getExtension("http://specs.openid.net/extensions/pape/1.0")) instanceof PapeRequest && (preferredPolicies = (papeRequest = (PapeRequest)message).getPreferredAuthPoliciesList()) != null && !preferredPolicies.isEmpty()) {
                return preferredPolicies.toArray(new String[preferredPolicies.size()]);
            }
            return null;
        }
        catch (MessageException e) {
            log.error((Object)"Failed retreive authenrtication policies", (Throwable)e);
            throw new IdentityException("Failed retreive authenrtication policies", (Throwable)e);
        }
    }

    public OpenIDParameterDTO[] getPapeInfoFromRequest() {
        OpenIDParameterDTO[] policySet = new OpenIDParameterDTO[4];
        for (int i = 0; i < policySet.length; ++i) {
            policySet[i] = new OpenIDParameterDTO();
        }
        policySet[0].setName("http://schemas.openid.net/pape/policies/2007/06/phishing-resistant");
        policySet[0].setValue("false");
        policySet[1].setName("http://schemas.openid.net/pape/policies/2007/06/multi-factor");
        policySet[1].setValue("false");
        policySet[2].setName("infocard_based_multifactor_auth");
        policySet[2].setValue("false");
        policySet[3].setName("xmpp_based_multifactor_auth");
        policySet[3].setValue("false");
        if (this.request.isPhishingResistanceLogin()) {
            policySet[0].setValue("true");
        }
        if (this.request.isMultifactorLogin()) {
            policySet[1].setValue("true");
        }
        return policySet;
    }
}

