/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.provider.openid.extensions;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openid4java.message.MessageExtension;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.core.IdentityClaimManager;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.identity.provider.dto.OpenIDClaimDTO;
import org.wso2.carbon.identity.provider.openid.OpenIDUtil;
import org.wso2.carbon.user.core.UserStoreManager;
import org.wso2.carbon.user.core.claim.Claim;
import org.wso2.carbon.utils.TenantUtils;

public abstract class OpenIDExtension {
    public abstract MessageExtension getMessageExtension(String var1, String var2) throws IdentityException;

    public abstract void addRequiredAttributes(List<String> var1) throws IdentityException;

    protected Map<String, OpenIDClaimDTO> populateAttributeValues(List<String> requiredClaims, String openId, String profileName) throws IdentityException {
        HashMap<String, OpenIDClaimDTO> map = null;
        map = new HashMap<String, OpenIDClaimDTO>();
        OpenIDClaimDTO[] claims = null;
        try {
            claims = this.getClaimValues(openId, profileName, requiredClaims);
            if (claims != null) {
                for (int i = 0; i < claims.length; ++i) {
                    if (claims[i] == null) continue;
                    map.put(claims[i].getClaimUri(), claims[i]);
                }
            }
            return map;
        }
        catch (Exception e) {
            throw new IdentityException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private OpenIDClaimDTO[] getClaimValues(String openId, String profileId, List<String> requiredClaims) throws Exception {
        UserStoreManager userStore = null;
        Map claimValues = null;
        OpenIDClaimDTO[] claims = null;
        OpenIDClaimDTO dto = null;
        IdentityClaimManager claimManager = null;
        Claim[] claimData = null;
        String[] claimArray = new String[requiredClaims.size()];
        String userName = null;
        String domainName = null;
        String tenatUser = null;
        userName = OpenIDUtil.getUserName(openId);
        domainName = TenantUtils.getDomainNameFromOpenId((String)openId);
        tenatUser = userName;
        if (userName.contains("@")) {
            tenatUser = userName.substring(0, userName.indexOf("@"));
        }
        userStore = IdentityTenantUtil.getRealm((String)domainName, (String)userName).getUserStoreManager();
        claimValues = userStore.getUserClaimValues(tenatUser, requiredClaims.toArray(claimArray), profileId);
        claims = new OpenIDClaimDTO[claimValues.size()];
        int i = 0;
        claimManager = IdentityClaimManager.getInstance();
        claimData = !requiredClaims.isEmpty() && requiredClaims.get(0).startsWith("http://axschema.org") ? claimManager.getAllSupportedClaims("http://axschema.org", IdentityTenantUtil.getRealm((String)domainName, (String)userName)) : claimManager.getAllSupportedClaims("http://schema.openid.net/2007/05/claims", IdentityTenantUtil.getRealm((String)domainName, (String)userName));
        for (int j = 0; j < claimData.length; ++j) {
            if (!claimValues.containsKey(claimData[j].getClaimUri())) continue;
            dto = new OpenIDClaimDTO();
            dto.setClaimUri(claimData[j].getClaimUri());
            dto.setClaimValue((String)claimValues.get(claimData[j].getClaimUri()));
            dto.setDisplayTag(claimData[j].getDisplayTag());
            dto.setDescription(claimData[j].getDescription());
            claims[i++] = dto;
        }
        return claims;
    }
}

