/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.provider.openid;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.identity.provider.IdentityProviderException;
import org.wso2.carbon.user.core.UserStoreManager;

public class OpenIDUtil {
    private static Log log;
    private static final Set<Character> UNRESERVED_CHARACTERS;
    private static Map<String, String> axMapping;

    public static String generateOpenID(String user) throws IdentityProviderException {
        ServerConfiguration serverConfig = null;
        String openIDUserUrl = null;
        String openID = null;
        URI uri = null;
        URL url = null;
        serverConfig = ServerConfiguration.getInstance();
        openIDUserUrl = serverConfig.getFirstProperty("OpenIDUserUrl");
        user = OpenIDUtil.normalizeUrlEncoding(user);
        openID = String.format(openIDUserUrl, user);
        try {
            uri = new URI(openID);
        }
        catch (URISyntaxException e) {
            log.error((Object)("Invalid OpenID URL :" + openID), (Throwable)e);
            throw new IdentityProviderException("Invalid OpenID URL :" + openID, e);
        }
        try {
            url = uri.normalize().toURL();
            if (url.getQuery() != null || url.getRef() != null) {
                log.error((Object)("Invalid user name for OpenID :" + openID));
                throw new IdentityProviderException("Invalid user name for OpenID :" + openID);
            }
        }
        catch (MalformedURLException e) {
            log.error((Object)("Malformed OpenID URL :" + openID), (Throwable)e);
            throw new IdentityProviderException("Malformed OpenID URL :" + openID, e);
        }
        openID = url.toString();
        if (log.isDebugEnabled()) {
            log.debug((Object)("OpenID generated successfully : " + openID));
        }
        return openID;
    }

    private static String normalizeUrlEncoding(String text) {
        if (text == null) {
            return null;
        }
        int len = text.length();
        StringBuffer normalized = new StringBuffer(len);
        for (int i = 0; i < len; ++i) {
            char current = text.charAt(i);
            if (current == '%' && i < len - 2) {
                String percentCode = text.substring(i, i + 3).toUpperCase();
                try {
                    String str = URLDecoder.decode(percentCode, "ISO-8859-1");
                    char chr = str.charAt(0);
                    if (UNRESERVED_CHARACTERS.contains(Character.valueOf(chr))) {
                        normalized.append(chr);
                    } else {
                        normalized.append(percentCode);
                    }
                }
                catch (UnsupportedEncodingException e) {
                    normalized.append(percentCode);
                }
                i += 2;
                continue;
            }
            normalized.append(current);
        }
        return normalized.toString();
    }

    public static String getMappedAxSchema(String val) {
        if (axMapping.containsKey(val)) {
            return axMapping.get(val);
        }
        return val;
    }

    public static String getOpenID(String userName) throws IdentityProviderException {
        return OpenIDUtil.generateOpenID(userName);
    }

    public static String getUserName(String openID) throws Exception {
        try {
            openID = new URL(openID).getPath();
        }
        catch (MalformedURLException e) {
            throw new Exception("Invalid OpenID Identifier " + openID, e);
        }
        String contextPath = "/openid";
        String user = openID.substring(openID.indexOf(contextPath) + contextPath.length() + 1, openID.length());
        return user;
    }

    public static boolean doLogin(String username, String password) {
        try {
            UserStoreManager userStore = IdentityTenantUtil.getRealm(null, (String)username).getUserStoreManager();
            return userStore.authenticate(username, (Object)password);
        }
        catch (Exception e) {
            log.error((Object)"Error while authenticating user", (Throwable)e);
            return false;
        }
    }

    static {
        char c;
        log = LogFactory.getLog(OpenIDUtil.class);
        UNRESERVED_CHARACTERS = new HashSet<Character>();
        axMapping = new HashMap<String, String>();
        for (c = 'a'; c <= 'z'; c = (char)(c + 1)) {
            UNRESERVED_CHARACTERS.add(Character.valueOf(c));
        }
        for (c = 'A'; c <= 'A'; c = (char)(c + '\u0001')) {
            UNRESERVED_CHARACTERS.add(Character.valueOf(c));
        }
        for (c = '0'; c <= '9'; c = (char)(c + '\u0001')) {
            UNRESERVED_CHARACTERS.add(Character.valueOf(c));
        }
        UNRESERVED_CHARACTERS.add(Character.valueOf('-'));
        UNRESERVED_CHARACTERS.add(Character.valueOf('.'));
        UNRESERVED_CHARACTERS.add(Character.valueOf('_'));
        UNRESERVED_CHARACTERS.add(Character.valueOf('~'));
    }
}

