/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.provider.openid;

import org.openid4java.OpenIDException;
import org.openid4java.association.Association;
import org.openid4java.association.AssociationException;
import org.openid4java.association.AssociationSessionType;
import org.openid4java.association.DiffieHellmanSession;
import org.openid4java.message.AssociationError;
import org.openid4java.message.AssociationRequest;
import org.openid4java.message.AssociationResponse;
import org.openid4java.message.Message;
import org.openid4java.message.ParameterList;
import org.openid4java.server.ServerManager;

public class OpenIDServerManager
extends ServerManager {
    public Message associationResponse(ParameterList requestParams) {
        boolean isVersion2 = requestParams.hasParameter("openid.ns");
        try {
            AssociationRequest assocReq = AssociationRequest.createAssociationRequest((ParameterList)requestParams);
            isVersion2 = assocReq.isVersion2();
            AssociationSessionType type = assocReq.getType();
            if (!Association.isHmacSupported((String)type.getAssociationType()) || !DiffieHellmanSession.isDhSupported((AssociationSessionType)type) || this.getMinAssocSessEnc().isBetter(type)) {
                throw new AssociationException("Unable create association for: " + type.getSessionType() + " / " + type.getAssociationType());
            }
            Association assoc = this.getPrivateAssociations().generate(type.getAssociationType(), this.getExpireIn());
            return AssociationResponse.createAssociationResponse((AssociationRequest)assocReq, (Association)assoc);
        }
        catch (Exception e) {
            if (isVersion2) {
                return AssociationError.createAssociationError((String)e.getMessage(), (AssociationSessionType)this.getPrefAssocSessEnc());
            }
            try {
                Association dummyAssoc = this.getPrivateAssociations().generate("HMAC-SHA1", 0);
                AssociationRequest dummyRequest = AssociationRequest.createAssociationRequest((AssociationSessionType)AssociationSessionType.NO_ENCRYPTION_COMPAT_SHA1MAC);
                return AssociationResponse.createAssociationResponse((AssociationRequest)dummyRequest, (Association)dummyAssoc);
            }
            catch (OpenIDException ex) {
                return null;
            }
        }
    }
}

