/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.provider.internal;

import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.provider.IdentityAttributeService;
import org.wso2.carbon.identity.provider.IdentityAttributeServiceStore;
import org.wso2.carbon.identity.provider.IdentityProviderUtil;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.utils.ConfigurationContextService;

public class IdentityProviderServiceComponent {
    private static Log log = LogFactory.getLog(IdentityProviderServiceComponent.class);
    private static ConfigurationContext configContext;
    private static RealmService realmService;
    private static RegistryService registryService;

    public static RealmService getRealmService() {
        return realmService;
    }

    protected void activate(ComponentContext ctxt) {
        if (log.isDebugEnabled()) {
            log.info((Object)"Identity Provider bundle is activated");
        }
        try {
            ctxt.getBundleContext().registerService(IdentityProviderUtil.class.getName(), (Object)new IdentityProviderUtil(), null);
        }
        catch (Throwable e) {
            log.error((Object)"Failed to initialize Identity Provider", e);
        }
    }

    protected void deactivate(ComponentContext ctxt) {
        if (log.isDebugEnabled()) {
            log.info((Object)"Identity Provider bundle is deactivated");
        }
    }

    protected void setRegistryService(RegistryService registryService) {
        IdentityProviderServiceComponent.registryService = registryService;
        if (log.isDebugEnabled()) {
            log.info((Object)"RegistryService set in Identity Provider bundle");
        }
    }

    protected void unsetRegistryService(RegistryService registryService) {
        IdentityProviderServiceComponent.registryService = null;
        if (log.isDebugEnabled()) {
            log.info((Object)"RegistryService unset in Identity Provider bundle");
        }
    }

    protected void unsetUserRealmDelegating(UserRealm userRealmDelegating) {
        if (log.isDebugEnabled()) {
            log.info((Object)"DelegatingUserRealm set in Identity Provider bundle");
        }
    }

    protected void unsetUserRealmDefault(UserRealm userRealmDefault) {
        if (log.isDebugEnabled()) {
            log.info((Object)"DefaultUserRealm unset in Identity Provider bundle");
        }
    }

    protected void setRealmService(RealmService realmService) {
        if (log.isDebugEnabled()) {
            log.info((Object)"ReleamService is set in Identity Provider Service Bundle");
        }
        IdentityProviderServiceComponent.realmService = realmService;
    }

    protected void unsetRealmService(RealmService realmService) {
        if (log.isDebugEnabled()) {
            log.info((Object)"ReleamService is unset in Identity Provider Service Bundle");
        }
    }

    protected void addAttributeService(IdentityAttributeService attributeService) {
        if (log.isDebugEnabled()) {
            log.info((Object)"IdentityAttributeService added in Identity Provider bundle");
        }
        IdentityAttributeServiceStore.addAttributeService(attributeService);
    }

    protected void removeAttributeService(IdentityAttributeService attributeService) {
        if (log.isDebugEnabled()) {
            log.info((Object)"IdentityAttributeService removed in Identity Provider bundle");
            IdentityAttributeServiceStore.removeAttributeService(attributeService);
        }
    }

    protected void setConfigurationContextService(ConfigurationContextService contextService) {
        if (log.isDebugEnabled()) {
            log.info((Object)"ConfigurationContextService set in Identity Provider bundle");
        }
        configContext = contextService.getServerConfigContext();
    }

    protected void unsetConfigurationContextService(ConfigurationContextService contextService) {
        if (log.isDebugEnabled()) {
            log.info((Object)"ConfigurationContextService unset in Identity Provider bundle");
        }
    }

    protected void setIdentityUtil(IdentityUtil identityUtil) {
        if (log.isDebugEnabled()) {
            log.info((Object)"IdentityUtil set in Identity Provider bundle");
        }
    }

    protected void unsetIdentityUtil(IdentityUtil identityUtil) {
        if (log.isDebugEnabled()) {
            log.info((Object)"IdentityUtil unset in Identity Provider bundle");
        }
    }

    public static ConfigurationContext getConfigContext() {
        return configContext;
    }

    public static RegistryService getRegistryService() {
        return registryService;
    }
}

