/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.provider;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.util.AdminServicesUtil;
import org.wso2.carbon.identity.provider.IdentityProviderException;
import org.wso2.carbon.identity.provider.dto.XMPPSettingsDTO;
import org.wso2.carbon.identity.provider.xmpp.XMPPConfigurator;
import org.wso2.carbon.user.core.UserStoreManager;

public class XMPPConfigurationService {
    protected Log log = LogFactory.getLog(XMPPConfigurationService.class);

    public boolean addUserXmppSettings(XMPPSettingsDTO dto) throws IdentityProviderException {
        String message = "Invalid parameters provided to addUserXmppSettings";
        if (dto == null) {
            throw new IllegalArgumentException(message);
        }
        if (dto.getUserId() == null) {
            throw new IllegalArgumentException(message);
        }
        this.validateInputParameters(new String[]{dto.getUserId(), dto.getXmppServer(), dto.getXmppUserName(), dto.getUserCode()}, message);
        this.checkUserAuthorization(dto.getUserId(), "addUserXmppSettings");
        XMPPConfigurator provider = new XMPPConfigurator();
        provider.addXmppSettings(dto);
        return true;
    }

    public void editXmppSettings(XMPPSettingsDTO dto) throws IdentityProviderException {
        String message = "Invalid parameters provided to editXmppSettings";
        if (dto == null) {
            throw new IllegalArgumentException(message);
        }
        if (dto.getUserId() == null) {
            throw new IllegalArgumentException(message);
        }
        this.validateInputParameters(new String[]{dto.getUserId(), dto.getXmppServer(), dto.getXmppUserName(), dto.getUserCode()}, message);
        this.checkUserAuthorization(dto.getUserId(), "editXmppSettings");
        XMPPConfigurator provider = new XMPPConfigurator();
        provider.editXmppSettings(dto);
    }

    public XMPPSettingsDTO getXmppSettings(String userId) throws IdentityProviderException {
        String message = "Invalid parameters provided to getXmppSettings";
        this.validateInputParameters(new String[]{userId}, message);
        this.checkUserAuthorization(userId, "getXmppSettings");
        XMPPConfigurator provider = new XMPPConfigurator();
        return provider.getXmppSettings(userId);
    }

    public boolean isXMPPSettingsEnabled(String userId) throws IdentityProviderException {
        String message = "Invalid parameters provided to isXMPPSettingsEnabled";
        this.validateInputParameters(new String[]{userId}, message);
        this.checkUserAuthorization(userId, "isXMPPSettingsEnabled");
        XMPPConfigurator provider = new XMPPConfigurator();
        return provider.isXmppSettingsEnabled(userId);
    }

    public boolean hasXMPPSettings(String userId) throws IdentityProviderException {
        String message = "Invalid parameters provided to hasXMPPSettings";
        this.validateInputParameters(new String[]{userId}, message);
        this.checkUserAuthorization(userId, "hasXMPPSettings");
        XMPPConfigurator provider = new XMPPConfigurator();
        return provider.hasXMPPSettings(userId);
    }

    public String getUserIM(String userId) throws Exception {
        String message = "Invalid parameters provided to hasXMPPSettings";
        this.validateInputParameters(new String[]{userId}, message);
        this.checkUserAuthorization(userId, "hasXMPPSettings");
        UserStoreManager userStore = AdminServicesUtil.getUserRealm().getUserStoreManager();
        String[] imClaim = new String[]{"http://wso2.org/claims/im"};
        Map claimValues = userStore.getUserClaimValues(userId, imClaim, "default");
        if (claimValues.containsKey("http://wso2.org/claims/im")) {
            return (String)claimValues.get("http://wso2.org/claims/im");
        }
        return null;
    }

    private void checkUserAuthorization(String username, String operation) throws IdentityProviderException {
        MessageContext msgContext = MessageContext.getCurrentMessageContext();
        HttpServletRequest request = (HttpServletRequest)msgContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
        HttpSession httpSession = request.getSession(false);
        if (httpSession != null) {
            String userName = (String)httpSession.getAttribute("wso2carbon.admin.logged.in");
            if (!username.equals(userName)) {
                throw new IdentityProviderException("Unauthorised action by user " + username + " to access " + operation);
            }
            return;
        }
        throw new IdentityProviderException("Unauthorised action by user " + username + " to access " + operation);
    }

    private void validateInputParameters(String[] params, String message) {
        for (int i = 0; i < params.length; ++i) {
            if (params[i] != null && params[i].trim().length() != 0) continue;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)message);
            }
            throw new IllegalArgumentException(message);
        }
    }
}

