/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.provider;

import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openid4java.message.AuthFailure;
import org.openid4java.message.AuthRequest;
import org.openid4java.message.AuthSuccess;
import org.openid4java.message.DirectError;
import org.openid4java.message.Message;
import org.openid4java.message.MessageExtension;
import org.openid4java.message.Parameter;
import org.openid4java.message.ParameterList;
import org.openid4java.server.RealmVerifier;
import org.openid4java.server.ServerManager;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.core.IdentityClaimManager;
import org.wso2.carbon.identity.core.dao.OpenIDRememberMeDAO;
import org.wso2.carbon.identity.core.dao.OpenIDUserRPDAO;
import org.wso2.carbon.identity.core.model.OpenIDRememberMeDO;
import org.wso2.carbon.identity.core.model.OpenIDUserRPDO;
import org.wso2.carbon.identity.core.model.XMPPSettingsDO;
import org.wso2.carbon.identity.core.persistence.IdentityPersistenceManager;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.provider.IdentityProviderException;
import org.wso2.carbon.identity.provider.dto.OpenIDAuthRequestDTO;
import org.wso2.carbon.identity.provider.dto.OpenIDAuthResponseDTO;
import org.wso2.carbon.identity.provider.dto.OpenIDClaimDTO;
import org.wso2.carbon.identity.provider.dto.OpenIDParameterDTO;
import org.wso2.carbon.identity.provider.dto.OpenIDProviderInfoDTO;
import org.wso2.carbon.identity.provider.dto.OpenIDRememberMeDTO;
import org.wso2.carbon.identity.provider.dto.OpenIDUserProfileDTO;
import org.wso2.carbon.identity.provider.dto.OpenIDUserRPDTO;
import org.wso2.carbon.identity.provider.openid.OpenIDProvider;
import org.wso2.carbon.identity.provider.openid.OpenIDUtil;
import org.wso2.carbon.identity.provider.openid.extensions.OpenIDExtension;
import org.wso2.carbon.identity.provider.openid.handlers.OpenIDAuthenticationRequest;
import org.wso2.carbon.identity.provider.openid.handlers.OpenIDExtensionFactory;
import org.wso2.carbon.identity.provider.xmpp.MPAuthenticationProvider;
import org.wso2.carbon.identity.relyingparty.RelyingPartyData;
import org.wso2.carbon.identity.relyingparty.RelyingPartyException;
import org.wso2.carbon.identity.relyingparty.saml.SAMLTokenVerifier;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.UserStoreManager;
import org.wso2.carbon.user.core.claim.Claim;
import org.wso2.carbon.utils.TenantUtils;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class OpenIDProviderService {
    private static final String OPENID_LOGGEDIN_USER = "OPENID_LOGGEDIN_USER";
    protected Log log = LogFactory.getLog(OpenIDProviderService.class);

    public boolean authenticateWithOpenID(String openID, String password) throws Exception {
        MessageContext msgContext;
        HttpServletRequest request;
        HttpSession httpSession;
        String userName = OpenIDUtil.getUserName(openID);
        boolean authenticationStatus = true;
        boolean isAutheticated = false;
        String domainName = null;
        String tenantUser = null;
        IdentityPersistenceManager persistenceManager = IdentityPersistenceManager.getPersistanceManager();
        domainName = TenantUtils.getDomainNameFromOpenId((String)openID);
        tenantUser = MultitenantUtils.getTenantAwareUsername((String)userName);
        XMPPSettingsDO xmppSettingsDO = persistenceManager.getXmppSettings(IdentityTenantUtil.getRegistry((String)domainName, (String)userName), tenantUser);
        isAutheticated = IdentityTenantUtil.getRealm((String)domainName, (String)userName).getUserStoreManager().authenticate(tenantUser, (Object)password);
        if (xmppSettingsDO != null && xmppSettingsDO.isXmppEnabled() && isAutheticated) {
            MPAuthenticationProvider mpAuthenticationProvider = new MPAuthenticationProvider(xmppSettingsDO);
            authenticationStatus = mpAuthenticationProvider.authenticate();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"XMPP Multifactor Authentication was completed Successfully.");
            }
        }
        if (authenticationStatus && isAutheticated && (httpSession = (request = (HttpServletRequest)(msgContext = MessageContext.getCurrentMessageContext()).getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST)).getSession(false)) != null) {
            httpSession.setAttribute(OPENID_LOGGEDIN_USER, (Object)userName);
        }
        return authenticationStatus && isAutheticated;
    }

    public OpenIDRememberMeDTO authenticateWithOpenIDRememberMe(String openID, String password, String ipaddress, String cookie) throws Exception {
        String userName = OpenIDUtil.getUserName(openID);
        boolean isAutheticated = false;
        String domainName = null;
        String tenantUser = null;
        String hmac = null;
        OpenIDRememberMeDTO dto = new OpenIDRememberMeDTO();
        dto.setAuthenticated(false);
        if (password != null && password.trim().length() > 0 ? !(isAutheticated = this.authenticateWithOpenID(openID, password)) : cookie == null || "null".equals(cookie) || ipaddress == null) {
            return dto;
        }
        OpenIDRememberMeDO rememberMe = null;
        OpenIDRememberMeDAO dao = null;
        String token = null;
        tenantUser = MultitenantUtils.getTenantAwareUsername((String)userName);
        rememberMe = new OpenIDRememberMeDO();
        rememberMe.setOpenID(openID);
        rememberMe.setUserName(tenantUser);
        domainName = MultitenantUtils.getDomainNameFromOpenId((String)openID);
        dao = new OpenIDRememberMeDAO(IdentityTenantUtil.getRegistry((String)domainName, null));
        if (ipaddress != null && cookie != null && !"null".equals(cookie)) {
            hmac = IdentityUtil.getHMAC((String)ipaddress, (String)cookie);
            token = dao.getToken(rememberMe);
            if (token == null || !token.equals(hmac)) {
                return dto;
            }
            cookie = IdentityUtil.generateUUID();
            hmac = IdentityUtil.getHMAC((String)ipaddress, (String)cookie);
            rememberMe.setToken(hmac);
            dao.updateToken(rememberMe);
            dto.setNewCookieValue(cookie);
            dto.setAuthenticated(true);
            MessageContext msgContext = MessageContext.getCurrentMessageContext();
            HttpServletRequest request = (HttpServletRequest)msgContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
            HttpSession httpSession = request.getSession(false);
            if (httpSession != null) {
                httpSession.setAttribute(OPENID_LOGGEDIN_USER, (Object)userName);
            }
            return dto;
        }
        if (ipaddress != null && (cookie == null || "null".equals(cookie)) && isAutheticated) {
            cookie = IdentityUtil.generateUUID();
            hmac = IdentityUtil.getHMAC((String)ipaddress, (String)cookie);
            rememberMe.setToken(hmac);
            dao.updateToken(rememberMe);
            dto.setNewCookieValue(cookie);
            dto.setAuthenticated(true);
            MessageContext msgContext = MessageContext.getCurrentMessageContext();
            HttpServletRequest request = (HttpServletRequest)msgContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
            HttpSession httpSession = request.getSession(false);
            if (httpSession != null) {
                httpSession.setAttribute(OPENID_LOGGEDIN_USER, (Object)userName);
            }
            return dto;
        }
        return dto;
    }

    public OpenIDProviderInfoDTO getOpenIDProviderInfo(String userName, String openid) throws Exception {
        OpenIDProviderInfoDTO providerInfo = null;
        String domain = null;
        UserRealm realm = null;
        providerInfo = new OpenIDProviderInfoDTO();
        try {
            domain = TenantUtils.getDomainNameFromOpenId((String)openid);
            realm = IdentityTenantUtil.getRealm((String)domain, (String)userName);
        }
        catch (Exception ignore) {
            this.log.error((Object)ignore);
        }
        if (realm == null) {
            return providerInfo;
        }
        providerInfo.setSubDomain(domain);
        userName = MultitenantUtils.getTenantAwareUsername((String)userName);
        providerInfo.setUserExist(realm.getUserStoreManager().isExistingUser(userName));
        providerInfo.setOpenIDProviderServerUrl(IdentityUtil.getProperty((String)"OpenIDServerUrl"));
        providerInfo.setOpenID(IdentityUtil.getProperty((String)"OpenIDUserPattern") + userName);
        return providerInfo;
    }

    public OpenIDClaimDTO[] getClaimValues(String openId, String profileId, OpenIDParameterDTO[] requredClaims) throws Exception {
        List<String> claimList = null;
        ParameterList paramList = null;
        AuthRequest authReq = null;
        String message = "Invalid parameters provided to getClaimValues";
        this.validateInputParameters(new String[]{openId, profileId}, message);
        this.checkUserAuthorization(OpenIDUtil.getUserName(openId), "getClaimValues");
        paramList = this.getParameterList(requredClaims);
        authReq = AuthRequest.createAuthRequest((ParameterList)paramList, (RealmVerifier)OpenIDProvider.getInstance().getManager().getRealmVerifier());
        claimList = this.getRequestedAttributes(authReq);
        return this.getOpenIDClaimValues(openId, profileId, claimList);
    }

    public String getOpenIDAssociationResponse(OpenIDParameterDTO[] params) throws Exception {
        Message message = null;
        ParameterList paramList = null;
        paramList = this.getParameterList(params);
        message = OpenIDProvider.getInstance().getManager().associationResponse(paramList);
        return message.keyValueFormEncoding();
    }

    public String verify(OpenIDParameterDTO[] params) throws Exception {
        Message message = null;
        ParameterList paramList = null;
        paramList = this.getParameterList(params);
        message = OpenIDProvider.getInstance().getManager().verify(paramList);
        return message.keyValueFormEncoding();
    }

    public OpenIDAuthResponseDTO getOpenIDAuthResponse(OpenIDAuthRequestDTO request) throws Exception {
        ParameterList paramList = null;
        Message message = null;
        paramList = this.getParameterList(request.getParams());
        String destinationUrl = null;
        AuthRequest authReq = null;
        ServerManager manager = null;
        OpenIDAuthResponseDTO response = null;
        response = new OpenIDAuthResponseDTO();
        manager = OpenIDProvider.getInstance().getManager();
        authReq = AuthRequest.createAuthRequest((ParameterList)paramList, (RealmVerifier)manager.getRealmVerifier());
        message = manager.authResponse(paramList, request.getOpLocalId(), request.getUserSelectedClaimedId(), request.isAuthenticated());
        if (message instanceof DirectError || message instanceof AuthFailure) {
            destinationUrl = message.getDestinationUrl(true);
            response.setDestinationUrl(destinationUrl);
            response.setValidated(false);
        } else {
            OpenIDExtension extension = null;
            OpenIDAuthenticationRequest req = null;
            req = new OpenIDAuthenticationRequest();
            if (request.isPhishiingResistanceAuthRequest()) {
                req.setPhishingResistanceLogin(true);
            }
            if (request.isMultiFactorAuthRequested()) {
                req.setMultifactorLogin(true);
            }
            req.setAuthRequest(authReq);
            for (Object alias : authReq.getExtensions()) {
                req.setExtensionAlias((String)alias);
                extension = OpenIDExtensionFactory.getInstance().getExtension(req);
                if (extension == null) continue;
                MessageExtension messageExtension = null;
                messageExtension = extension.getMessageExtension(request.getOpenID(), request.getProfileName());
                if (messageExtension == null) continue;
                message.addExtension(messageExtension);
                AuthSuccess authSuccess = (AuthSuccess)message;
                authSuccess.addSignExtension((String)alias);
                manager.sign(authSuccess);
            }
            destinationUrl = message.getDestinationUrl(true);
            response.setDestinationUrl(destinationUrl);
            response.setValidated(true);
        }
        return response;
    }

    private List<String> getRequestedAttributes(AuthRequest authRequest) throws IdentityException {
        OpenIDAuthenticationRequest req = null;
        OpenIDExtension extension = null;
        ArrayList<String> requiredAttributes = null;
        req = new OpenIDAuthenticationRequest();
        req.setAuthRequest(authRequest);
        requiredAttributes = new ArrayList<String>();
        for (Object alias : authRequest.getExtensions()) {
            req.setExtensionAlias((String)alias);
            extension = OpenIDExtensionFactory.getInstance().getExtension(req);
            if (extension == null) continue;
            extension.addRequiredAttributes(requiredAttributes);
        }
        return requiredAttributes;
    }

    private ParameterList getParameterList(OpenIDParameterDTO[] params) {
        ParameterList paramList = null;
        HashMap<String, String> paramMap = null;
        paramMap = new HashMap<String, String>();
        for (OpenIDParameterDTO param : params) {
            paramMap.put(param.getName(), param.getValue());
        }
        paramList = new ParameterList(paramMap);
        return paramList;
    }

    private boolean validateIssuerInfoPolicy(SAMLTokenVerifier verifier, RelyingPartyData data) throws RelyingPartyException {
        boolean validated = false;
        String issuerName = verifier.getIssuerName();
        String issuerPolicy = data.getIssuerPolicy();
        try {
            if ("http://schemas.xmlsoap.org/ws/2005/05/identity/issuer/self".equals(issuerName)) {
                if (issuerPolicy == null || issuerPolicy.equals("SelfOnly") || issuerPolicy.equals("SelfAndManaged")) {
                    validated = true;
                }
            } else {
                validated = !issuerPolicy.equals("SelfOnly");
            }
        }
        catch (Exception e) {
            throw new RelyingPartyException("errorValidatingIssuerPolicy", (Throwable)e);
        }
        return validated;
    }

    private void setPAPEProperties(OpenIDAuthenticationRequest req, ParameterList paramList) {
        List list = null;
        list = paramList.getParameters();
        for (Object object : list) {
            Parameter param = (Parameter)object;
            if (param.getValue().contains("http://schemas.openid.net/pape/policies/2007/06/phishing-resistant")) {
                req.setPhishingResistanceLogin(true);
            }
            if (!param.getValue().contains("http://schemas.openid.net/pape/policies/2007/06/multi-factor")) continue;
            req.setMultifactorLogin(true);
        }
    }

    public boolean doXMPPBasedMultiFactorAuthForInfocard(String userId) throws Exception {
        boolean authenticationStatus = true;
        IdentityPersistenceManager persistenceManager = IdentityPersistenceManager.getPersistanceManager();
        XMPPSettingsDO xmppSettingsDO = persistenceManager.getXmppSettings(IdentityTenantUtil.getRegistry(null, (String)userId), MultitenantUtils.getTenantAwareUsername((String)userId));
        if (xmppSettingsDO != null && xmppSettingsDO.isXmppEnabled()) {
            MPAuthenticationProvider mpAuthenticationProvider = new MPAuthenticationProvider(xmppSettingsDO);
            authenticationStatus = mpAuthenticationProvider.authenticate();
        }
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)"XMPP Multifactor Authentication was completed Successfully.");
        }
        return authenticationStatus;
    }

    public OpenIDUserProfileDTO[] getUserProfiles(String openId, OpenIDParameterDTO[] requredClaims) throws Exception {
        String userName = null;
        UserRealm realm = null;
        UserStoreManager reader = null;
        String tenatUser = null;
        String domainName = null;
        try {
            userName = OpenIDUtil.getUserName(openId);
            tenatUser = MultitenantUtils.getTenantAwareUsername((String)userName);
            domainName = TenantUtils.getDomainNameFromOpenId((String)openId);
            realm = IdentityTenantUtil.getRealm((String)domainName, (String)userName);
            reader = realm.getUserStoreManager();
            String[] profileNames = reader.getProfileNames(tenatUser);
            OpenIDUserProfileDTO[] profileDtoSet = new OpenIDUserProfileDTO[profileNames.length];
            ParameterList paramList = null;
            AuthRequest authReq = null;
            List<String> claimList = null;
            paramList = this.getParameterList(requredClaims);
            authReq = AuthRequest.createAuthRequest((ParameterList)paramList, (RealmVerifier)OpenIDProvider.getInstance().getManager().getRealmVerifier());
            claimList = this.getRequestedAttributes(authReq);
            for (int i = 0; i < profileNames.length; ++i) {
                OpenIDUserProfileDTO profileDTO = new OpenIDUserProfileDTO();
                OpenIDClaimDTO[] claimSet = this.getOpenIDClaimValues(openId, profileNames[i], claimList);
                profileDTO.setProfileName(profileNames[i]);
                profileDTO.setClaimSet(claimSet);
                profileDtoSet[i] = profileDTO;
            }
            return profileDtoSet;
        }
        catch (UserStoreException e) {
            throw new Exception(e.getMessage(), e);
        }
    }

    public void updateOpenIDUserRPInfo(OpenIDUserRPDTO rpdto) throws Exception {
        String userName = OpenIDUtil.getUserName(rpdto.getOpenID());
        String domainName = MultitenantUtils.getDomainNameFromOpenId((String)rpdto.getOpenID());
        OpenIDUserRPDO rpdo = null;
        try {
            OpenIDUserRPDAO dao = new OpenIDUserRPDAO(IdentityTenantUtil.getRegistry((String)domainName, null));
            rpdo = dao.getOpenIDUserRP(userName, rpdto.getRpUrl());
            if (rpdo == null) {
                rpdo = new OpenIDUserRPDO();
                rpdo.setUserName(userName);
                rpdo.setRpUrl(rpdto.getRpUrl());
                rpdo.setVisitCount(0);
                rpdo.setTrustedAlways(rpdto.isTrustedAlways());
                rpdo.setLastVisit(new Date());
                rpdo.setVisitCount(rpdo.getVisitCount() + 1);
                rpdo.setDefaultProfileName(rpdto.getDefaultProfileName());
                MessageDigest sha = MessageDigest.getInstance("SHA-1");
                byte[] digest = sha.digest((userName + ":" + rpdto.getRpUrl()).getBytes());
                rpdo.setUuid(new String(Hex.encodeHex((byte[])digest)));
                dao.create(rpdo);
            } else {
                rpdo.setTrustedAlways(rpdto.isTrustedAlways());
                rpdo.setLastVisit(new Date());
                rpdo.setVisitCount(rpdo.getVisitCount() + 1);
                rpdo.setDefaultProfileName(rpdto.getDefaultProfileName());
                dao.update(rpdo);
            }
        }
        catch (IdentityException e) {
            throw new Exception("Error while using DAO for " + domainName, e);
        }
    }

    public OpenIDUserRPDTO[] getOpenIDUserRPs(String openID) throws Exception {
        String domainName = MultitenantUtils.getDomainNameFromOpenId((String)openID);
        OpenIDUserRPDO[] rpdos = null;
        try {
            OpenIDUserRPDAO dao = new OpenIDUserRPDAO(IdentityTenantUtil.getRegistry((String)domainName, null));
            rpdos = dao.getOpenIDUserRPs(openID);
            if (rpdos == null) {
                return null;
            }
        }
        catch (IdentityException e) {
            throw new Exception("Error while using DAO for " + domainName, e);
        }
        OpenIDUserRPDTO[] rpdto = new OpenIDUserRPDTO[rpdos.length];
        int i = 0;
        for (OpenIDUserRPDO rpdo : rpdos) {
            rpdto[i] = new OpenIDUserRPDTO(rpdo);
            ++i;
        }
        return rpdto;
    }

    public OpenIDUserRPDTO getOpenIDUserRPInfo(String openID, String rpUrl) throws Exception {
        String userName = OpenIDUtil.getUserName(openID);
        String domainName = MultitenantUtils.getTenantDomain((String)userName);
        OpenIDUserRPDO rpdo = null;
        try {
            OpenIDUserRPDAO dao = new OpenIDUserRPDAO(IdentityTenantUtil.getRegistry((String)domainName, null));
            rpdo = dao.getOpenIDUserRP(userName, rpUrl);
            if (rpdo == null) {
                return null;
            }
        }
        catch (IdentityException e) {
            throw new Exception("Error while using DAO for " + domainName, e);
        }
        return new OpenIDUserRPDTO(rpdo);
    }

    public boolean isOpenIDUserApprovalBypassEnabled() {
        String isEnabled = IdentityUtil.getProperty((String)"OpenIDSkipUserConsent");
        return isEnabled != null && isEnabled.equals("true");
    }

    private OpenIDClaimDTO[] getOpenIDClaimValues(String openId, String profileId, List<String> claimList) throws Exception {
        UserStoreManager userStore = null;
        Map claimValues = null;
        OpenIDClaimDTO[] claims = null;
        OpenIDClaimDTO dto = null;
        IdentityClaimManager claimManager = null;
        Claim[] claimData = null;
        String[] claimArray = new String[claimList.size()];
        String userName = null;
        String domainName = null;
        UserRealm realm = null;
        userName = OpenIDUtil.getUserName(openId);
        domainName = TenantUtils.getDomainNameFromOpenId((String)openId);
        String tenatUser = MultitenantUtils.getTenantAwareUsername((String)userName);
        realm = IdentityTenantUtil.getRealm((String)domainName, (String)userName);
        userStore = realm.getUserStoreManager();
        claimValues = userStore.getUserClaimValues(tenatUser, claimList.toArray(claimArray), profileId);
        claims = new OpenIDClaimDTO[claimValues.size()];
        int i = 0;
        claimManager = IdentityClaimManager.getInstance();
        for (Claim element : claimData = claimManager.getAllSupportedClaims(realm)) {
            if (!claimValues.containsKey(element.getClaimUri())) continue;
            dto = new OpenIDClaimDTO();
            dto.setClaimUri(element.getClaimUri());
            dto.setClaimValue((String)claimValues.get(element.getClaimUri()));
            dto.setDisplayTag(element.getDisplayTag());
            dto.setDescription(element.getDescription());
            claims[i++] = dto;
        }
        return claims;
    }

    private void checkUserAuthorization(String username, String operation) throws IdentityProviderException {
        MessageContext msgContext = MessageContext.getCurrentMessageContext();
        HttpServletRequest request = (HttpServletRequest)msgContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
        HttpSession httpSession = request.getSession(false);
        if (httpSession != null) {
            String userName = (String)httpSession.getAttribute(OPENID_LOGGEDIN_USER);
            if (!username.equals(userName)) {
                throw new IdentityProviderException("Unauthorised action by user " + username + " to access " + operation);
            }
            return;
        }
        throw new IdentityProviderException("Unauthorised action by user " + username + " to access " + operation);
    }

    private void validateInputParameters(String[] params, String message) {
        for (String param : params) {
            if (param != null && param.trim().length() != 0) continue;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)message);
            }
            throw new IllegalArgumentException(message);
        }
    }
}

