/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.provider;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.core.util.AdminServicesUtil;
import org.wso2.carbon.identity.core.persistence.IdentityPersistenceManager;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.provider.IdentityProviderException;

public class IdentityProviderService
extends AbstractAdmin {
    protected Log log = LogFactory.getLog(IdentityProviderService.class);

    public String getPrimaryOpenID(String userName) throws Exception {
        this.validateInputParameters(new String[]{userName}, "Invalid parameters provided to getOpenID");
        this.checkUserAuthorization(userName, "getOpenID");
        return IdentityUtil.getProperty((String)"OpenIDUserPattern") + userName;
    }

    public String[] getAllOpenIDs(String userName) throws Exception {
        this.validateInputParameters(new String[]{userName}, "Invalid parameters provided to getAllOpenIDs");
        IdentityPersistenceManager persistenceManager = IdentityPersistenceManager.getPersistanceManager();
        String[] externalOpenIDs = persistenceManager.getOpenIDsForUser(IdentityTenantUtil.getRegistry(), AdminServicesUtil.getUserRealm(), userName);
        String[] openIDset = new String[externalOpenIDs.length + 1];
        openIDset[0] = this.getPrimaryOpenID(userName);
        for (int i = 0; i < externalOpenIDs.length; ++i) {
            openIDset[i + 1] = externalOpenIDs[i];
        }
        return openIDset;
    }

    public void removeOpenID(String openID) {
        try {
            IdentityPersistenceManager persistenceManager = IdentityPersistenceManager.getPersistanceManager();
            persistenceManager.removeOpenIDSignUp(IdentityTenantUtil.getRegistry(), AdminServicesUtil.getUserRealm(), openID);
        }
        catch (Exception e) {
            this.log.error((Object)"Error instantiating a Persistence Manager.", (Throwable)e);
        }
    }

    public String extractPrimaryUserName(String ppid) throws Exception {
        return IdentityUtil.getPPIDDisplayValue((String)ppid);
    }

    private void checkUserAuthorization(String username, String operation) throws IdentityProviderException {
        MessageContext msgContext = MessageContext.getCurrentMessageContext();
        HttpServletRequest request = (HttpServletRequest)msgContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
        HttpSession httpSession = request.getSession(false);
        if (username.contains("@")) {
            username = username.substring(0, username.indexOf("@"));
        }
        if (httpSession != null) {
            String userName = (String)httpSession.getAttribute("wso2carbon.admin.logged.in");
            if (!username.equals(userName)) {
                throw new IdentityProviderException("Unauthorised action by user " + username + " to access " + operation);
            }
            return;
        }
        throw new IdentityProviderException("Unauthorised action by user " + username + " to access " + operation);
    }

    private void validateInputParameters(String[] params, String message) {
        for (int i = 0; i < params.length; ++i) {
            if (params[i] != null && params[i].trim().length() != 0) continue;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)message);
            }
            throw new IllegalArgumentException(message);
        }
    }
}

