/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.provider;

import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.rahas.RahasData;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.handler.WSHandlerResult;
import org.opensaml.SAMLAssertion;
import org.wso2.carbon.identity.base.IdentityConstants;
import org.wso2.carbon.identity.provider.GenericIdentityProviderData;
import org.wso2.carbon.identity.provider.IdentityProviderException;
import org.wso2.carbon.user.core.claim.Claim;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class IdentityProviderData
extends GenericIdentityProviderData {
    private static Log log = LogFactory.getLog(IdentityProviderData.class);
    private SAMLAssertion assertion;

    public IdentityProviderData(RahasData data) throws IdentityProviderException, ClassNotFoundException {
        super(data);
    }

    @Override
    protected void processInfoCardReference(OMElement rst) throws IdentityProviderException {
        OMElement infoCardRef = null;
        OMElement omCardID = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Processing information card reference");
        }
        infoCardRef = rst.getFirstChildWithName(new QName("http://schemas.xmlsoap.org/ws/2005/05/identity", "InformationCardReference"));
        omCardID = infoCardRef.getFirstChildWithName(new QName("http://schemas.xmlsoap.org/ws/2005/05/identity", "CardId"));
        this.cardID = omCardID.getText();
    }

    @Override
    protected void readAuthenticationMechanism(RahasData data) throws IdentityProviderException {
        MessageContext inContext = null;
        Vector results = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Reading authentication mechanism");
        }
        if ((results = (Vector)(inContext = data.getInMessageContext()).getProperty("RECV_RESULTS")) == null) {
            log.error((Object)"Missing authentication mechanism");
            throw new IdentityProviderException("Missing authentication mechanism");
        }
        for (int i = 0; i < results.size(); ++i) {
            WSHandlerResult rResult = (WSHandlerResult)results.get(i);
            Vector wsSecEngineResults = rResult.getResults();
            for (int j = 0; j < wsSecEngineResults.size(); ++j) {
                WSSecurityEngineResult wser = (WSSecurityEngineResult)wsSecEngineResults.get(j);
                int action = (Integer)wser.get((Object)"action");
                if (action == 8) {
                    this.authMechanism = 4;
                    this.assertion = (SAMLAssertion)wser.get((Object)"saml-assertion");
                    continue;
                }
                if (action != 1 || wser.get((Object)"principal") == null) continue;
                this.authMechanism = 1;
            }
        }
    }

    @Override
    public String getUserIdentifier() {
        return this.userIdentifier;
    }

    public void setUserIdentifier(String userIdentifier) {
        this.userIdentifier = userIdentifier;
    }

    @Override
    public String getTenantDomain() throws IdentityProviderException {
        if (this.authMechanism == 4) {
            return null;
        }
        if (this.userIdentifier == null) {
            throw new IllegalStateException("User identifier must NOT be null");
        }
        String domain = null;
        domain = MultitenantUtils.getTenantDomain((String)this.userIdentifier);
        return domain;
    }

    @Override
    public String getDisplayName(String URI) {
        Claim claim = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)"");
        }
        if ((claim = (Claim)this.supportedClaims.get(URI)) != null) {
            if ("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/privatepersonalidentifier".equals(claim.getClaimUri())) {
                return IdentityConstants.PPID_DISPLAY_VALUE;
            }
            return claim.getDisplayTag();
        }
        return null;
    }

    @Override
    public String getCardID() {
        return this.cardID;
    }

    @Override
    public String getDisplayTokenLang() {
        return this.displayTokenLang;
    }
}

