/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.provider;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.rahas.RahasData;
import org.apache.rahas.impl.util.SAMLAttributeCallback;
import org.apache.rahas.impl.util.SAMLCallback;
import org.apache.rahas.impl.util.SAMLCallbackHandler;
import org.opensaml.Configuration;
import org.opensaml.SAMLAttribute;
import org.opensaml.SAMLException;
import org.opensaml.common.SAMLObjectBuilder;
import org.opensaml.saml2.core.Attribute;
import org.opensaml.saml2.core.AttributeValue;
import org.opensaml.xml.XMLObjectBuilderFactory;
import org.opensaml.xml.schema.XSString;
import org.opensaml.xml.schema.impl.XSStringBuilder;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.core.IdentityClaimManager;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.identity.provider.IdentityAttributeService;
import org.wso2.carbon.identity.provider.IdentityAttributeServiceStore;
import org.wso2.carbon.identity.provider.IdentityProviderException;
import org.wso2.carbon.identity.provider.RequestedClaimData;
import org.wso2.carbon.user.core.UserStoreManager;
import org.wso2.carbon.user.core.claim.Claim;

public class AttributeCallbackHandler
implements SAMLCallbackHandler {
    private static Log log = LogFactory.getLog(AttributeCallbackHandler.class);
    protected Map<String, RequestedClaimData> requestedClaims = new HashMap<String, RequestedClaimData>();
    protected Map<String, Claim> supportedClaims = new HashMap<String, Claim>();

    public void handle(SAMLCallback callback) throws SAMLException {
        SAMLAttributeCallback attrCallback = null;
        RahasData data = null;
        OMElement claimElem = null;
        String userIdentifier = null;
        IdentityAttributeService[] attributeCallbackServices = null;
        try {
            if (callback instanceof SAMLAttributeCallback) {
                attrCallback = (SAMLAttributeCallback)callback;
                data = attrCallback.getData();
                claimElem = data.getClaimElem();
                userIdentifier = data.getPrincipal().getName();
                this.loadClaims(userIdentifier);
                this.processClaimData(data, claimElem);
                this.populateClaimValues(userIdentifier, attrCallback);
                if ("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0".equals(data.getTokenType())) {
                    if (attrCallback.getSAML2Attributes() == null || attrCallback.getSAML2Attributes().length == 0) {
                        attrCallback.addAttributes(this.getSAML2Attribute("Name", "Colombo", "https://rahas.apache.org/saml/attrns"));
                    }
                } else if (attrCallback.getAttributes() == null || attrCallback.getAttributes().length == 0) {
                    SAMLAttribute attribute = new SAMLAttribute("Name", "https://rahas.apache.org/saml/attrns", null, -1L, Arrays.asList("Colombo/Rahas"));
                    attrCallback.addAttributes(attribute);
                }
                attributeCallbackServices = IdentityAttributeServiceStore.getAttributeServices();
                for (int i = 0; i < attributeCallbackServices.length; ++i) {
                    try {
                        attributeCallbackServices[i].handle(attrCallback);
                        continue;
                    }
                    catch (Exception e) {
                        log.error((Object)"Error occuerd while calling attribute callback", (Throwable)e);
                    }
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Error occuerd while populating claim data", (Throwable)e);
        }
    }

    private Attribute getSAML2Attribute(String name, String value, String namespace) {
        XMLObjectBuilderFactory builderFactory = null;
        SAMLObjectBuilder attrBuilder = null;
        Attribute attribute = null;
        XSStringBuilder attributeValueBuilder = null;
        XSString stringValue = null;
        builderFactory = Configuration.getBuilderFactory();
        attrBuilder = (SAMLObjectBuilder)builderFactory.getBuilder(Attribute.DEFAULT_ELEMENT_NAME);
        attribute = (Attribute)attrBuilder.buildObject();
        attribute.setName(name);
        attribute.setNameFormat(namespace);
        attributeValueBuilder = (XSStringBuilder)builderFactory.getBuilder(XSString.TYPE_NAME);
        stringValue = (XSString)attributeValueBuilder.buildObject(AttributeValue.DEFAULT_ELEMENT_NAME, XSString.TYPE_NAME);
        stringValue.setValue(value);
        attribute.getAttributeValues().add(stringValue);
        return attribute;
    }

    protected void loadClaims(String userIdentifier) throws IdentityProviderException {
        IdentityClaimManager claimManager = null;
        Claim[] claims = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Loading claims");
        }
        try {
            claimManager = IdentityClaimManager.getInstance();
            claims = claimManager.getAllSupportedClaims("http://wso2.org/claims", IdentityTenantUtil.getRealm(null, (String)userIdentifier));
            for (int i = 0; i < claims.length; ++i) {
                Claim temp = claims[i];
                this.supportedClaims.put(temp.getClaimUri(), temp);
            }
        }
        catch (IdentityException e) {
            log.error((Object)"Error while loading claims", (Throwable)e);
            throw new IdentityProviderException("Error while loading claims", e);
        }
    }

    protected void processClaimData(RahasData rahasData, OMElement claims) throws IdentityProviderException {
        if (claims == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Processing claim data");
        }
        Iterator iterator = null;
        iterator = claims.getChildrenWithName(new QName("http://schemas.xmlsoap.org/ws/2005/05/identity", "ClaimType"));
        while (iterator.hasNext()) {
            OMElement omElem = null;
            RequestedClaimData claim = null;
            String uriClaim = null;
            String optional = null;
            omElem = (OMElement)iterator.next();
            claim = this.getRequestedClaim();
            uriClaim = omElem.getAttributeValue(new QName(null, "Uri"));
            if (uriClaim == null) {
                log.error((Object)"Empty claim uri found while procession claim data");
                throw new IdentityProviderException("Empty claim uri found while procession claim data");
            }
            claim.setUri(uriClaim);
            optional = omElem.getAttributeValue(new QName(null, "Optional"));
            if (optional != null) {
                claim.setBOptional(optional.equals("true"));
            } else {
                claim.setBOptional(true);
            }
            this.requestedClaims.put(claim.getUri(), claim);
        }
    }

    protected void populateClaimValues(String userIdentifier, SAMLAttributeCallback callback) throws IdentityProviderException {
        UserStoreManager connector = null;
        RahasData rahasData = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Populating claim values");
        }
        if (this.requestedClaims.isEmpty()) {
            return;
        }
        try {
            connector = IdentityTenantUtil.getRealm(null, (String)userIdentifier).getUserStoreManager();
        }
        catch (Exception e) {
            log.error((Object)"Error while instantiating IdentityUserStore", (Throwable)e);
            throw new IdentityProviderException("Error while instantiating IdentityUserStore", e);
        }
        Iterator<RequestedClaimData> ite = this.requestedClaims.values().iterator();
        ArrayList<String> claimList = new ArrayList<String>();
        rahasData = callback.getData();
        while (ite.hasNext()) {
            RequestedClaimData claim = ite.next();
            if (claim == null || claim.getUri().equals("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/privatepersonalidentifier")) continue;
            claimList.add(claim.getUri());
        }
        String[] claimArray = new String[claimList.size()];
        String userId = userIdentifier;
        Map mapValues = null;
        try {
            mapValues = connector.getUserClaimValues(userId, claimList.toArray(claimArray), null);
            ite = this.requestedClaims.values().iterator();
            while (ite.hasNext()) {
                SAMLAttribute attribute = null;
                Attribute saml2Attribute = null;
                RequestedClaimData claimData = ite.next();
                claimData.setValue((String)mapValues.get(claimData.getUri()));
                if (claimData.getValue() == null) continue;
                if ("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0".equals(rahasData.getTokenType())) {
                    saml2Attribute = this.getSAML2Attribute(claimData.getUri(), claimData.getValue(), claimData.getUri());
                    callback.addAttributes(saml2Attribute);
                    continue;
                }
                attribute = new SAMLAttribute(this.supportedClaims.get(claimData.getUri()).getDisplayTag(), claimData.getUri(), null, -1L, Arrays.asList(claimData.getValue()));
                callback.addAttributes(attribute);
            }
        }
        catch (Exception e) {
            throw new IdentityProviderException(e.getMessage(), e);
        }
    }

    protected RequestedClaimData getRequestedClaim() {
        return new RequestedClaimData();
    }
}

