/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.provider.ui.client;

import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.provider.stub.XMPPConfigurationServiceStub;
import org.wso2.carbon.identity.provider.stub.dto.XMPPSettingsDTO;

public class XMPPConfiguratorClient {
    private static final Log log = LogFactory.getLog(XMPPConfiguratorClient.class);
    private XMPPConfigurationServiceStub stub = null;

    public XMPPConfiguratorClient(String cookie, String backendServerURL, ConfigurationContext configCtx) throws AxisFault {
        String serviceURL = backendServerURL + "XMPPConfigurationService";
        this.stub = new XMPPConfigurationServiceStub(configCtx, serviceURL);
        ServiceClient client = this.stub._getServiceClient();
        Options option = client.getOptions();
        option.setManageSession(true);
        option.setProperty("Cookie", (Object)cookie);
    }

    public void addXmppSettings(XMPPSettingsDTO dto) {
        try {
            log.info((Object)("trying to add XmppSettings for user :" + dto.getUserId()));
            this.stub.addUserXmppSettings(dto);
        }
        catch (Exception e) {
            log.error((Object)"Error when adding the XMPP Settings.", (Throwable)e);
        }
    }

    public void editXmppSettings(XMPPSettingsDTO dto) {
        try {
            log.info((Object)("trying to edit the XmppSettings of user :" + dto.getUserId()));
            this.stub.editXmppSettings(dto);
        }
        catch (Exception e) {
            log.error((Object)"Error when updating the XMPP Settings.", (Throwable)e);
        }
    }

    public XMPPSettingsDTO getXmppSettingsDTO(String userId) {
        try {
            log.info((Object)("trying to retrieve the XmppSettings of user :" + userId));
            return this.stub.getXmppSettings(userId);
        }
        catch (Exception e) {
            log.error((Object)"Error when retrieving the XMPP Settings.", (Throwable)e);
            return null;
        }
    }

    public boolean isXmppSettingsEnabled(String userId) {
        try {
            return this.stub.isXMPPSettingsEnabled(userId);
        }
        catch (Exception e) {
            log.error((Object)"Error when checking whether the XMPP based multifactor authentication is enabled.", (Throwable)e);
            return false;
        }
    }

    public boolean isXMPPSettingsAvailable(String userId) {
        try {
            return this.stub.hasXMPPSettings(userId);
        }
        catch (Exception e) {
            log.error((Object)"Error when checking whether the XMPP based multifactor authentication is enabled.", (Throwable)e);
            return false;
        }
    }

    public String getUserIM(String userID) {
        try {
            return this.stub.getUserIM(userID);
        }
        catch (Exception e) {
            log.error((Object)"Error when retreiving IM", (Throwable)e);
            return null;
        }
    }
}

