/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.provider.openid.admin.ui.client;

import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.provider.openid.admin.stub.OpenIDConfigurationServiceStub;
import org.wso2.carbon.identity.provider.openid.admin.stub.dto.OpenIDConfigurationDTO;

public class OpenIDConfigurationClient {
    private OpenIDConfigurationServiceStub stub;
    private static final Log log = LogFactory.getLog(OpenIDConfigurationClient.class);

    public OpenIDConfigurationClient(String cookie, String backendServerURL, ConfigurationContext configCtx) throws AxisFault {
        String serviceURL = backendServerURL + "OpenIDConfigurationService";
        this.stub = new OpenIDConfigurationServiceStub(configCtx, serviceURL);
        ServiceClient client = this.stub._getServiceClient();
        Options option = client.getOptions();
        option.setManageSession(true);
        option.setProperty("Cookie", (Object)cookie);
    }

    public void createOrUpdateOpenIDAdmin(OpenIDConfigurationDTO dto) throws AxisFault {
        try {
            this.stub.createOrUpdateOpenIDCOnfiguration(dto);
        }
        catch (Exception e) {
            throw new AxisFault(e.getMessage(), (Throwable)e);
        }
    }

    public OpenIDConfigurationDTO getOpenIDAdmin(String userName, String domainName) throws AxisFault {
        try {
            return this.stub.getOpenIDConfiguration(userName, domainName);
        }
        catch (Exception e) {
            throw new AxisFault(e.getMessage(), (Throwable)e);
        }
    }
}

