/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.provider.xmpp;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.core.model.XMPPSettingsDO;
import org.wso2.carbon.identity.core.persistence.IdentityPersistenceManager;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.identity.provider.dto.XMPPSettingsDTO;

public class XMPPConfigurator {
    protected Log log = LogFactory.getLog(XMPPConfigurator.class);

    public void addXmppSettings(XMPPSettingsDTO dto) {
        try {
            IdentityPersistenceManager persistentManager = IdentityPersistenceManager.getPersistanceManager();
            persistentManager.addXmppSettings(IdentityTenantUtil.getRegistry(), dto.getUserId(), dto.getXmppServer(), dto.getXmppUserName(), dto.getUserCode(), dto.isXmppEnabled(), dto.isPINEnabled());
        }
        catch (Exception e) {
            this.log.error((Object)"Error when instantiating the Persistence Manager.", (Throwable)e);
        }
    }

    public void editXmppSettings(XMPPSettingsDTO dto) {
        try {
            IdentityPersistenceManager persistentManager = IdentityPersistenceManager.getPersistanceManager();
            persistentManager.updateXmppSettings(IdentityTenantUtil.getRegistry(), dto.getUserId(), dto.getXmppServer(), dto.getXmppUserName(), dto.getUserCode(), dto.isXmppEnabled(), dto.isPINEnabled());
        }
        catch (Exception e) {
            this.log.error((Object)"Error when instantiating the Persistence Manager.", (Throwable)e);
        }
    }

    public XMPPSettingsDTO getXmppSettings(String userId) {
        XMPPSettingsDTO xmppSettingsDTO = null;
        try {
            IdentityPersistenceManager persistenceManager = IdentityPersistenceManager.getPersistanceManager();
            XMPPSettingsDO xmppSettingsDO = persistenceManager.getXmppSettings(IdentityTenantUtil.getRegistry(), userId);
            xmppSettingsDTO = new XMPPSettingsDTO();
            xmppSettingsDTO.setXmppServer(xmppSettingsDO.getXmppServer());
            xmppSettingsDTO.setXmppUserName(xmppSettingsDO.getXmppUserName());
            xmppSettingsDTO.setUserCode(xmppSettingsDO.getUserCode());
            xmppSettingsDTO.setXmppEnabled(xmppSettingsDO.isXmppEnabled());
            xmppSettingsDTO.setPINEnabled(xmppSettingsDO.isPINEnabled());
        }
        catch (Exception e) {
            this.log.error((Object)"Error when instantiating the Persistence Manager.", (Throwable)e);
        }
        return xmppSettingsDTO;
    }

    public boolean isXmppSettingsEnabled(String userId) {
        try {
            IdentityPersistenceManager persistenceManager = IdentityPersistenceManager.getPersistanceManager();
            return persistenceManager.isXmppSettingsEnabled(IdentityTenantUtil.getRegistry(), userId);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean hasXMPPSettings(String userId) {
        try {
            IdentityPersistenceManager persistenceManager = IdentityPersistenceManager.getPersistanceManager();
            return persistenceManager.hasXMPPSettings(IdentityTenantUtil.getRegistry(), userId);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

