/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.provider.xmpp;

import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jivesoftware.smack.Chat;
import org.jivesoftware.smack.ChatManager;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.Roster;
import org.jivesoftware.smack.RosterEntry;
import org.jivesoftware.smack.RosterListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.FromContainsFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Presence;
import org.wso2.carbon.identity.core.model.XMPPSettingsDO;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.provider.xmpp.XmppResponseListener;
import org.wso2.carbon.identity.provider.xmpp.XmppSubscriber;
import org.wso2.carbon.identity.provider.xmpp.XmppSubscriptionListener;

public class MPAuthenticationProvider {
    protected Log log = LogFactory.getLog(MPAuthenticationProvider.class);
    private String userXmppId;
    private String userPIN;
    private boolean isPINEnabled;
    private boolean pinDisabledResponse = true;

    public MPAuthenticationProvider(XMPPSettingsDO xmppSettingsDO) {
        this.userXmppId = xmppSettingsDO.getXmppUserName().trim();
        this.userPIN = xmppSettingsDO.getUserCode().trim();
        this.isPINEnabled = xmppSettingsDO.isPINEnabled();
    }

    public boolean authenticate() {
        XMPPConnection connection = this.createConnection();
        boolean connectionStatus = this.connect(connection);
        if (!connectionStatus) {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)"Failed to connect to the Server");
            }
            return false;
        }
        boolean loginStatus = this.login(connection);
        if (!loginStatus) {
            System.out.println("login failed");
            return false;
        }
        Roster roster = connection.getRoster();
        Presence presence = roster.getPresence(this.userXmppId);
        boolean isAvailable = false;
        if (!presence.isAvailable()) {
            isAvailable = this.checkforUserAvailability(roster, this.userXmppId);
        }
        if (!isAvailable) {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)"user is not online");
            }
            return false;
        }
        boolean validation = this.getUserResponse(connection, this.userXmppId);
        if (!validation && !this.pinDisabledResponse) {
            validation = this.getUserResponse(connection, this.userXmppId);
        }
        return validation;
    }

    private XMPPConnection createConnection() {
        String xmppServer = IdentityUtil.getProperty((String)"MultifactorAuthentication.XMPPSettings.XMPPConfig.XMPPServer");
        int xmppPort = new Integer(IdentityUtil.getProperty((String)"MultifactorAuthentication.XMPPSettings.XMPPConfig.XMPPPort"));
        String xmppExt = IdentityUtil.getProperty((String)"MultifactorAuthentication.XMPPSettings.XMPPConfig.XMPPExt");
        ConnectionConfiguration config = new ConnectionConfiguration(xmppServer, xmppPort, xmppExt);
        config.setSASLAuthenticationEnabled(true);
        XMPPConnection connection = new XMPPConnection(config);
        return connection;
    }

    private boolean isAvailable(Roster roster, String userName) {
        Collection entrySet = roster.getEntries();
        for (RosterEntry entry : entrySet) {
            if (!entry.getUser().equals(userName)) continue;
            return true;
        }
        return false;
    }

    private boolean connect(XMPPConnection connection) {
        for (int i = 0; i < 3; ++i) {
            try {
                connection.connect();
                return true;
            }
            catch (XMPPException ex) {
                this.log.error((Object)"Failed to create connection with the server", (Throwable)ex);
                if (!this.log.isInfoEnabled()) continue;
                this.log.info((Object)"Attempting to connect to the server again..");
                continue;
            }
        }
        return false;
    }

    public boolean login(XMPPConnection connection) {
        String userName = IdentityUtil.getProperty((String)"MultifactorAuthentication.XMPPSettings.XMPPConfig.XMPPUserName");
        String password = IdentityUtil.getProperty((String)"MultifactorAuthentication.XMPPSettings.XMPPConfig.XMPPPassword");
        for (int i = 0; i < 3; ++i) {
            try {
                connection.login(userName, password, null);
                return true;
            }
            catch (XMPPException ex) {
                this.log.error((Object)"login failed. Trying again..", (Throwable)ex);
                continue;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkforUserAvailability(Roster roster, String userXmppId) {
        boolean isAvailable = false;
        XmppSubscriptionListener listener = new XmppSubscriptionListener(userXmppId);
        roster.addRosterListener((RosterListener)listener);
        Presence presence = roster.getPresence(userXmppId);
        boolean status = this.isAvailable(roster, userXmppId);
        try {
            if (!status) {
                boolean contactAddStatus;
                if (this.log.isInfoEnabled()) {
                    this.log.info((Object)"The User is not subscribed.");
                }
                if (contactAddStatus = new XmppSubscriber().addContact(roster, userXmppId)) {
                    if (this.log.isInfoEnabled()) {
                        this.log.info((Object)"User's Contact is added successfully..");
                    }
                } else if (this.log.isInfoEnabled()) {
                    this.log.info((Object)"Failed to add contact.");
                }
                if (!presence.isAvailable()) {
                    while (!listener.isOnline()) {
                        Thread.sleep(5000L);
                    }
                }
                isAvailable = true;
            } else {
                if (this.log.isInfoEnabled()) {
                    this.log.info((Object)"User is not online..");
                }
                while (!listener.isOnline()) {
                    Thread.sleep(5000L);
                }
                isAvailable = true;
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            roster.removeRosterListener((RosterListener)listener);
        }
        return isAvailable;
    }

    public boolean getUserResponse(XMPPConnection connection, String userName) {
        String response = null;
        Presence presence = connection.getRoster().getPresence(userName);
        if (presence.isAvailable()) {
            try {
                ChatManager chatManager = connection.getChatManager();
                Chat chat = chatManager.createChat(userName, null);
                AndFilter filter = new AndFilter(new PacketFilter[]{new PacketTypeFilter(Message.class), new FromContainsFilter(userName)});
                XmppResponseListener chatListener = new XmppResponseListener();
                connection.addPacketListener((PacketListener)chatListener, (PacketFilter)filter);
                if (this.isPINEnabled) {
                    chat.sendMessage("Please reply with your PIN Number here.");
                    if (this.log.isInfoEnabled()) {
                        this.log.info((Object)"User PIN is sent to the user and awaiting for the response.");
                    }
                    while (!chatListener.isResponseReceived()) {
                        Thread.sleep(100L);
                    }
                    response = chatListener.getResponse();
                    if (response != null) {
                        return this.userPIN.contentEquals(response.trim());
                    }
                } else {
                    chat.sendMessage("You are about to get authenticated for your OpenID. Do you want to continue: [Yes] or [No]");
                    if (this.log.isInfoEnabled()) {
                        this.log.info((Object)"User PIN is sent to the user and awaiting for the response.");
                    }
                    while (!chatListener.isResponseReceived()) {
                        Thread.sleep(100L);
                    }
                    response = chatListener.getResponse();
                    if (response != null) {
                        if (response.trim().toUpperCase().equals("YES")) {
                            return true;
                        }
                        if (response.trim().toUpperCase().equals("NO")) {
                            return false;
                        }
                        this.pinDisabledResponse = false;
                        return false;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            return false;
        }
        return false;
    }
}

