/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.provider.saml;

import java.security.cert.CertificateEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.rahas.RahasData;
import org.apache.xml.security.utils.Base64;
import org.joda.time.DateTime;
import org.opensaml.saml2.core.Assertion;
import org.opensaml.saml2.core.Attribute;
import org.opensaml.saml2.core.AttributeStatement;
import org.opensaml.saml2.core.AttributeValue;
import org.opensaml.saml2.core.Audience;
import org.opensaml.saml2.core.AudienceRestriction;
import org.opensaml.saml2.core.Conditions;
import org.opensaml.saml2.core.Issuer;
import org.opensaml.saml2.core.Subject;
import org.opensaml.saml2.core.SubjectConfirmation;
import org.opensaml.saml2.core.SubjectConfirmationData;
import org.opensaml.xml.Configuration;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.XMLObjectBuilder;
import org.opensaml.xml.XMLObjectBuilderFactory;
import org.opensaml.xml.io.Marshaller;
import org.opensaml.xml.io.MarshallerFactory;
import org.opensaml.xml.io.MarshallingException;
import org.opensaml.xml.schema.XSBase64Binary;
import org.opensaml.xml.schema.XSString;
import org.opensaml.xml.schema.impl.XSBase64BinaryBuilder;
import org.opensaml.xml.schema.impl.XSStringBuilder;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.x509.X509Credential;
import org.opensaml.xml.signature.KeyInfo;
import org.opensaml.xml.signature.Signature;
import org.opensaml.xml.signature.Signer;
import org.opensaml.xml.signature.X509Certificate;
import org.opensaml.xml.signature.X509Data;
import org.w3c.dom.Element;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.identity.provider.GenericIdentityProviderData;
import org.wso2.carbon.identity.provider.IdentityProviderException;
import org.wso2.carbon.identity.provider.RequestedClaimData;
import org.wso2.carbon.identity.provider.saml.SAMLTokenBuilder;

public class SAML2TokenBuilder
implements SAMLTokenBuilder {
    private static Log log = LogFactory.getLog(SAML2TokenBuilder.class);
    protected Assertion assertion = null;
    protected AttributeStatement attributeStmt = null;
    protected List<Signature> signatureList = new ArrayList<Signature>();
    protected Element signedAssertion = null;
    protected String appilesTo = null;
    public static final String CONF_KEY = "urn:oasis:names:tc:SAML:2.0:cm:holder-of-key";

    @Override
    public void createStatement(GenericIdentityProviderData ipData, RahasData rahasData) throws IdentityProviderException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Begin SAML statement creation.");
        }
        this.attributeStmt = (AttributeStatement)SAML2TokenBuilder.buildXMLObject(AttributeStatement.DEFAULT_ELEMENT_NAME);
        Map<String, RequestedClaimData> mapClaims = ipData.getRequestedClaims();
        if (rahasData.getAppliesToAddress() != null) {
            this.appilesTo = rahasData.getAppliesToAddress();
        }
        for (RequestedClaimData claim : mapClaims.values()) {
            String uri = claim.getUri();
            int index = uri.lastIndexOf("/");
            String attrName = uri.substring(index + 1, uri.length());
            String attrNamespace = uri.substring(0, index);
            Attribute attribute = (Attribute)SAML2TokenBuilder.buildXMLObject(Attribute.DEFAULT_ELEMENT_NAME);
            attribute.setName(attrName);
            attribute.setNameFormat(attrNamespace);
            XMLObjectBuilderFactory builderFactory = Configuration.getBuilderFactory();
            if (claim.getUri().equals("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/privatepersonalidentifier")) {
                XSBase64BinaryBuilder ppidValueBuilder = (XSBase64BinaryBuilder)builderFactory.getBuilder(XSBase64Binary.TYPE_NAME);
                XSBase64Binary ppidValue = (XSBase64Binary)ppidValueBuilder.buildObject(AttributeValue.DEFAULT_ELEMENT_NAME, XSBase64Binary.TYPE_NAME);
                ppidValue.setValue(claim.getValue());
                attribute.getAttributeValues().add(ppidValue);
            } else {
                XSStringBuilder attributeValueBuilder = (XSStringBuilder)builderFactory.getBuilder(XSString.TYPE_NAME);
                XSString stringValue = (XSString)attributeValueBuilder.buildObject(AttributeValue.DEFAULT_ELEMENT_NAME, XSString.TYPE_NAME);
                stringValue.setValue(claim.getValue());
                attribute.getAttributeValues().add(stringValue);
            }
            this.attributeStmt.getAttributes().add(attribute);
        }
    }

    @Override
    public void createSAMLAssertion(DateTime notAfter, DateTime notBefore, String assertionId) throws IdentityProviderException {
        this.assertion = (Assertion)SAML2TokenBuilder.buildXMLObject(Assertion.DEFAULT_ELEMENT_NAME);
        Conditions conditions = (Conditions)SAML2TokenBuilder.buildXMLObject(Conditions.DEFAULT_ELEMENT_NAME);
        conditions.setNotBefore(notBefore);
        conditions.setNotOnOrAfter(notAfter);
        ServerConfiguration config = ServerConfiguration.getInstance();
        String host = "http://" + config.getFirstProperty("HostName");
        Issuer issuer = (Issuer)SAML2TokenBuilder.buildXMLObject(Issuer.DEFAULT_ELEMENT_NAME);
        issuer.setValue(host);
        this.assertion.setIssuer(issuer);
        this.assertion.setIssueInstant(new DateTime());
        if (this.appilesTo != null) {
            Audience audience = (Audience)SAML2TokenBuilder.buildXMLObject(Audience.DEFAULT_ELEMENT_NAME);
            audience.setAudienceURI(this.appilesTo);
            AudienceRestriction audienceRestrictions = (AudienceRestriction)SAML2TokenBuilder.buildXMLObject(AudienceRestriction.DEFAULT_ELEMENT_NAME);
            audienceRestrictions.getAudiences().add(audience);
            conditions.getAudienceRestrictions().add(audienceRestrictions);
        }
        this.assertion.setConditions(conditions);
        this.assertion.getAttributeStatements().add(this.attributeStmt);
        this.assertion.setID(assertionId);
        Subject subject = (Subject)SAML2TokenBuilder.buildXMLObject(Subject.DEFAULT_ELEMENT_NAME);
        SubjectConfirmation subjectConf = (SubjectConfirmation)SAML2TokenBuilder.buildXMLObject(SubjectConfirmation.DEFAULT_ELEMENT_NAME);
        SubjectConfirmationData confData = (SubjectConfirmationData)SAML2TokenBuilder.buildXMLObject(SubjectConfirmationData.DEFAULT_ELEMENT_NAME);
        confData.setAddress(CONF_KEY);
        subjectConf.setSubjectConfirmationData(confData);
        subject.getSubjectConfirmations().add(subjectConf);
        this.assertion.setSubject(subject);
    }

    @Override
    public void setSignature(String signatureAlgorithm, X509Credential cred) throws IdentityProviderException {
        Signature signature = (Signature)SAML2TokenBuilder.buildXMLObject(Signature.DEFAULT_ELEMENT_NAME);
        signature.setSigningCredential((Credential)cred);
        signature.setSignatureAlgorithm(signatureAlgorithm);
        signature.setCanonicalizationAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#");
        try {
            KeyInfo keyInfo = (KeyInfo)SAML2TokenBuilder.buildXMLObject(KeyInfo.DEFAULT_ELEMENT_NAME);
            X509Data data = (X509Data)SAML2TokenBuilder.buildXMLObject(X509Data.DEFAULT_ELEMENT_NAME);
            X509Certificate cert = (X509Certificate)SAML2TokenBuilder.buildXMLObject(X509Certificate.DEFAULT_ELEMENT_NAME);
            String value = Base64.encode((byte[])cred.getEntityCertificate().getEncoded());
            cert.setValue(value);
            data.getX509Certificates().add(cert);
            keyInfo.getX509Datas().add(data);
            signature.setKeyInfo(keyInfo);
        }
        catch (CertificateEncodingException e) {
            throw new IdentityProviderException("errorGettingCert");
        }
        this.assertion.setSignature(signature);
        this.signatureList.add(signature);
    }

    @Override
    public void marshellAndSign() throws IdentityProviderException {
        try {
            MarshallerFactory marshallerFactory = Configuration.getMarshallerFactory();
            Marshaller marshaller = marshallerFactory.getMarshaller((XMLObject)this.assertion);
            this.signedAssertion = marshaller.marshall((XMLObject)this.assertion);
            Signer.signObjects(this.signatureList);
        }
        catch (MarshallingException e) {
            log.debug((Object)e);
            throw new IdentityProviderException("errorMarshellingOrSigning", e);
        }
        catch (Exception e) {
            log.debug((Object)e);
            throw new IdentityProviderException("errorMarshellingOrSigning", e);
        }
    }

    @Override
    public Element getSAMLasDOM() throws IdentityProviderException {
        return this.signedAssertion;
    }

    protected static XMLObject buildXMLObject(QName objectQName) throws IdentityProviderException {
        XMLObjectBuilder builder = Configuration.getBuilderFactory().getBuilder(objectQName);
        if (builder == null) {
            throw new IdentityProviderException("Unable to retrieve builder for object QName " + objectQName);
        }
        return builder.buildObject(objectQName.getNamespaceURI(), objectQName.getLocalPart(), objectQName.getPrefix());
    }
}

