/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.provider;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Hashtable;
import javax.xml.namespace.QName;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.rahas.RahasData;
import org.w3c.dom.Element;
import org.wso2.carbon.identity.provider.GenericIdentityProviderData;
import org.wso2.carbon.identity.provider.IdentityProviderException;

public class IdentityProviderUtil {
    private static Log log = LogFactory.getLog(IdentityProviderUtil.class);
    private static boolean intial;

    public static boolean isIntial() {
        return intial;
    }

    public static void setIntial(boolean intial) {
        IdentityProviderUtil.intial = intial;
    }

    public static OMElement createRequestedDisplayToken(OMElement parent, GenericIdentityProviderData data) {
        return IdentityProviderUtil.createOMElement(parent, "http://schemas.xmlsoap.org/ws/2005/05/identity", "RequestedDisplayToken", "ic");
    }

    public static OMElement createDisplayToken(OMElement parent, GenericIdentityProviderData data) {
        OMElement displayElem = IdentityProviderUtil.createOMElement(parent, "http://schemas.xmlsoap.org/ws/2005/05/identity", "DisplayToken", "ic");
        return displayElem;
    }

    public static OMElement createDisplayClaim(OMElement parent, String displayTag, String displayValue, String uri) {
        OMElement claimElem = IdentityProviderUtil.createOMElement(parent, "http://schemas.xmlsoap.org/ws/2005/05/identity", "DisplayClaim", "ic");
        claimElem.addAttribute("Uri", uri, null);
        OMElement tagElem = IdentityProviderUtil.createOMElement(claimElem, "http://schemas.xmlsoap.org/ws/2005/05/identity", "DisplayTag", "ic");
        tagElem.setText(displayTag);
        OMElement valElem = IdentityProviderUtil.createOMElement(claimElem, "http://schemas.xmlsoap.org/ws/2005/05/identity", "DisplayValue", "ic");
        valElem.setText(displayValue);
        return claimElem;
    }

    public static OMElement createOpenIdToken(OMElement parent, GenericIdentityProviderData data) {
        return IdentityProviderUtil.createOMElement(parent, "http://specs.openid.net/auth/2.0", "OpenIDToken", "openid");
    }

    private static OMElement createOMElement(OMElement parent, String ns, String ln, String prefix) {
        return parent.getOMFactory().createOMElement(new QName(ns, ln, prefix), (OMContainer)parent);
    }

    public static String dumpInfoCard(ConfigurationContext configurationContext, Element content) {
        Hashtable<String, String> fileResourcesMap = null;
        String workdir = null;
        String uuid = null;
        File infoCard = null;
        FileOutputStream outStream = null;
        String filePath = null;
        workdir = (String)configurationContext.getProperty("WORK_DIR");
        uuid = String.valueOf((double)System.currentTimeMillis() + Math.random()) + ".crd";
        infoCard = new File(workdir + File.separator + "dump_cards");
        if (infoCard.exists() || !infoCard.mkdirs()) {
            // empty if block
        }
        filePath = workdir + File.separator + "dump_cards" + File.separator + uuid;
        try {
            outStream = new FileOutputStream(filePath);
            TransformerFactory.newInstance().newTransformer().transform(new DOMSource(content), new StreamResult(outStream));
            outStream.flush();
            ((OutputStream)outStream).close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        fileResourcesMap = (Hashtable<String, String>)configurationContext.getProperty("file.resource.map");
        if (fileResourcesMap == null) {
            fileResourcesMap = new Hashtable<String, String>();
            configurationContext.setProperty("file.resource.map", fileResourcesMap);
        }
        fileResourcesMap.put(uuid, filePath);
        return "/filedownload?id=" + uuid;
    }

    public static String getAppliesToHostName(RahasData data) throws IdentityProviderException {
        if (data.getAppliesToEpr() == null) {
            return null;
        }
        String relyingPartyURI = data.getAppliesToAddress();
        if (relyingPartyURI == null && (relyingPartyURI = data.getAppliesToEpr().getText()) == null) {
            throw new IdentityProviderException("cannotFindRelyingParty");
        }
        URI uri = null;
        try {
            uri = new URI(relyingPartyURI);
        }
        catch (URISyntaxException e) {
            throw new IdentityProviderException("Invalid Uril", e);
        }
        return uri.getHost();
    }
}

