/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.service.mgt.util;

import java.io.File;
import java.net.SocketException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.transports.http.HttpTransportListener;
import org.wso2.carbon.utils.NetworkUtils;

public final class Utils {
    private static final Log log = LogFactory.getLog(Utils.class);
    private static boolean isServletTransport = false;
    private static boolean isServletTransportSet = false;
    private static final int SECONDS_PER_DAY = 86400;

    private Utils() {
    }

    public static String[] getWsdlInformation(String serviceName, AxisConfiguration axisConfig) throws AxisFault {
        String ip;
        try {
            ip = NetworkUtils.getLocalHostname();
        }
        catch (SocketException e) {
            throw new AxisFault("Cannot get local host name", (Throwable)e);
        }
        TransportInDescription transportInDescription = axisConfig.getTransportIn("http");
        if (transportInDescription == null) {
            transportInDescription = axisConfig.getTransportIn("https");
        }
        if (transportInDescription != null) {
            EndpointReference[] epr = transportInDescription.getReceiver().getEPRsForService(serviceName, ip);
            String wsdlUrlPrefix = epr[0].getAddress();
            if (wsdlUrlPrefix.endsWith("/")) {
                wsdlUrlPrefix = wsdlUrlPrefix.substring(0, wsdlUrlPrefix.length() - 1);
            }
            return new String[]{wsdlUrlPrefix + "?wsdl", wsdlUrlPrefix + "?wsdl2"};
        }
        return new String[0];
    }

    private static boolean isServletTransport(AxisConfiguration axisConfig) {
        if (!isServletTransportSet) {
            TransportInDescription transportInDescription = axisConfig.getTransportIn("http");
            if (transportInDescription == null) {
                transportInDescription = axisConfig.getTransportIn("https");
            }
            if (transportInDescription != null && transportInDescription.getReceiver() instanceof HttpTransportListener) {
                isServletTransport = true;
            }
            isServletTransportSet = true;
        }
        return isServletTransport;
    }

    public static String getTryitURL(String serviceName, ConfigurationContext configurationContext) throws AxisFault {
        AxisConfiguration axisConfig = configurationContext.getAxisConfiguration();
        String wsdlURL = Utils.getWsdlInformation(serviceName, axisConfig)[0];
        String tryitPrefix = wsdlURL.substring(0, wsdlURL.length() - serviceName.length() - 5);
        if (!Utils.isServletTransport(axisConfig)) {
            int tenantIndex = tryitPrefix.indexOf("/t/");
            tryitPrefix = tenantIndex != -1 ? tryitPrefix.substring(tryitPrefix.substring(0, tryitPrefix.indexOf("/t/")).lastIndexOf("/")) : configurationContext.getServiceContextPath() + "/";
        }
        return tryitPrefix + serviceName + "?tryit";
    }

    public static void deleteEmptyDirsOnPath(String path, String stopPoint) {
        File currentFile;
        if (!path.contains(File.separator + stopPoint)) {
            return;
        }
        if (path.endsWith(File.separator)) {
            path = path.substring(0, path.length());
        }
        if ((currentFile = new File(path)).exists() && currentFile.isDirectory()) {
            String[] contents = currentFile.list();
            if (contents == null || contents.length == 0) {
                if (!currentFile.delete()) {
                    log.error((Object)("Unable to delete File : " + currentFile.getAbsoluteFile()));
                }
            } else {
                return;
            }
        }
        if (!path.endsWith(File.separator + stopPoint)) {
            Utils.deleteEmptyDirsOnPath(path.substring(0, path.lastIndexOf(File.separator)), stopPoint);
        }
    }

    public static String getFormattedDuration(long timeInMilliSeconds) {
        int hours;
        long timeDifference = (System.currentTimeMillis() - timeInMilliSeconds) / 1000L;
        String value = "";
        long days = timeDifference / 86400L;
        if (days > 0L) {
            value = value + days + "day(s) ";
        }
        if ((hours = (int)((timeDifference -= days * 86400L) / 3600L)) > 0) {
            value = value + hours + "hr(s) ";
        }
        int minutes = (int)((timeDifference -= (long)(hours * 3600)) / 60L);
        value = value + minutes + "min(s)";
        return value;
    }
}

