/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.service.mgt;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.core.persistence.PersistenceException;
import org.wso2.carbon.core.persistence.PersistenceFactory;
import org.wso2.carbon.core.persistence.PersistenceUtils;
import org.wso2.carbon.core.persistence.ServiceGroupPersistenceManager;
import org.wso2.carbon.core.persistence.file.ServiceGroupFilePersistenceManager;
import org.wso2.carbon.core.util.ParameterUtil;
import org.wso2.carbon.core.util.SystemFilter;
import org.wso2.carbon.service.mgt.ParameterMetaData;
import org.wso2.carbon.service.mgt.ServiceAdmin;
import org.wso2.carbon.service.mgt.ServiceGroupMetaData;
import org.wso2.carbon.service.mgt.ServiceGroupMetaDataWrapper;
import org.wso2.carbon.service.mgt.ServiceMetaData;
import org.wso2.carbon.service.mgt.util.ServiceArchiveCreator;
import org.wso2.carbon.service.mgt.util.Utils;
import org.wso2.carbon.utils.DataPaginator;
import org.wso2.carbon.utils.Pageable;
import org.wso2.carbon.utils.ServerException;

public class ServiceGroupAdmin
extends AbstractAdmin {
    private static Log log = LogFactory.getLog(ServiceGroupAdmin.class);
    private PersistenceFactory pf;
    private ServiceGroupPersistenceManager persistenceManager;

    public ServiceGroupAdmin() throws Exception {
        this.pf = PersistenceFactory.getInstance((AxisConfiguration)this.getAxisConfig());
        this.persistenceManager = this.pf.getServiceGroupPM();
    }

    public ServiceGroupAdmin(ConfigurationContext configCtx) throws Exception {
        super(configCtx.getAxisConfiguration());
        this.setConfigurationContext(configCtx);
        this.pf = PersistenceFactory.getInstance((AxisConfiguration)this.getAxisConfig());
        this.persistenceManager = this.pf.getServiceGroupPM();
    }

    public ServiceGroupMetaDataWrapper listServiceGroups(String serviceTypeFilter, String serviceGroupSearchString, int pageNumber) throws AxisFault {
        if (serviceTypeFilter == null) {
            serviceTypeFilter = "ALL";
        }
        if (pageNumber < 0 || pageNumber == Integer.MAX_VALUE) {
            pageNumber = 0;
        }
        ArrayList<ServiceGroupMetaData> sgList = new ArrayList<ServiceGroupMetaData>();
        TreeSet<String> serviceTypes = new TreeSet<String>();
        serviceTypes.add("axis2");
        ArrayList<AxisServiceGroup> axisServiceGroupList = new ArrayList<AxisServiceGroup>();
        Iterator sgs = this.getAxisConfig().getServiceGroups();
        while (sgs.hasNext()) {
            Parameter serviceTypeParam;
            AxisServiceGroup serviceGroup = (AxisServiceGroup)sgs.next();
            if (SystemFilter.isFilteredOutService((AxisServiceGroup)serviceGroup)) continue;
            String serviceType = "axis2";
            if (serviceGroup.getServices().hasNext() && (serviceTypeParam = ((AxisService)serviceGroup.getServices().next()).getParameter("serviceType")) != null) {
                serviceType = (String)serviceTypeParam.getValue();
            }
            if (!serviceTypeFilter.equals("ALL") && !serviceTypeFilter.equals(serviceType) || serviceGroupSearchString != null && serviceGroupSearchString.trim().length() > 0 && !serviceGroup.getServiceGroupName().toLowerCase().contains(serviceGroupSearchString.toLowerCase())) continue;
            boolean isClientSide = false;
            int noOfServices = 0;
            Iterator serviceIter = serviceGroup.getServices();
            while (serviceIter.hasNext()) {
                AxisService axisService = (AxisService)serviceIter.next();
                if (axisService.isClientSide()) {
                    isClientSide = true;
                    break;
                }
                ++noOfServices;
            }
            if (noOfServices == 0 || isClientSide) continue;
            axisServiceGroupList.add(serviceGroup);
        }
        if (axisServiceGroupList.size() > 0) {
            Collections.sort(axisServiceGroupList, new Comparator<AxisServiceGroup>(){

                @Override
                public int compare(AxisServiceGroup arg0, AxisServiceGroup arg1) {
                    return arg0.getServiceGroupName().compareToIgnoreCase(arg1.getServiceGroupName());
                }
            });
        }
        ArrayList<AxisServiceGroup> axisServiceGroupsRequiredForPage = new ArrayList<AxisServiceGroup>();
        for (AxisServiceGroup anAxisServiceGroupList : axisServiceGroupList) {
            axisServiceGroupsRequiredForPage.add(anAxisServiceGroupList);
        }
        for (AxisServiceGroup serviceGroup : axisServiceGroupsRequiredForPage) {
            Parameter serviceTypeParam;
            String serviceType = "axis2";
            if (serviceGroup.getServices().hasNext() && (serviceTypeParam = ((AxisService)serviceGroup.getServices().next()).getParameter("serviceType")) != null) {
                serviceType = (String)serviceTypeParam.getValue();
                serviceTypes.add(serviceType);
            }
            ServiceGroupMetaData sgMetaData = new ServiceGroupMetaData();
            ArrayList<ServiceMetaData> services = new ArrayList<ServiceMetaData>();
            Iterator serviceIter = serviceGroup.getServices();
            while (serviceIter.hasNext()) {
                AxisService axisService = (AxisService)serviceIter.next();
                ServiceMetaData service = new ServiceMetaData();
                String serviceName = axisService.getName();
                service.setName(serviceName);
                serviceTypeParam = axisService.getParameter("serviceType");
                if (serviceTypeParam != null) {
                    serviceType = (String)serviceTypeParam.getValue();
                }
                service.setServiceType(serviceType);
                AxisConfiguration axisConfiguration = this.getAxisConfig();
                service.setWsdlURLs(Utils.getWsdlInformation(serviceName, axisConfiguration));
                service.setTryitURL(Utils.getTryitURL(serviceName, this.getConfigContext()));
                service.setActive(axisService.isActive());
                Parameter parameter = axisService.getParameter("disableTryIt");
                if (parameter != null && Boolean.TRUE.toString().equalsIgnoreCase((String)parameter.getValue())) {
                    service.setDisableTryit(true);
                }
                if ((parameter = axisService.getParameter("disableDeletion")) != null && Boolean.TRUE.toString().equalsIgnoreCase((String)parameter.getValue())) {
                    sgMetaData.setDisableDeletion(true);
                }
                services.add(service);
            }
            String sgName = serviceGroup.getServiceGroupName();
            sgMetaData.setServices(services.toArray(new ServiceMetaData[services.size()]));
            sgMetaData.setServiceGroupName(sgName);
            sgMetaData.setServiceContextPath(this.getConfigContext().getServiceContextPath());
            Parameter parameter = serviceGroup.getParameter("enableMTOM");
            if (parameter != null) {
                sgMetaData.setMtomStatus((String)parameter.getValue());
            } else {
                sgMetaData.setMtomStatus("false");
            }
            sgList.add(sgMetaData);
        }
        ServiceGroupMetaDataWrapper wrapper = new ServiceGroupMetaDataWrapper();
        wrapper.setNumberOfCorrectServiceGroups(sgList.size());
        wrapper.setNumberOfFaultyServiceGroups(this.getAxisConfig().getFaultyServices().size());
        wrapper.setServiceTypes(serviceTypes.toArray(new String[serviceTypes.size()]));
        try {
            wrapper.setNumberOfActiveServices(new ServiceAdmin(this.getAxisConfig()).getNumberOfActiveServices());
        }
        catch (Exception e) {
            throw new AxisFault("Cannot get active services from ServiceAdmin", (Throwable)e);
        }
        DataPaginator.doPaging((int)pageNumber, sgList, (Pageable)wrapper);
        return wrapper;
    }

    public ServiceGroupMetaData listServiceGroup(String serviceGroupName) throws Exception {
        Collection engagedModules;
        ServiceGroupMetaData sgmd = new ServiceGroupMetaData();
        String[] engagedModuleNames = null;
        AxisServiceGroup serviceGroup = this.getAxisConfig().getServiceGroup(serviceGroupName);
        if (serviceGroup == null) {
            String msg = "Service group " + serviceGroupName + " not found";
            log.error((Object)msg);
            throw new Exception(msg);
        }
        sgmd.setServiceGroupName(serviceGroup.getServiceGroupName());
        Parameter parameter = serviceGroup.getParameter("enableMTOM");
        if (parameter != null) {
            sgmd.setMtomStatus((String)parameter.getValue());
        }
        if ((engagedModules = serviceGroup.getEngagedModules()) != null && engagedModules.size() > 0) {
            int i = 0;
            engagedModuleNames = new String[engagedModules.size()];
            for (Object engagedModule : engagedModules) {
                AxisModule module = (AxisModule)engagedModule;
                engagedModuleNames[i++] = module.getName();
            }
        }
        sgmd.setEngagedModules(engagedModuleNames);
        ArrayList<ServiceMetaData> services = new ArrayList<ServiceMetaData>();
        Iterator servicesIter = serviceGroup.getServices();
        while (servicesIter.hasNext()) {
            AxisService service = (AxisService)servicesIter.next();
            String serviceName = service.getName();
            ServiceMetaData serviceMetaData = new ServiceMetaData();
            serviceMetaData.setName(service.getName());
            service.setName(serviceName);
            String serviceType = "axis2";
            Parameter serviceTypeParam = service.getParameter("serviceType");
            if (serviceTypeParam != null) {
                serviceType = (String)serviceTypeParam.getValue();
            }
            serviceMetaData.setServiceType(serviceType);
            AxisConfiguration axisConfiguration = this.getAxisConfig();
            serviceMetaData.setWsdlURLs(Utils.getWsdlInformation(serviceName, axisConfiguration));
            serviceMetaData.setTryitURL(Utils.getTryitURL(serviceName, this.getConfigContext()));
            serviceMetaData.setActive(service.isActive());
            parameter = service.getParameter("disableTryIt");
            if (parameter != null && Boolean.TRUE.toString().equalsIgnoreCase((String)parameter.getValue())) {
                serviceMetaData.setDisableTryit(true);
            }
            services.add(serviceMetaData);
        }
        sgmd.setServices(services.toArray(new ServiceMetaData[services.size()]));
        return sgmd;
    }

    public ServiceGroupMetaData configureServiceGroupMTOM(String flag, String serviceGroupName) throws Exception {
        Parameter parameter;
        AxisServiceGroup serviceGroup = null;
        ArrayList parameters = null;
        boolean found = false;
        serviceGroup = this.getAxisConfig().getServiceGroup(serviceGroupName);
        if (serviceGroup == null) {
            throw new AxisFault("Service group " + serviceGroupName + "cannnot be found!");
        }
        parameters = serviceGroup.getParameters();
        for (Object parameter1 : parameters) {
            Parameter parameter2 = (Parameter)parameter1;
            if (parameter2.getParameterType() != 1 || !parameter2.getValue().toString().equals("enableMTOM")) continue;
            parameter2.setValue((Object)flag.trim());
            found = true;
            break;
        }
        if (!found) {
            parameter = ParameterUtil.createParameter((String)"enableMTOM", (String)flag.trim());
            serviceGroup.addParameter(parameter);
        }
        parameter = serviceGroup.getParameter("enableMTOM");
        ServiceGroupFilePersistenceManager sfpm = this.pf.getServiceGroupFilePM();
        try {
            boolean transactionStarted = sfpm.isTransactionStarted(serviceGroupName);
            if (!transactionStarted) {
                sfpm.beginTransaction(serviceGroupName);
            }
            Iterator iterator = serviceGroup.getServices();
            while (iterator.hasNext()) {
                AxisService service = null;
                service = (AxisService)iterator.next();
                String serviceXPath = PersistenceUtils.getResourcePath((AxisService)service);
                this.persistenceManager.updateParameter(serviceGroupName, parameter, serviceXPath);
                Iterator operations = service.getOperations();
                while (operations.hasNext()) {
                    AxisOperation axisOperation = (AxisOperation)operations.next();
                    if (axisOperation.isControlOperation()) continue;
                    this.persistenceManager.updateParameter(serviceGroupName, parameter, PersistenceUtils.getResourcePath((AxisOperation)axisOperation));
                }
            }
            this.persistenceManager.updateServiceGroupParameter(serviceGroup, parameter);
            if (!transactionStarted) {
                sfpm.commitTransaction(serviceGroupName);
            }
        }
        catch (PersistenceException e) {
            sfpm.rollbackTransaction(serviceGroupName);
            log.error((Object)"Error while persisting", (Throwable)e);
            throw AxisFault.makeFault((Throwable)e);
        }
        return this.listServiceGroup(serviceGroupName);
    }

    public void updateServiceGroupParamters(String serviceGroupName, ParameterMetaData[] params) throws ServerException {
        AxisServiceGroup serviceGroup = null;
        try {
            serviceGroup = this.getAxisConfig().getServiceGroup(serviceGroupName);
            for (ParameterMetaData paramMetaData : params) {
                Parameter parameter = serviceGroup.getParameter(paramMetaData.getName());
                if (parameter == null) {
                    parameter = new Parameter(paramMetaData.getName(), null);
                }
                parameter.setParameterType(paramMetaData.getType());
                if (paramMetaData.getType() == 2) {
                    OMElement elem = AXIOMUtil.stringToOM((String)paramMetaData.getValue());
                    parameter.setParameterElement(elem);
                } else {
                    parameter.setValue((Object)paramMetaData.getValue());
                }
                this.persistenceManager.updateServiceGroupParameter(serviceGroup, parameter);
            }
        }
        catch (Exception e) {
            String msg = "Error occured while updating parameters of service group: " + serviceGroupName;
            log.error((Object)msg, (Throwable)e);
            throw new ServerException("updateServiceParameters", (Throwable)e);
        }
    }

    public void updateServiceGroupParameter(String serviceGroupName, ParameterMetaData paramMetaData) throws ServerException {
        AxisServiceGroup serviceGroup = null;
        try {
            serviceGroup = this.getAxisConfig().getServiceGroup(serviceGroupName);
            Parameter parameter = serviceGroup.getParameter(paramMetaData.getName());
            if (parameter == null) {
                parameter = new Parameter(paramMetaData.getName(), null);
            }
            parameter.setParameterType(paramMetaData.getType());
            if (paramMetaData.getType() == 2) {
                OMElement elem = AXIOMUtil.stringToOM((String)paramMetaData.getValue());
                parameter.setParameterElement(elem);
            } else {
                parameter.setValue((Object)paramMetaData.getValue());
            }
            this.persistenceManager.updateServiceGroupParameter(serviceGroup, parameter);
        }
        catch (Exception e) {
            String msg = "Error occured while updating parameters of service group: " + serviceGroupName;
            log.error((Object)msg, (Throwable)e);
            throw new ServerException("updateServiceParameters", (Throwable)e);
        }
    }

    public String[] getServiceGroupParameters(String serviceGroupName) throws ServerException {
        AxisServiceGroup serviceGroup = null;
        String[] params = new String[]{};
        try {
            serviceGroup = this.getAxisConfig().getServiceGroup(serviceGroupName);
            ArrayList parameters = serviceGroup.getParameters();
            if (parameters == null || parameters.size() == 0) {
                return params;
            }
            params = new String[parameters.size()];
            int i = 0;
            for (Parameter param : parameters) {
                if (param.getParameterElement() == null) continue;
                params[i++] = param.getParameterElement().toString();
            }
            return params;
        }
        catch (Exception e) {
            String msg = "Error occured while getting parameters of service group : " + serviceGroupName;
            log.error((Object)msg, (Throwable)e);
            throw new ServerException("getServiceParameters", (Throwable)e);
        }
    }

    public ParameterMetaData getServiceGroupParameter(String serviceGroupName, String paramName) throws ServerException {
        AxisServiceGroup serviceGroup = null;
        try {
            serviceGroup = this.getAxisConfig().getServiceGroup(serviceGroupName);
            Parameter parameter = serviceGroup.getParameter(paramName);
            if (parameter == null) {
                return null;
            }
            ParameterMetaData paramMetaData = new ParameterMetaData();
            paramMetaData.setName(parameter.getName());
            paramMetaData.setType(parameter.getParameterType());
            if (parameter.getParameterType() == 2) {
                paramMetaData.setValue(parameter.getParameterElement().toString());
            } else if (parameter.getParameterType() == 1) {
                paramMetaData.setValue((String)parameter.getValue());
            } else {
                paramMetaData.setValue(parameter.getValue().toString());
            }
            return paramMetaData;
        }
        catch (Exception e) {
            String msg = "Error occured while gettig parameter " + paramName + " of service group : " + serviceGroupName;
            log.error((Object)msg, (Throwable)e);
            throw new ServerException("getServiceParameter", (Throwable)e);
        }
    }

    public void setServiceGroupParameters(String serviceGroupId, String[] parameterElement) throws AxisFault {
        for (String aParameterElement : parameterElement) {
            this.setServiceGroupParameter(serviceGroupId, aParameterElement);
        }
    }

    public void setServiceGroupParameter(String serviceGroupId, String parameterElement) throws AxisFault {
        AxisServiceGroup axisServiceGroup = this.getAxisConfig().getServiceGroup(serviceGroupId);
        OMElement param = null;
        try {
            param = AXIOMUtil.stringToOM((String)parameterElement);
        }
        catch (XMLStreamException e) {
            String msg = "Cannot create OMElement from parameter: " + parameterElement;
            log.error((Object)msg, (Throwable)e);
            throw new AxisFault(msg, (Throwable)e);
        }
        Parameter parameter = ParameterUtil.createParameter((OMElement)param);
        if (axisServiceGroup.getParameter(parameter.getName()) != null) {
            if (!axisServiceGroup.getParameter(parameter.getName()).isLocked()) {
                axisServiceGroup.addParameter(parameter);
            }
        } else {
            axisServiceGroup.addParameter(parameter);
        }
        try {
            this.persistenceManager.updateServiceGroupParameter(axisServiceGroup, parameter);
        }
        catch (Exception e) {
            String msg = "Cannot persist service group parameter change for service group " + serviceGroupId;
            log.error((Object)msg, (Throwable)e);
            throw new AxisFault(msg, (Throwable)e);
        }
    }

    public void removeServiceGroupParameter(String serviceGroupId, String parameterName) throws AxisFault {
        AxisServiceGroup axisServiceGroup = this.getAxisConfig().getServiceGroup(serviceGroupId);
        if (axisServiceGroup == null) {
            throw new AxisFault("invalid service group name service group not found" + serviceGroupId);
        }
        axisServiceGroup.removeParameter(ParameterUtil.createParameter((String)parameterName, null));
    }

    public String dumpAAR(String serviceGroupName) throws AxisFault {
        try {
            return ServiceArchiveCreator.createArchive(this.getConfigContext(), serviceGroupName);
        }
        catch (Exception ex) {
            throw new AxisFault(ex.getMessage(), (Throwable)ex);
        }
    }
}

