/*
 * Decompiled with CFR 0.152.
 */
package org.openxri.xml;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xml.security.Init;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.Reference;
import org.apache.xml.security.signature.SignedInfo;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.transforms.Transforms;
import org.openxri.XRIParseException;
import org.openxri.saml.Assertion;
import org.openxri.util.DOM3Utils;
import org.openxri.util.DOMUtils;
import org.openxri.util.PrioritizedList;
import org.openxri.util.XMLUtils;
import org.openxri.xml.CanonicalEquivID;
import org.openxri.xml.CanonicalID;
import org.openxri.xml.EquivID;
import org.openxri.xml.Expires;
import org.openxri.xml.LocalID;
import org.openxri.xml.ProviderID;
import org.openxri.xml.Query;
import org.openxri.xml.Redirect;
import org.openxri.xml.Ref;
import org.openxri.xml.ServerStatus;
import org.openxri.xml.Service;
import org.openxri.xml.SimpleXMLElement;
import org.openxri.xml.Status;
import org.openxri.xml.XRDType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XRD
implements Cloneable,
Serializable {
    public static final String CURRENT_VERSION = "2.0";
    private static Log soLog = LogFactory.getLog((String)XRD.class.getName());
    private String xmlID;
    private String idRef;
    private String version;
    private Vector types;
    private Query query;
    private Status status;
    private ServerStatus serverStatus;
    private Expires expires;
    private ProviderID providerID;
    private Vector localIDs;
    private Vector equivIDs;
    private Vector canonicalIDs;
    private CanonicalEquivID canonicalEquivID;
    private Vector redirects;
    private PrioritizedList prioritizedRedirects;
    private Vector refs;
    private PrioritizedList prioritizedRefs;
    private Vector services;
    private PrioritizedList prioritizedServices;
    private PrioritizedList selectedServices;
    private Assertion samlAssertion;
    private Element moElem;
    private HashMap moOtherChildrenVectorsMap;

    public XRD() {
        this.reset();
    }

    public void reset() {
        this.xmlID = "";
        this.idRef = null;
        this.version = null;
        this.types = new Vector();
        this.query = null;
        this.status = null;
        this.serverStatus = null;
        this.expires = null;
        this.providerID = null;
        this.localIDs = new Vector();
        this.equivIDs = new Vector();
        this.canonicalIDs = new Vector();
        this.canonicalEquivID = null;
        this.refs = new Vector();
        this.prioritizedRefs = new PrioritizedList();
        this.redirects = new Vector();
        this.prioritizedRedirects = new PrioritizedList();
        this.services = new Vector();
        this.prioritizedServices = new PrioritizedList();
        this.selectedServices = new PrioritizedList();
        this.samlAssertion = null;
        this.moElem = null;
        this.moOtherChildrenVectorsMap = new HashMap();
    }

    public Object clone() {
        XRD x = new XRD();
        x.xmlID = this.xmlID;
        x.idRef = this.idRef;
        x.version = this.version;
        if (this.types != null) {
            x.types = (Vector)this.types.clone();
        }
        if (this.query != null) {
            x.query = new Query(this.query);
        }
        if (this.status != null) {
            x.status = new Status(this.status);
        }
        if (this.serverStatus != null) {
            x.serverStatus = new ServerStatus(this.serverStatus);
        }
        if (this.expires != null) {
            x.expires = new Expires(this.expires);
        }
        if (this.providerID != null) {
            x.providerID = new ProviderID(this.providerID);
        }
        if (this.localIDs != null) {
            x.localIDs = (Vector)this.localIDs.clone();
        }
        if (this.equivIDs != null) {
            x.equivIDs = (Vector)this.equivIDs.clone();
        }
        if (this.canonicalIDs != null) {
            x.canonicalIDs = (Vector)this.canonicalIDs.clone();
        }
        if (this.canonicalEquivID != null) {
            x.canonicalEquivID = new CanonicalEquivID(this.canonicalEquivID);
        }
        if (this.refs != null) {
            x.refs = (Vector)this.refs.clone();
        }
        if (this.prioritizedRefs != null) {
            x.prioritizedRefs = (PrioritizedList)this.prioritizedRefs.clone();
        }
        if (this.redirects != null) {
            x.redirects = (Vector)this.redirects.clone();
        }
        if (this.prioritizedRedirects != null) {
            x.prioritizedRedirects = (PrioritizedList)this.prioritizedRedirects.clone();
        }
        if (this.services != null) {
            x.services = (Vector)this.services.clone();
        }
        if (this.prioritizedServices != null) {
            x.prioritizedServices = (PrioritizedList)this.prioritizedServices.clone();
        }
        if (this.selectedServices != null) {
            x.selectedServices = (PrioritizedList)this.selectedServices.clone();
        }
        x.samlAssertion = this.samlAssertion;
        x.moElem = this.moElem;
        if (this.moOtherChildrenVectorsMap != null) {
            x.moOtherChildrenVectorsMap = (HashMap)this.moOtherChildrenVectorsMap.clone();
        }
        return x;
    }

    public XRD(Element oElem, boolean bKeepDOM) throws URISyntaxException, ParseException {
        if (bKeepDOM) {
            this.setDOM(oElem);
        } else {
            this.fromDOM(oElem);
        }
    }

    public static XRD parseXRD(String xmlStr, boolean bKeepDOM) throws URISyntaxException, ParseException {
        ByteArrayInputStream oIn = new ByteArrayInputStream(xmlStr.getBytes());
        XRD oXriD = null;
        try {
            DOMParser oDOMParser = DOMUtils.getDOMParser();
            oDOMParser.parse(new InputSource(oIn));
            Document oDOMDoc = oDOMParser.getDocument();
            Element oElement = oDOMDoc.getDocumentElement();
            oXriD = new XRD(oElement, bKeepDOM);
        }
        catch (IOException oEx) {
            oEx.printStackTrace();
            throw new XRIParseException("IOException", oEx);
        }
        catch (SAXException oEx) {
            oEx.printStackTrace();
            throw new XRIParseException("SAXException", oEx);
        }
        finally {
            try {
                ((InputStream)oIn).close();
            }
            catch (IOException e) {}
        }
        return oXriD;
    }

    public void fromDOM(Element oElem) throws URISyntaxException, ParseException {
        this.reset();
        if (oElem.hasAttributeNS("http://www.w3.org/XML/1998/namespace", "id")) {
            this.xmlID = oElem.getAttributeNS("http://www.w3.org/XML/1998/namespace", "id");
        }
        if (oElem.hasAttributeNS("http://www.w3.org/XML/1998/namespace", "idRef")) {
            this.idRef = oElem.getAttributeNS("http://www.w3.org/XML/1998/namespace", "idRef");
        }
        if (oElem.hasAttributeNS(null, "version")) {
            this.version = oElem.getAttributeNS(null, "version");
        }
        Element oChild = DOMUtils.getFirstChildElement(oElem);
        while (oChild != null) {
            SimpleXMLElement ref;
            SimpleXMLElement s;
            String sChildName = oChild.getLocalName();
            if (sChildName == null) {
                sChildName = oChild.getNodeName();
            }
            if (sChildName.equals("Type")) {
                XRDType t = new XRDType();
                t.fromXML(oChild);
                this.types.add(t);
            } else if (sChildName.equals("Query")) {
                Query q = new Query();
                q.fromXML(oChild);
                this.query = q;
            } else if (sChildName.equals("Status")) {
                s = new Status();
                s.fromXML(oChild);
                this.status = s;
            } else if (sChildName.equals("ServerStatus")) {
                s = new ServerStatus();
                s.fromXML(oChild);
                this.serverStatus = s;
            } else if (sChildName.equals("Expires")) {
                this.expires = new Expires(DOMUtils.fromXMLDateTime(oChild.getFirstChild().getNodeValue()));
            } else if (sChildName.equals("ProviderID")) {
                ProviderID p = new ProviderID();
                p.fromXML(oChild);
                this.providerID = p;
            } else if (sChildName.equals("LocalID")) {
                this.addLocalID(new LocalID(oChild));
            } else if (sChildName.equals("EquivID")) {
                this.equivIDs.add(new EquivID(oChild));
            } else if (sChildName.equals("CanonicalID")) {
                this.canonicalIDs.add(new CanonicalID(oChild));
            } else if (sChildName.equals("CanonicalEquivID")) {
                this.canonicalEquivID = new CanonicalEquivID();
                this.canonicalEquivID.fromXML(oChild);
            } else if (sChildName.equals("Redirect")) {
                ref = new Redirect(oChild);
                this.addRedirect((Redirect)ref);
            } else if (sChildName.equals("Ref")) {
                ref = new Ref(oChild);
                this.addRef((Ref)ref);
            } else if (sChildName.equals("Service")) {
                this.addService(new Service(oChild));
            } else if (oChild.getNamespaceURI() != null && oChild.getNamespaceURI().equals("urn:oasis:names:tc:SAML:2.0:assertion") && oChild.getLocalName() != null && oChild.getLocalName().equals("Assertion")) {
                this.samlAssertion = new Assertion(oChild);
            } else {
                Vector<Node> oVector = (Vector<Node>)this.moOtherChildrenVectorsMap.get(sChildName);
                if (oVector == null) {
                    oVector = new Vector<Node>();
                    this.moOtherChildrenVectorsMap.put(sChildName, oVector);
                }
                oVector.add(oChild.cloneNode(true));
            }
            oChild = DOMUtils.getNextSiblingElement(oChild);
        }
    }

    public String serializeDOM(boolean bIndent, boolean bOmitXMLDeclaration) {
        this.getDOM();
        return DOMUtils.toString(this.moElem, bIndent, bOmitXMLDeclaration);
    }

    public String toString() {
        DocumentImpl doc = new DocumentImpl();
        Element elm = this.toDOM((Document)doc);
        doc.appendChild(elm);
        return DOMUtils.toString((Document)doc);
    }

    public String toResultString() {
        DocumentImpl doc = new DocumentImpl();
        Element elm = this.toDOM((Document)doc, true);
        doc.appendChild(elm);
        return DOMUtils.toString((Document)doc);
    }

    public Element getDOM() {
        if (this.moElem == null) {
            this.moElem = this.toDOM((Document)new DocumentImpl());
            this.moElem.getOwnerDocument().appendChild(this.moElem);
        }
        return this.moElem;
    }

    public void setDOM(Element oElem) throws URISyntaxException, ParseException {
        this.fromDOM(oElem);
        this.moElem = oElem;
    }

    public void clearDOM() {
        this.moElem = null;
    }

    public Element toDOM(Document doc, boolean wantFiltered) {
        Element oLocal;
        int i;
        if (doc == null) {
            return null;
        }
        Element elem = doc.createElementNS("xri://$xrd*($v*2.0)", "XRD");
        if (!this.xmlID.equals("")) {
            elem.setAttributeNS("http://www.w3.org/XML/1998/namespace", "id", this.xmlID);
        }
        if (this.idRef != null) {
            elem.setAttributeNS("http://www.w3.org/XML/1998/namespace", "idRef", this.idRef);
        }
        if (this.version != null) {
            elem.setAttributeNS(null, "version", this.version);
        }
        for (i = 0; i < this.getNumTypes(); ++i) {
            Element t = this.getTypeAt(i).toXML(doc);
            elem.appendChild(t);
        }
        if (this.query != null) {
            Element oResolved = this.query.toXML(doc);
            elem.appendChild(oResolved);
        }
        if (this.status != null) {
            Element oStatus = this.status.toXML(doc);
            elem.appendChild(oStatus);
        }
        if (this.serverStatus != null) {
            Element oServerStatus = this.serverStatus.toXML(doc);
            elem.appendChild(oServerStatus);
        }
        if (this.expires != null) {
            Element oExpires = this.expires.toXML(doc);
            elem.appendChild(oExpires);
        }
        if (this.providerID != null) {
            Element oProviderid = this.providerID.toXML(doc);
            elem.appendChild(oProviderid);
        }
        for (i = 0; i < this.getNumLocalIDs(); ++i) {
            oLocal = this.getLocalIDAt(i).toXML(doc);
            elem.appendChild(oLocal);
        }
        for (i = 0; i < this.getNumEquivIDs(); ++i) {
            Element equivID = this.getEquivIDAt(i).toXML(doc);
            elem.appendChild(equivID);
        }
        for (i = 0; i < this.getNumCanonicalids(); ++i) {
            oLocal = this.getCanonicalidAt(i).toXML(doc);
            elem.appendChild(oLocal);
        }
        if (this.canonicalEquivID != null) {
            elem.appendChild(this.canonicalEquivID.toXML(doc));
        }
        if (wantFiltered) {
            ArrayList redirects = this.getPrioritizedRedirects();
            for (int i2 = 0; i2 < redirects.size(); ++i2) {
                Redirect r = (Redirect)redirects.get(i2);
                Element e = r.toXML(doc);
                elem.appendChild(e);
            }
            ArrayList refs = this.getPrioritizedRefs();
            for (int i3 = 0; i3 < refs.size(); ++i3) {
                Ref r = (Ref)refs.get(i3);
                Element e = r.toXML(doc);
                elem.appendChild(e);
            }
            ArrayList svcs = this.getSelectedServices().getList();
            for (int i4 = 0; i4 < svcs.size(); ++i4) {
                Service s = (Service)svcs.get(i4);
                Element e = (Element)s.toDOM(doc, true);
                elem.appendChild(e);
            }
        } else {
            Element e;
            for (i = 0; i < this.getNumRedirects(); ++i) {
                e = this.getRedirectAt(i).toXML(doc);
                elem.appendChild(e);
            }
            for (i = 0; i < this.getNumRefs(); ++i) {
                e = this.getRefAt(i).toXML(doc);
                elem.appendChild(e);
            }
            for (i = 0; i < this.getNumServices(); ++i) {
                e = (Element)this.getServiceAt(i).toDOM(doc);
                elem.appendChild(e);
            }
            if (this.samlAssertion != null) {
                Element oSAMLElement = this.samlAssertion.toDOM(doc);
                elem.appendChild(oSAMLElement);
            }
            for (String sTag : this.moOtherChildrenVectorsMap.keySet()) {
                Vector oValues = (Vector)this.moOtherChildrenVectorsMap.get(sTag);
                for (int i5 = 0; i5 < oValues.size(); ++i5) {
                    Element oCustom = doc.createElement(sTag);
                    Node oChild = (Node)oValues.get(i5);
                    Node oChild2 = doc.importNode(oChild, true);
                    elem.appendChild(oChild2);
                }
            }
        }
        return elem;
    }

    public Element toDOM(Document doc) {
        return this.toDOM(doc, false);
    }

    public boolean setOtherTagValues(String sTag, String sTagValue) {
        String xmlStr = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + sTagValue;
        boolean returnValue = false;
        try {
            ByteArrayInputStream oIn = new ByteArrayInputStream(xmlStr.getBytes());
            DOMParser oDOMParser = DOMUtils.getDOMParser();
            oDOMParser.parse(new InputSource(oIn));
            Document oDOMDoc = oDOMParser.getDocument();
            Element oElement = oDOMDoc.getDocumentElement();
            Vector<Node> oVector = (Vector<Node>)this.moOtherChildrenVectorsMap.get(sTag);
            if (oVector == null) {
                oVector = new Vector<Node>();
                this.moOtherChildrenVectorsMap.put(sTag, oVector);
            }
            oVector.add(oElement.cloneNode(true));
            returnValue = true;
        }
        catch (Exception exp) {
            exp.printStackTrace();
            returnValue = false;
        }
        return returnValue;
    }

    public Vector getOtherTagValues(String sTag) {
        return (Vector)this.moOtherChildrenVectorsMap.get(sTag);
    }

    public void setExtension(String extension) throws URISyntaxException, ParseException {
        String xmlStr = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><xrd xmlns=\"xri://$xrd*($v*2.0)\">" + extension + "</xrd>";
        XRD tempXrd = XRD.parseXRD(xmlStr, false);
        this.moOtherChildrenVectorsMap = tempXrd.moOtherChildrenVectorsMap;
    }

    public String getExtension() {
        StringBuffer extension = new StringBuffer();
        for (String sTag : this.moOtherChildrenVectorsMap.keySet()) {
            Vector oValues = (Vector)this.moOtherChildrenVectorsMap.get(sTag);
            for (int i = 0; i < oValues.size(); ++i) {
                Node oChild = (Node)oValues.get(i);
                extension.append(DOMUtils.toString((Element)oChild, true, true));
            }
        }
        return extension.toString();
    }

    public String getXmlID() {
        return this.xmlID;
    }

    public void setXmlID(String sVal) {
        this.xmlID = sVal;
    }

    public void genXmlID() {
        this.xmlID = XMLUtils.genXmlID();
    }

    public String getProviderID() {
        return this.providerID != null ? this.providerID.getValue() : null;
    }

    public void setProviderID(String sVal) {
        this.providerID = new ProviderID(sVal);
    }

    public String getQuery() {
        return this.query != null ? this.query.getValue() : null;
    }

    public void setQuery(String sVal) {
        if (this.query != null) {
            this.query.setValue(sVal);
        } else {
            this.query = new Query(sVal);
        }
    }

    public Date getExpires() {
        return this.expires != null ? this.expires.getDate() : null;
    }

    public void setExpires(Date d) {
        if (this.expires != null) {
            this.expires.setDate(d);
        } else {
            this.expires = new Expires(d);
        }
    }

    public int getNumLocalIDs() {
        return this.localIDs.size();
    }

    public LocalID getLocalIDAt(int n) {
        return (LocalID)this.localIDs.get(n);
    }

    public void addLocalID(LocalID localId) {
        this.localIDs.add(localId);
    }

    public int getNumEquivIDs() {
        return this.equivIDs.size();
    }

    public EquivID getEquivIDAt(int n) {
        return (EquivID)this.equivIDs.get(n);
    }

    public void addEquivID(EquivID equivID) {
        this.equivIDs.add(equivID);
    }

    public int getNumCanonicalids() {
        return this.canonicalIDs.size();
    }

    public CanonicalID getCanonicalidAt(int n) {
        return (CanonicalID)this.canonicalIDs.get(n);
    }

    public void addCanonicalID(CanonicalID canonicalId) {
        this.canonicalIDs.add(canonicalId);
    }

    public void setCanonicalID(CanonicalID cid) {
        this.canonicalIDs.clear();
        if (cid != null) {
            this.canonicalIDs.add(cid);
        }
    }

    public CanonicalID getCanonicalID() {
        if (this.canonicalIDs.size() > 0) {
            return (CanonicalID)this.canonicalIDs.get(0);
        }
        return null;
    }

    public void setCanonicalEquivID(CanonicalEquivID ceid) {
        this.canonicalEquivID = ceid;
    }

    public CanonicalEquivID getCanonicalEquivID() {
        return this.canonicalEquivID;
    }

    public Vector getRefs() {
        return (Vector)this.refs.clone();
    }

    public Ref getRefAt(int n) {
        return (Ref)this.refs.get(n);
    }

    public int getNumRefs() {
        return this.refs.size();
    }

    public void addRef(Ref ref) {
        Integer priority = ref.getPriority();
        this.refs.add(ref);
        this.prioritizedRefs.addObject(priority == null ? "null" : priority.toString(), ref);
    }

    public ArrayList getPrioritizedRefs() {
        return this.prioritizedRefs.getList();
    }

    public Vector getRedirects() {
        return (Vector)this.redirects.clone();
    }

    public Redirect getRedirectAt(int n) {
        return (Redirect)this.redirects.get(n);
    }

    public int getNumRedirects() {
        return this.redirects.size();
    }

    public void addRedirect(Redirect redirect) {
        Integer priority = redirect.getPriority();
        this.redirects.add(redirect);
        this.prioritizedRedirects.addObject(priority == null ? "null" : priority.toString(), redirect);
    }

    public ArrayList getPrioritizedRedirects() {
        return this.prioritizedRedirects.getList();
    }

    public int getNumServices() {
        return this.services.size();
    }

    public Service getServiceAt(int n) {
        return (Service)this.services.get(n);
    }

    public ArrayList getPrioritizedServices() {
        return this.prioritizedServices.getList();
    }

    public void addService(Service service) {
        this.services.add(service);
        Integer priority = service.getPriority();
        this.prioritizedServices.addObject(priority == null ? "null" : priority.toString(), service);
    }

    public int getNumTypes() {
        return this.types.size();
    }

    public XRDType getTypeAt(int n) {
        return (XRDType)this.types.get(n);
    }

    public Assertion getSAMLAssertion() {
        return this.samlAssertion;
    }

    public void setSAMLAssertion(Assertion oSAMLAssertion) {
        this.samlAssertion = oSAMLAssertion;
    }

    public void sign(PrivateKey oKey) throws XMLSecurityException {
        this.getDOM();
        this.moElem.getOwnerDocument().normalizeDocument();
        Element oAssertionElem = DOMUtils.getFirstChildElement(this.moElem, "urn:oasis:names:tc:SAML:2.0:assertion", "Assertion");
        if (oAssertionElem == null) {
            throw new XMLSecurityException("Cannot create signature. No SAML Assertion attached to descriptor.");
        }
        Element oSubjectElem = DOMUtils.getFirstChildElement(oAssertionElem, "urn:oasis:names:tc:SAML:2.0:assertion", "Subject");
        if (oSubjectElem == null) {
            throw new XMLSecurityException("Cannot create signature. SAML Assertion has no subject.");
        }
        String sID = this.moElem.getAttributeNS("http://www.w3.org/XML/1998/namespace", "id");
        if (sID == null || sID.equals("")) {
            throw new XMLSecurityException("Cannot create signature. ID is missing for " + this.moElem.getLocalName());
        }
        DOM3Utils.bestEffortSetIDAttr(this.moElem, "http://www.w3.org/XML/1998/namespace", "id");
        Document oDoc = this.moElem.getOwnerDocument();
        XMLSignature oSig = new XMLSignature(oDoc, null, "http://www.w3.org/2000/09/xmldsig#rsa-sha1", "http://www.w3.org/2001/10/xml-exc-c14n#");
        String[] oTransforms = new String[]{"http://www.w3.org/2000/09/xmldsig#enveloped-signature", "http://www.w3.org/2001/10/xml-exc-c14n#"};
        Transforms oTrans = new Transforms(oSig.getDocument());
        for (int i = 0; i < oTransforms.length; ++i) {
            oTrans.addTransform(oTransforms[i]);
        }
        oSig.addDocument("#" + sID, oTrans);
        oSig.sign((Key)oKey);
        Element oSigElem = oSig.getElement();
        oAssertionElem.insertBefore(oSigElem, oSubjectElem);
    }

    public void verifySignature(PublicKey oPubKey) throws XMLSecurityException {
        if (this.moElem == null) {
            throw new XMLSecurityException("Cannot verify the signature. No DOM stored for XRD");
        }
        String sIDAttrNS = "http://www.w3.org/XML/1998/namespace";
        String sIDAttr = "id";
        String sID = this.moElem.getAttributeNS(sIDAttrNS, sIDAttr);
        if (sID == null || sID.equals("")) {
            throw new XMLSecurityException("Cannot verify the signature. ID is missing for " + this.moElem.getLocalName());
        }
        String sRef = "#" + sID;
        DOM3Utils.bestEffortSetIDAttr(this.moElem, sIDAttrNS, sIDAttr);
        Element oAssertionElem = DOMUtils.getFirstChildElement(this.moElem, "urn:oasis:names:tc:SAML:2.0:assertion", "Assertion");
        if (oAssertionElem == null) {
            throw new XMLSecurityException("Cannot verify the signature. No Assertion in XRD");
        }
        Element oSigElem = DOMUtils.getFirstChildElement(oAssertionElem, "http://www.w3.org/2000/09/xmldsig#", "Signature");
        if (oSigElem == null) {
            throw new XMLSecurityException("Cannot verify the signature. No signature in Assertion");
        }
        XMLSignature oSig = null;
        oSig = new XMLSignature(oSigElem, null);
        Object sFailedRef = null;
        SignedInfo oSignedInfo = oSig.getSignedInfo();
        if (oSignedInfo.getLength() != 1) {
            throw new XMLSecurityException("Cannot verify the signature. Expected 1 reference, got " + oSignedInfo.getLength());
        }
        Reference oRef = oSignedInfo.item(0);
        String sURI = oRef.getURI();
        if (!sRef.equals(sURI)) {
            throw new XMLSecurityException("Cannot verify the signature. Reference URI did not match ID");
        }
        boolean bEnvelopedFound = false;
        Transforms oTransforms = oRef.getTransforms();
        for (int i = 0; i < oTransforms.getLength(); ++i) {
            String sTransform = oTransforms.item(i).getURI();
            if ("http://www.w3.org/2000/09/xmldsig#enveloped-signature".equals(sTransform)) {
                bEnvelopedFound = true;
                continue;
            }
            if ("http://www.w3.org/2001/10/xml-exc-c14n#".equals(sTransform)) continue;
            throw new XMLSecurityException("Unexpected transform in signature");
        }
        if (!bEnvelopedFound) {
            throw new XMLSecurityException("Could not find expected http://www.w3.org/2000/09/xmldsig#enveloped-signature transform in signature");
        }
        if (!oSig.checkSignatureValue((Key)oPubKey)) {
            throw new RuntimeException("Signature failed to verify.");
        }
    }

    public boolean isValid() {
        return this.expires == null || this.expires.getDate() == null || !this.expires.getDate().before(new Date());
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public Status getStatus() {
        return this.status;
    }

    public String getServerStatusCode() {
        if (this.serverStatus == null) {
            return null;
        }
        return this.serverStatus.getCode();
    }

    public void setServerStatus(ServerStatus serverStatus) {
        this.serverStatus = serverStatus;
    }

    public ServerStatus getServerStatus() {
        return this.serverStatus;
    }

    public String getStatusCode() {
        if (this.status == null) {
            return null;
        }
        return this.status.getCode();
    }

    public Vector getServices() {
        return (Vector)this.services.clone();
    }

    public void setServices(Collection col) {
        this.services = new Vector();
        this.prioritizedServices = new PrioritizedList();
        for (Service s : col) {
            this.addService(s);
        }
    }

    public void setSelectedServices(Collection svcs) {
        this.selectedServices = new PrioritizedList();
        for (Service s : svcs) {
            Integer priority = s.getPriority();
            String priStr = priority == null ? "null" : priority.toString();
            this.selectedServices.addObject(priStr, s);
        }
    }

    public void setEquivIDs(Collection col) {
        this.equivIDs = new Vector();
        for (EquivID e : col) {
            this.addEquivID(e);
        }
    }

    public void setRefs(Collection col) {
        this.refs = new Vector();
        for (Ref r : col) {
            this.addRef(r);
        }
    }

    public void setRedirects(Collection col) {
        this.redirects = new Vector();
        for (Redirect r : col) {
            this.addRedirect(r);
        }
    }

    public PrioritizedList getSelectedServices() {
        return this.selectedServices;
    }

    static {
        try {
            Init.init();
        }
        catch (Exception oEx) {
            soLog.warn((Object)"Failed to initialize XML Sec library", (Throwable)oEx);
        }
    }
}

