/*
 * Decompiled with CFR 0.152.
 */
package org.openxri.xml;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.openxri.xml.Ref;
import org.openxri.xml.SEPMediaType;
import org.openxri.xml.SEPPath;
import org.openxri.xml.SEPType;
import org.openxri.xml.SEPUri;
import org.openxri.xml.Service;

public class XDIService
extends Service {
    public static final String SERVICE_TYPE = "xri://$xdi!($v!1)";
    public static final String SERVICE_PATH = "($context)!($xdi)!($v!1) ";

    public XDIService(URI[] uris, String providerID) {
        if (providerID != null) {
            this.setProviderId(providerID);
        }
        this.addType(new SEPType(SERVICE_TYPE, null, Boolean.TRUE));
        this.addPath(new SEPPath(SERVICE_PATH, null, Boolean.TRUE));
        this.addMediaType(new SEPMediaType(null, "default", null));
        for (int i = 0; i < uris.length; ++i) {
            URI uri = uris[i];
            try {
                this.addURI(new SEPUri(uri.toString(), null, "none"));
                continue;
            }
            catch (URISyntaxException ex) {
                // empty catch block
            }
        }
    }

    public XDIService(URI uri, String providerID) {
        this(new URI[]{uri}, providerID);
    }

    public XDIService(URI[] uris) {
        this(uris, null);
    }

    public XDIService(URI uri) {
        this(new URI[]{uri}, null);
    }

    public XDIService(Ref[] xdiRefs, String providerID) {
        if (providerID != null) {
            this.setProviderId(providerID);
        }
        this.addType(new SEPType(SERVICE_TYPE, null, Boolean.TRUE));
        this.addPath(new SEPPath(SERVICE_PATH, null, Boolean.TRUE));
        this.addMediaType(new SEPMediaType(null, "default", null));
        for (int i = 0; i < xdiRefs.length; ++i) {
            Ref xdiRef = xdiRefs[i];
            this.addRef(xdiRef);
        }
    }

    public XDIService(Ref xdiRef, String providerID) {
        this(new Ref[]{xdiRef}, providerID);
    }

    public XDIService(Ref[] xdiRefs) {
        this(xdiRefs, null);
    }

    public XDIService(Ref xdiRef) {
        this(new Ref[]{xdiRef}, null);
    }

    public static boolean isInstance(Service service) {
        if (service instanceof XDIService) {
            return true;
        }
        List serviceTypes = service.getTypes();
        for (int i = 0; i < serviceTypes.size(); ++i) {
            SEPType serviceType = (SEPType)serviceTypes.get(i);
            if (!SERVICE_TYPE.equals(serviceType.getValue())) continue;
            return true;
        }
        return false;
    }
}

