/*
 * Decompiled with CFR 0.152.
 */
package org.openxri.resolve;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.KeyInfo;
import org.openxri.AuthorityPath;
import org.openxri.IRIAuthority;
import org.openxri.XRI;
import org.openxri.XRIAbsolutePath;
import org.openxri.XRIAuthority;
import org.openxri.XRIParseException;
import org.openxri.XRIPath;
import org.openxri.XRIQuery;
import org.openxri.XRISegment;
import org.openxri.XRISubSegment;
import org.openxri.http.BaseFetcher;
import org.openxri.resolve.ResolverFlags;
import org.openxri.resolve.ResolverState;
import org.openxri.resolve.SEPSelector;
import org.openxri.resolve.TrustType;
import org.openxri.resolve.exception.PartialResolutionException;
import org.openxri.resolve.exception.XRIResolutionException;
import org.openxri.saml.Assertion;
import org.openxri.saml.Attribute;
import org.openxri.saml.AttributeStatement;
import org.openxri.saml.NameID;
import org.openxri.saml.Subject;
import org.openxri.util.DOMUtils;
import org.openxri.util.IO;
import org.openxri.util.PrioritizedList;
import org.openxri.xml.CanonicalEquivID;
import org.openxri.xml.CanonicalID;
import org.openxri.xml.EquivID;
import org.openxri.xml.LocalID;
import org.openxri.xml.Redirect;
import org.openxri.xml.Ref;
import org.openxri.xml.SEPUri;
import org.openxri.xml.ServerStatus;
import org.openxri.xml.Service;
import org.openxri.xml.SimpleXMLElement;
import org.openxri.xml.Status;
import org.openxri.xml.XRD;
import org.openxri.xml.XRDS;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Resolver
extends BaseFetcher {
    private static Log log = LogFactory.getLog((String)Resolver.class.getName());
    protected HashMap root = new HashMap();
    protected int maxFollowRefs = -1;
    protected int maxRequests = -1;
    protected URI proxyURI = null;
    private int maxTotalBytes = -1;
    private int maxBytesPerRequest = -1;
    private HashMap needNoHttps = new HashMap();

    public Resolver() {
    }

    public XRDS resolveAuthToXRDS(XRI qxri, ResolverFlags flags, ResolverState state) throws PartialResolutionException {
        log.trace((Object)("resolveAuthToXRDS(s'" + qxri + "', flags: " + flags + ")"));
        if (this.proxyURI != null) {
            return this.resolveViaProxy(qxri, null, null, false, flags, state);
        }
        XRDS xrds = this.resolveAuthority(qxri, flags, state);
        if (flags.isUric()) {
            this.constructURIinXRD(xrds.getFinalXRD(), qxri);
        }
        return xrds;
    }

    public XRD resolveAuthToXRD(XRI qxri, ResolverFlags flags, ResolverState state) throws PartialResolutionException {
        log.trace((Object)("resolveAuthToXRD(s'" + qxri + "', flags: " + flags + ")"));
        if (this.proxyURI != null) {
            XRDS xrds = this.resolveViaProxy(qxri, null, null, false, flags, state);
            return xrds.getFinalXRD();
        }
        XRDS xrds = this.resolveAuthority(qxri, flags, state);
        XRD finalXRD = xrds.getFinalXRD();
        if (flags.isUric()) {
            this.constructURIinXRD(finalXRD, qxri);
        }
        return finalXRD;
    }

    public XRDS resolveSEPToXRDS(XRI qxri, String sepType, String sepMediaType, ResolverFlags flags, ResolverState state) throws PartialResolutionException {
        log.trace((Object)("resolveSEPToXRDS('" + qxri + "', sepType=" + sepType + ", sepMediaType=" + sepMediaType + ", flags:" + flags + ")"));
        if (this.proxyURI != null) {
            return this.resolveViaProxy(qxri, sepType, sepMediaType, true, flags, state);
        }
        XRDS xrds = this.resolveAuthority(qxri, flags, state);
        XRD finalXRD = xrds.getFinalXRD();
        this.selectServiceFromXRD(xrds, finalXRD, qxri, sepType, sepMediaType, flags, state);
        if (flags.isUric()) {
            this.constructURIinXRD(xrds.getFinalXRD(), qxri);
        }
        return xrds;
    }

    public XRD resolveSEPToXRD(XRI qxri, String sepType, String sepMediaType, ResolverFlags flags, ResolverState state) throws PartialResolutionException {
        log.trace((Object)("resolveSEPToXRD('" + qxri + "', sepType=" + sepType + ", sepMediaType=" + sepMediaType + ", flags: " + flags + ")"));
        XRDS xrds = this.resolveSEPToXRDS(qxri, sepType, sepMediaType, flags, state);
        return xrds.getFinalXRD();
    }

    public ArrayList resolveSEPToURIList(XRI qxri, String sepType, String sepMediaType, ResolverFlags flags, ResolverState state) throws PartialResolutionException {
        log.trace((Object)("resolveSEPToURIList('" + qxri + "', sepType=" + sepType + ", sepMediaType=" + sepMediaType + ", flags: " + flags + ")"));
        flags.setUric(false);
        XRD xrd = this.resolveSEPToXRD(qxri, sepType, sepMediaType, flags, state);
        if (xrd == null) {
            return new ArrayList();
        }
        if (xrd.getSelectedServices().getList().size() < 1) {
            log.error((Object)"SEP Selection succeeded but no Service found!?");
            return new ArrayList();
        }
        Service topService = (Service)xrd.getSelectedServices().getList().get(0);
        ArrayList<String> urisOut = new ArrayList<String>();
        ArrayList uris = topService.getPrioritizedURIs();
        for (int i = 0; uris != null && i < uris.size(); ++i) {
            SEPUri uri = (SEPUri)uris.get(i);
            String append = uri.getAppend();
            urisOut.add(this.constructURI(uri.getURI(), append, qxri));
        }
        return urisOut;
    }

    public String resolveSEPToTextURIList(XRI qxri, String sepType, String sepMediaType, ResolverFlags flags, ResolverState state) throws PartialResolutionException {
        log.trace((Object)("resolveSEPToTextURIList('" + qxri + ", sepType=" + sepType + ", sepMediaType=" + sepMediaType + ", flags: " + flags + ")"));
        ArrayList uris = this.resolveSEPToURIList(qxri, sepType, sepMediaType, flags, state);
        StringBuffer buf = new StringBuffer();
        for (int i = 0; uris != null && i < uris.size(); ++i) {
            buf.append(uris.get(i).toString());
            buf.append("\n");
        }
        return buf.toString();
    }

    public XRDS resolveAuthToXRDS(String qxri, TrustType trustType, boolean followRefs) throws PartialResolutionException {
        return this.resolveAuthToXRDS(qxri, trustType, followRefs, new ResolverState());
    }

    public XRDS resolveAuthToXRDS(String qxri, TrustType trustType, boolean followRefs, ResolverState state) throws PartialResolutionException {
        XRI xri2 = this.parseAbsoluteQXRIOrError(qxri);
        return this.resolveAuthToXRDS(xri2, trustType, followRefs, state);
    }

    public XRDS resolveAuthToXRDS(XRI qxri, TrustType trustType, boolean followRefs) throws PartialResolutionException {
        return this.resolveAuthToXRDS(qxri, trustType, followRefs, new ResolverState());
    }

    public XRDS resolveAuthToXRDS(XRI qxri, TrustType trustType, boolean followRefs, ResolverState state) throws PartialResolutionException {
        ResolverFlags f = new ResolverFlags(trustType, followRefs);
        return this.resolveAuthToXRDS(qxri, f, state);
    }

    public XRD resolveAuthToXRD(String qxri, TrustType trustType, boolean followRefs) throws PartialResolutionException {
        return this.resolveAuthToXRD(qxri, trustType, followRefs, new ResolverState());
    }

    public XRD resolveAuthToXRD(String qxri, TrustType trustType, boolean followRefs, ResolverState state) throws PartialResolutionException {
        log.trace((Object)("resolveAuthToXRD(s'" + qxri + "', trustType=" + trustType + ", followRefs=" + followRefs + ")"));
        XRI xri2 = this.parseAbsoluteQXRIOrError(qxri);
        return this.resolveAuthToXRD(xri2, trustType, followRefs, state);
    }

    public XRD resolveAuthToXRD(XRI qxri, TrustType trustType, boolean followRefs) throws PartialResolutionException {
        return this.resolveAuthToXRD(qxri, trustType, followRefs, new ResolverState());
    }

    public XRD resolveAuthToXRD(XRI qxri, TrustType trustType, boolean followRefs, ResolverState state) throws PartialResolutionException {
        log.trace((Object)("resolveAuthToXRD('" + qxri + "', trustType=" + trustType + ", followRefs=" + followRefs + ")"));
        ResolverFlags f = new ResolverFlags(trustType, followRefs);
        return this.resolveAuthToXRD(qxri, f, state);
    }

    public XRDS resolveSEPToXRDS(String qxri, TrustType trustType, String sepType, String sepMediaType, boolean followRefs) throws PartialResolutionException {
        return this.resolveSEPToXRDS(qxri, trustType, sepType, sepMediaType, followRefs, new ResolverState());
    }

    public XRDS resolveSEPToXRDS(String qxri, TrustType trustType, String sepType, String sepMediaType, boolean followRefs, ResolverState state) throws PartialResolutionException {
        log.trace((Object)("resolveSEPToXRDS(s'" + qxri + "', trustType=" + trustType + ", sepType=" + sepType + ", sepMediaType=" + sepMediaType + ", followRefs=" + followRefs + ")"));
        XRI xri2 = this.parseAbsoluteQXRIOrError(qxri);
        return this.resolveSEPToXRDS(xri2, trustType, sepType, sepMediaType, followRefs, state);
    }

    public XRDS resolveSEPToXRDS(XRI qxri, TrustType trustType, String sepType, String sepMediaType, boolean followRefs) throws PartialResolutionException {
        return this.resolveSEPToXRDS(qxri, trustType, sepType, sepMediaType, followRefs, new ResolverState());
    }

    public XRDS resolveSEPToXRDS(XRI qxri, TrustType trustType, String sepType, String sepMediaType, boolean followRefs, ResolverState state) throws PartialResolutionException {
        log.trace((Object)("resolveSEPToXRDS('" + qxri + "', trustType=" + trustType + ", sepType=" + sepType + ", sepMediaType=" + sepMediaType + ", followRefs=" + followRefs + ")"));
        ResolverFlags f = new ResolverFlags(trustType, followRefs);
        return this.resolveSEPToXRDS(qxri, sepType, sepMediaType, f, state);
    }

    public XRD resolveSEPToXRD(String qxri, TrustType trustType, String sepType, String sepMediaType, boolean followRefs) throws PartialResolutionException {
        return this.resolveSEPToXRD(qxri, trustType, sepType, sepMediaType, followRefs, new ResolverState());
    }

    public XRD resolveSEPToXRD(String qxri, TrustType trustType, String sepType, String sepMediaType, boolean followRefs, ResolverState state) throws PartialResolutionException {
        log.trace((Object)("resolveSEPToXRD(s'" + qxri + "', trustType=" + trustType + ", sepType=" + sepType + ", sepMediaType=" + sepMediaType + ", followRefs=" + followRefs + ")"));
        XRI xri2 = this.parseAbsoluteQXRIOrError(qxri);
        return this.resolveSEPToXRD(xri2, trustType, sepType, sepMediaType, followRefs, state);
    }

    public XRD resolveSEPToXRD(XRI qxri, TrustType trustType, String sepType, String sepMediaType, boolean followRefs) throws PartialResolutionException {
        return this.resolveSEPToXRD(qxri, trustType, sepType, sepMediaType, followRefs, new ResolverState());
    }

    public XRD resolveSEPToXRD(XRI qxri, TrustType trustType, String sepType, String sepMediaType, boolean followRefs, ResolverState state) throws PartialResolutionException {
        log.trace((Object)("resolveSEPToXRD('" + qxri + "', trustType=" + trustType + ", sepType=" + sepType + ", sepMediaType=" + sepMediaType + ", followRefs=" + followRefs + ")"));
        XRDS xrds = this.resolveSEPToXRDS(qxri, trustType, sepType, sepMediaType, followRefs, state);
        return xrds.getFinalXRD();
    }

    public ArrayList resolveSEPToURIList(String qxri, TrustType trustType, String sepType, String sepMediaType, boolean followRefs) throws PartialResolutionException {
        return this.resolveSEPToURIList(qxri, trustType, sepType, sepMediaType, followRefs, new ResolverState());
    }

    public ArrayList resolveSEPToURIList(String qxri, TrustType trustType, String sepType, String sepMediaType, boolean followRefs, ResolverState state) throws PartialResolutionException {
        log.trace((Object)("resolveSEPToURIList(s'" + qxri + "', trustType=" + trustType + ", sepType=" + sepType + ", sepMediaType=" + sepMediaType + ", followRefs=" + followRefs + ")"));
        XRI xri2 = this.parseAbsoluteQXRIOrError(qxri);
        return this.resolveSEPToURIList(xri2, trustType, sepType, sepMediaType, followRefs, state);
    }

    public ArrayList resolveSEPToURIList(XRI qxri, TrustType trustType, String sepType, String sepMediaType, boolean followRefs) throws PartialResolutionException {
        return this.resolveSEPToURIList(qxri, trustType, sepType, sepMediaType, followRefs, new ResolverState());
    }

    public ArrayList resolveSEPToURIList(XRI qxri, TrustType trustType, String sepType, String sepMediaType, boolean followRefs, ResolverState state) throws PartialResolutionException {
        ResolverFlags f = new ResolverFlags(trustType, followRefs);
        return this.resolveSEPToURIList(qxri, sepType, sepMediaType, f, state);
    }

    public String resolveSEPToTextURIList(String qxri, TrustType trustType, String sepType, String sepMediaType, boolean followRefs) throws PartialResolutionException {
        return this.resolveSEPToTextURIList(qxri, trustType, sepType, sepMediaType, followRefs, new ResolverState());
    }

    public String resolveSEPToTextURIList(String qxri, TrustType trustType, String sepType, String sepMediaType, boolean followRefs, ResolverState state) throws PartialResolutionException {
        ResolverFlags f = new ResolverFlags(trustType, followRefs);
        XRI xri2 = this.parseAbsoluteQXRIOrError(qxri);
        return this.resolveSEPToTextURIList(xri2, sepType, sepMediaType, f, state);
    }

    public XRDS resolveAuthority(XRI qxri, ResolverFlags flags, ResolverState state) throws PartialResolutionException {
        log.trace((Object)("resolveAuthority(s'" + qxri + "', flags: " + flags + ")"));
        XRDS xrdsOut = new XRDS();
        xrdsOut.setRef("xri://" + qxri.getAuthorityPath().toString());
        AuthorityPath ap = qxri.getAuthorityPath();
        try {
            XRDS newXRDS;
            if (ap instanceof XRIAuthority) {
                newXRDS = this.resolveXRIAuth(qxri, (XRIAuthority)ap, flags, state);
            } else if (ap instanceof IRIAuthority) {
                newXRDS = this.resolveIRIAuth((IRIAuthority)ap, flags, state);
            } else {
                throw new RuntimeException("Unknown authority type");
            }
            xrdsOut.addAll(newXRDS);
            return xrdsOut;
        }
        catch (PartialResolutionException e) {
            xrdsOut.addAll(e.getPartialXRDS());
            throw new PartialResolutionException(xrdsOut);
        }
    }

    protected XRDS resolveXRIAuth(XRI origQXRI, XRIAuthority xriAuth, ResolverFlags flags, ResolverState state) throws PartialResolutionException {
        String rootAuth = xriAuth.getRootAuthority();
        if (rootAuth == null) {
            throw new RuntimeException("First subsegment of '" + xriAuth + "' is null");
        }
        XRD rootXRD = this.getAuthority(rootAuth);
        if (rootXRD == null) {
            XRDS xrdsOut = new XRDS();
            XRD err = this.createErrorXRD(xriAuth.toURINormalForm(), "215", "Authority '" + rootAuth + "' is not configured");
            xrdsOut.add(err);
            throw new PartialResolutionException(xrdsOut);
        }
        XRISegment segment = xriAuth.getXRISegment();
        return this.resolveAuthSegment(origQXRI, rootXRD, segment, flags, state);
    }

    protected XRDS resolveIRIAuth(IRIAuthority iriAuth, ResolverFlags flags, ResolverState state) throws PartialResolutionException {
        log.trace((Object)("resolveIRIAuth('" + iriAuth + "', flags: " + flags + ")"));
        XRDS xrdsOut = new XRDS();
        if (flags.isSaml()) {
            XRD err = this.createErrorXRD(iriAuth.toURINormalForm(), "201", "SAML is not supported for an IRI authority");
            xrdsOut.add(err);
            throw new PartialResolutionException(xrdsOut);
        }
        String scheme2 = flags.isHttps() ? "https" : "http";
        URI uri = null;
        try {
            uri = new URI(scheme2, iriAuth.getIUserInfo(), iriAuth.getIHost(), iriAuth.getPort(), null, null, null);
        }
        catch (URISyntaxException e) {
            XRD err = this.createErrorXRD(iriAuth.toURINormalForm(), "210", "Unable to construct URI to resolve IRI authority: " + e.getMessage());
            xrdsOut.add(err);
            throw new PartialResolutionException(xrdsOut);
        }
        InputStream in = null;
        try {
            in = this.getDataFromURI(uri, uri.toString(), flags, state);
        }
        catch (Exception e) {
            XRD err = this.createErrorXRD(iriAuth.toURINormalForm(), "320", "Network error occurred while resolving IRI authority: " + e.getMessage());
            xrdsOut.add(err);
            throw new PartialResolutionException(xrdsOut);
        }
        if (in == null) {
            throw new RuntimeException("resolveIRIAuth - getDataFromURI returned null");
        }
        try {
            xrdsOut = this.readXRDS(in);
            if (xrdsOut.getNumChildren() != 1) {
                XRD err = this.createErrorXRD(iriAuth.toURINormalForm(), "321", "Expected 1 XRD from IRI authority, got " + xrdsOut.getNumChildren() + " instead");
                xrdsOut.add(err);
                throw new PartialResolutionException(xrdsOut);
            }
        }
        catch (XRIResolutionException e) {
            XRD err = this.createErrorXRD(iriAuth.toURINormalForm(), "321", "Error reading XRDS from server: " + e.getMessage());
            xrdsOut.add(err);
            throw new PartialResolutionException(xrdsOut);
        }
        XRD xrd = xrdsOut.getDescriptorAt(0);
        if (!xrd.isValid()) {
            XRD err = this.createErrorXRD(iriAuth.toURINormalForm(), "223", "XRD is invalid");
            xrdsOut.add(err);
            throw new PartialResolutionException(xrdsOut);
        }
        return xrdsOut;
    }

    protected XRDS resolveViaProxy(XRI qxri, String serviceType, String serviceMediaType, boolean sepSelect, ResolverFlags flags, ResolverState state) throws PartialResolutionException {
        log.trace((Object)("resolveViaProxy('" + qxri + ", serviceType=" + serviceType + ", serviceMediaType=" + serviceMediaType + ", flags: " + flags + ")"));
        XRDS xrdsOut = new XRDS();
        URI newURI = null;
        try {
            StringBuffer query = new StringBuffer();
            if (serviceType != null) {
                query.append("_xrd_t=");
                query.append(URLEncoder.encode(serviceType, "UTF-8"));
                query.append('&');
            }
            if (serviceMediaType != null) {
                query.append("_xrd_m=");
                query.append(URLEncoder.encode(serviceMediaType, "UTF-8"));
                query.append('&');
            }
            query.append("_xrd_r=");
            query.append("application/xrds+xml");
            query.append(';');
            query.append(flags.getTrustParameters());
            query.append(";sep=");
            query.append(sepSelect);
            query.append(";ref=");
            query.append(flags.isRefs());
            query.append('&');
            if (this.proxyURI.getQuery() != null) {
                query.append(this.proxyURI.getQuery());
            }
            StringBuffer uriBuf = new StringBuffer();
            uriBuf.append(this.proxyURI.getScheme());
            uriBuf.append("://");
            uriBuf.append(this.proxyURI.getAuthority());
            uriBuf.append(this.proxyURI.getPath());
            if (uriBuf.charAt(uriBuf.length() - 1) != '/') {
                uriBuf.append('/');
            }
            StringBuffer qxriNoQuery = new StringBuffer(qxri.getAuthorityPath().toIRINormalForm());
            if (sepSelect) {
                qxriNoQuery.append(qxri.getXRIPath().toURINormalForm());
            }
            uriBuf.append(URLEncoder.encode(qxriNoQuery.toString(), "UTF-8"));
            uriBuf.append('?');
            uriBuf.append(query);
            log.trace((Object)("resolveViaProxy - constructed proxy query URI '" + uriBuf + "'"));
            newURI = new URI(uriBuf.toString());
        }
        catch (URISyntaxException oEx) {
            XRD err = this.createErrorXRD(qxri.getAuthorityPath().toURINormalForm(), "210", "Unable to construct URI to access proxy resolution service");
            xrdsOut.add(err);
            throw new PartialResolutionException(xrdsOut);
        }
        catch (UnsupportedEncodingException e) {
            XRD err = this.createErrorXRD(qxri.getAuthorityPath().toURINormalForm(), "210", "Charset not supported");
            xrdsOut.add(err);
            throw new PartialResolutionException(xrdsOut);
        }
        catch (Exception e) {
            XRD err = this.createErrorXRD(qxri.getAuthorityPath().toURINormalForm(), "200", "Unexpected error while constructing proxy URI: " + e.getMessage());
            xrdsOut.add(err);
            throw new PartialResolutionException(xrdsOut);
        }
        InputStream in = null;
        try {
            in = this.getDataFromURI(newURI, qxri.toURINormalForm(), flags, state);
            XRDS xrds = this.readXRDS(in);
            XRD finalXRD = xrds.getFinalXRD();
            String code = finalXRD.getStatusCode();
            if (flags.isRefs() && !code.equals("100") && !code.equals("262") || !code.equals("100")) {
                throw new PartialResolutionException(xrds);
            }
            return xrds;
        }
        catch (PartialResolutionException e) {
            throw e;
        }
        catch (Exception e) {
            XRD err = this.createErrorXRD(qxri.getAuthorityPath().toURINormalForm(), "200", "Error fetching XRDS from proxy: " + e.getMessage());
            xrdsOut.add(err);
            throw new PartialResolutionException(xrdsOut);
        }
    }

    protected XRDS processRedirects(XRI qxri, XRD parent, ResolverFlags flags, ResolverState state) throws PartialResolutionException {
        log.trace((Object)("processRedirects (qxri=" + qxri + ")"));
        XRDS xrdsOut = new XRDS();
        ArrayList redirects = parent.getPrioritizedRedirects();
        Iterator it = redirects.iterator();
        if (!it.hasNext()) {
            throw new RuntimeException("processRedirects: No redirect to process!");
        }
        while (it.hasNext()) {
            URI uri;
            block6: {
                Redirect r = (Redirect)it.next();
                log.debug((Object)("processRedirects - Got redirect " + r));
                try {
                    uri = new URI(r.getValue());
                    if (r.getAppend() == null) break block6;
                    String constructedURI = this.constructURI(uri, r.getAppend(), qxri);
                    uri = new URI(constructedURI);
                }
                catch (URISyntaxException e) {
                    log.warn((Object)"processRedirects - Encountered invalid URI while constructing Redirect URI");
                    continue;
                }
            }
            try {
                log.info((Object)("processRedirects - Fetching URI (" + uri + ")"));
                XRDS tmpXRDS = this.fetchRedirectXRDS(uri, parent, qxri, flags, state);
                xrdsOut.add(tmpXRDS);
                return xrdsOut;
            }
            catch (PartialResolutionException e) {
                xrdsOut.add(e.getPartialXRDS());
            }
        }
        log.info((Object)"processRedirects - exhausted list of Redirects. Throwing PRE");
        throw new PartialResolutionException(xrdsOut);
    }

    protected String verifyCID(XRD prevXRD, XRD xrd) {
        CanonicalID parentCID = prevXRD.getCanonicalID();
        CanonicalID thisCID = xrd.getCanonicalID();
        if (parentCID == null) {
            log.warn((Object)"verifyCID: no parent CID!");
            return "failed";
        }
        if (thisCID == null) {
            return "absent";
        }
        try {
            String thisParentXRIStr;
            XRI parentCIDXRI = new XRI(parentCID.getValue());
            XRI thisCIDXRI = new XRI(thisCID.getValue());
            if (parentCIDXRI.isRelative()) {
                return "failed";
            }
            if (thisCIDXRI.isRelative()) {
                return "failed";
            }
            AuthorityPath parentAuthorityAP = parentCIDXRI.getAuthorityPath();
            if (parentAuthorityAP == null) {
                return "failed";
            }
            AuthorityPath thisAuthorityAP = thisCIDXRI.getAuthorityPath();
            if (thisAuthorityAP == null) {
                return "failed";
            }
            if (!(thisAuthorityAP instanceof XRIAuthority)) {
                return "failed";
            }
            XRI thisAuthorityParentXRI = ((XRIAuthority)thisAuthorityAP).getParentAsXRI();
            if (thisAuthorityParentXRI == null) {
                return "failed";
            }
            String parentXRIStr = parentAuthorityAP.toIRINormalForm();
            if (parentXRIStr.equalsIgnoreCase(thisParentXRIStr = thisAuthorityParentXRI.getAuthorityPath().toIRINormalForm())) {
                return "verified";
            }
            return "failed";
        }
        catch (Exception e) {
            log.warn((Object)("verifyCID - exception caught: " + e));
            return "failed";
        }
    }

    protected String verifyRedirectXRD(XRD xrd, XRD parent) {
        int j;
        boolean found;
        int i;
        CanonicalID cid = xrd.getCanonicalID();
        CanonicalID cid2 = parent.getCanonicalID();
        if (cid != null && cid2 == null) {
            return "CanonicalID element is not present in parent XRD";
        }
        if (cid != null && !this.verifySynonymElement(cid, cid2)) {
            return "CanonicalID element is different from parent's";
        }
        CanonicalEquivID ceid = xrd.getCanonicalEquivID();
        CanonicalEquivID ceid2 = parent.getCanonicalEquivID();
        if (ceid != null && ceid2 == null) {
            return "CanonicalEquivID element is not present in parent XRD";
        }
        if (ceid != null && !this.verifySynonymElement(ceid, ceid2)) {
            return "CanonicalEquivID element is different from parent's";
        }
        for (i = 0; i < xrd.getNumLocalIDs(); ++i) {
            LocalID l = xrd.getLocalIDAt(i);
            found = false;
            for (j = 0; j < parent.getNumLocalIDs(); ++j) {
                if (!this.verifySynonymElement(l, parent.getLocalIDAt(j))) continue;
                found = true;
                break;
            }
            if (found) continue;
            return "LocalID element " + l.getValue() + " is not present in parent XRD";
        }
        for (i = 0; i < xrd.getNumEquivIDs(); ++i) {
            EquivID e = xrd.getEquivIDAt(i);
            found = false;
            for (j = 0; j < parent.getNumEquivIDs(); ++j) {
                if (!this.verifySynonymElement(e, parent.getEquivIDAt(j))) continue;
                found = true;
                break;
            }
            if (found) continue;
            return "EquivID element " + e.getValue() + " is not present in parent XRD";
        }
        return null;
    }

    private boolean verifySynonymElement(SimpleXMLElement e1, SimpleXMLElement e2) {
        try {
            XRI x1 = XRI.fromURINormalForm(e1.getValue());
            XRI x2 = XRI.fromURINormalForm(e2.getValue());
            return x1.equals(x2);
        }
        catch (XRIParseException e) {
            try {
                URI u1 = new URI(e1.getValue());
                URI u2 = new URI(e2.getValue());
                if (!u1.equals(u2)) {
                    return false;
                }
            }
            catch (URISyntaxException e3) {
                return false;
            }
            return true;
        }
    }

    protected String verifyCEID(XRI qxri, XRD xrd, ResolverFlags flags, ResolverState state) throws PartialResolutionException {
        XRI cidX;
        CanonicalEquivID ceid = xrd.getCanonicalEquivID();
        if (ceid == null) {
            log.debug((Object)"verifyCEID - No CEID in the XRD");
            return "absent";
        }
        log.debug((Object)("verifyCEID - Verifying CEID (" + ceid.getValue() + ")"));
        CanonicalID cid = xrd.getCanonicalID();
        if (cid == null) {
            log.debug((Object)"verifyCEID - No CID in the XRD");
            return "failed";
        }
        try {
            cidX = XRI.fromURINormalForm(cid.getValue());
        }
        catch (Exception e) {
            log.debug((Object)"verifyCEID - Unable to parse CID");
            return "failed";
        }
        if (ceid.getValue().equals(cid.getValue())) {
            log.debug((Object)"verifyCEID - CID is character-for-character equivalent to CEID.");
            return "verified";
        }
        try {
            XRI ceidX = XRI.fromURINormalForm(ceid.getValue());
            log.info((Object)"verifyCEID - resolving CEID");
            XRD ceidXRD = this.resolveAuthToXRD(ceidX, flags, state);
            Status s = ceidXRD.getStatus();
            if (!s.getCID().equals("verified")) {
                log.debug((Object)"verifyCEID - XRD for CEID is not CID verified");
                return "failed";
            }
            CanonicalID cid2 = ceidXRD.getCanonicalID();
            if (cid2 == null) {
                log.debug((Object)"verifyCEID - no CID in the XRD in CEID");
                return "failed";
            }
            XRI cidX2 = XRI.fromURINormalForm(cid2.getValue());
            if (!cidX2.toURINormalForm().equals(cidX.toURINormalForm())) {
                log.debug((Object)"verifyCEID - CEID's XRD's CID is not equivalent to the original CID");
                return "failed";
            }
            CanonicalEquivID ceid2 = ceidXRD.getCanonicalEquivID();
            XRI ceidX2 = XRI.fromURINormalForm(ceid2.getValue());
            if (ceidX2.toURINormalForm().equals(cidX.toURINormalForm())) {
                log.debug((Object)"verifyCEID - CEID backpointer found");
                return "verified";
            }
            for (int i = 0; i < ceidXRD.getNumEquivIDs(); ++i) {
                EquivID e = ceidXRD.getEquivIDAt(i);
                XRI eX = XRI.fromURINormalForm(e.getValue());
                if (!eX.toURINormalForm().equals(cidX.toURINormalForm())) continue;
                log.debug((Object)"verifyCEID - EquivID backpointer found");
                return "verified";
            }
        }
        catch (Exception e) {
            log.debug((Object)("verifyCEID - unknown error: " + e));
        }
        return "failed";
    }

    protected XRDS fetchAuthXRDSHelper(XRI qxri, URI uri, XRD parent, Service parentService, XRISegment segment, ResolverFlags flags, ResolverState state) throws PartialResolutionException {
        URI newURI;
        XRDS xrdsOut = new XRDS();
        String query = segment.getSubSegmentAt(0).toURINormalForm(true);
        try {
            newURI = this.constructAuthResURI(uri.toString(), segment.toURINormalForm(true));
            log.trace((Object)("fetchAuthXRDS - newURI = " + newURI));
        }
        catch (URISyntaxException oEx) {
            throw this.makeResolutionException(xrdsOut, query, "220", "Invalid URI for authority resolution service");
        }
        XRDS tmpXRDS = null;
        try {
            InputStream in = this.getDataFromURI(newURI, segment.toString(), flags, state);
            tmpXRDS = this.readXRDS(in);
            log.debug((Object)("fetchAuthXRDS - got XRDS = " + tmpXRDS.toString()));
        }
        catch (IOException e) {
            log.trace((Object)("fetchAuthXRDS - got IOException from URI " + newURI));
            throw this.makeResolutionException(xrdsOut, query, "320", "Networking error encountered");
        }
        catch (Exception e) {
            log.trace((Object)("fetchAuthXRDS - " + e));
            throw this.makeResolutionException(xrdsOut, query, "220", e.getMessage());
        }
        if (tmpXRDS.getNumChildren() < 1) {
            throw this.makeResolutionException(xrdsOut, query, "322", "Invalid XRDS document");
        }
        if (tmpXRDS.getNumChildren() > segment.getNumSubSegments()) {
            throw this.makeResolutionException(xrdsOut, query, "322", "Invalid XRDS document: too many XRD elements returned");
        }
        XRD prevXRD = parent;
        for (int d = 0; d < tmpXRDS.getNumChildren(); ++d) {
            Status stat;
            if (!tmpXRDS.isXRDAt(d)) {
                throw this.makeResolutionException(xrdsOut, query, "322", "Authority XRDS document should not contain XRDS element");
            }
            XRD xrd = tmpXRDS.getDescriptorAt(d);
            xrdsOut.add(xrd);
            ServerStatus sstat = xrd.getServerStatus();
            if (sstat == null) {
                stat = xrd.getStatus();
                if (stat != null) {
                    xrd.setServerStatus(new ServerStatus(stat.getCode(), stat.getText()));
                }
            } else {
                stat = new Status(sstat.getCode(), sstat.getText());
                xrd.setStatus(stat);
            }
            if (stat == null) {
                throw this.makeResolutionException(xrdsOut, query, "322", "Missing ServerStatus or Status element in XRD");
            }
            if (!stat.getCode().equals("100")) {
                throw new PartialResolutionException(xrdsOut);
            }
            if (!xrd.isValid()) {
                xrd.setStatus(new Status("321", "XRD is not valid (stale?)"));
                throw new PartialResolutionException(xrdsOut);
            }
            if (flags.isCid()) {
                Status parentStatus = parent.getStatus();
                Status s = xrd.getStatus();
                String parentCIDStat = parentStatus.getCID();
                if (parentCIDStat.equals("failed")) {
                    s.setCID("failed");
                } else {
                    s.setCID(this.verifyCID(prevXRD, xrd));
                }
            }
            if (flags.isSaml()) {
                // empty if block
            }
            prevXRD = xrd;
        }
        return xrdsOut;
    }

    protected XRDS fetchAuthXRDS(XRI qxri, XRD parent, List authResServices, XRISegment segment, ResolverFlags flags, ResolverState state) throws PartialResolutionException {
        XRDS xrdsOut = null;
        Object errXRD = null;
        String query = segment.getSubSegmentAt(0).toURINormalForm(true);
        Object savedException = null;
        for (Service srv : authResServices) {
            for (SEPUri sepURI : srv.getPrioritizedURIs()) {
                URI uri = sepURI.getURI();
                log.trace((Object)("fetchAuthXRDS - trying URI='" + uri + "'"));
                if (flags.isHttps() && !uri.getScheme().equals("https")) {
                    log.trace((Object)"fetchAuthXRDS - skipping non HTTPS URI");
                    continue;
                }
                try {
                    xrdsOut = this.fetchAuthXRDSHelper(qxri, uri, parent, srv, segment, flags, state);
                    return xrdsOut;
                }
                catch (PartialResolutionException e) {
                    xrdsOut = e.getPartialXRDS();
                }
            }
        }
        if (xrdsOut == null) {
            xrdsOut = new XRDS();
            String code = flags.isHttps() ? "230" : "220";
            xrdsOut.add(this.createErrorXRD(query, code, "No URI found for authority resolution"));
        }
        throw new PartialResolutionException(xrdsOut);
    }

    protected void checkMaxRequests(XRDS xrdsOut, String query, ResolverState state) throws PartialResolutionException {
        if (this.maxRequests >= 0 && state.getNumRequests() >= this.maxRequests) {
            XRD finalXRD = xrdsOut.getFinalXRD();
            if (finalXRD == null) {
                finalXRD = this.createErrorXRD(query, "202", "Maximum of authority resolution requests exceeded");
                xrdsOut.add(finalXRD);
            } else {
                finalXRD.setStatus(new Status("202", "Maximum of authority resolution requests exceeded"));
            }
            throw new PartialResolutionException(xrdsOut);
        }
    }

    private PartialResolutionException makeResolutionException(XRDS targetXRDS, String query, String status, String message) {
        XRD x = this.createErrorXRD(query, status, message);
        targetXRDS.add(x);
        return new PartialResolutionException(targetXRDS);
    }

    public XRDS resolveAuthSegment(XRI qxri, XRD parent, XRISegment segment, ResolverFlags flags, ResolverState state) throws PartialResolutionException {
        log.trace((Object)("resolveAuthSegment - segment='" + segment + "'"));
        XRDS xrdsOut = new XRDS();
        XRDS tmpXRDS = null;
        Object parentCID = null;
        boolean authResComplete = false;
        ResolverFlags currentFlags = null;
        String parentXRI = ((XRIAuthority)qxri.getAuthorityPath()).getRootAuthority();
        for (XRISegment remainingSegment = segment; remainingSegment != null && remainingSegment.getNumSubSegments() > 0; remainingSegment = remainingSegment.getRemainder(tmpXRDS.getNumChildren())) {
            currentFlags = new ResolverFlags(flags);
            String query = remainingSegment.getSubSegmentAt(0).toURINormalForm(true);
            log.debug((Object)("resolveAuthSegment - resolving subsegment '" + query + "'"));
            this.checkMaxRequests(xrdsOut, query, state);
            if (currentFlags.isHttps() && this.isHttpsBypassAuthority(parentXRI)) {
                log.debug((Object)("Bypassing HTTPS for " + parentXRI));
                currentFlags.setHttps(false);
            }
            String authResMediaType = "application/xrds+xml;" + currentFlags.getTrustParameters();
            ArrayList authResServices = this.selectServices(parent.getServices(), "xri://$res*auth*($v*2.0)", null, authResMediaType, currentFlags);
            if (authResServices.size() < 1) {
                log.debug((Object)"resolveAuthSegment - no authority resolution service found!");
                throw this.makeResolutionException(xrdsOut, query, "221", "Authority Resolution Service Not Found");
            }
            try {
                log.trace((Object)"resolveAuthSegment - fetching XRDS");
                tmpXRDS = this.fetchAuthXRDS(qxri, parent, authResServices, remainingSegment, currentFlags, state);
            }
            catch (PartialResolutionException e) {
                log.trace((Object)("got PRE: " + e.getPartialXRDS()));
                log.trace((Object)("xrdsOut.n = " + xrdsOut.getNumChildren() + ", partialXRDS.n=" + e.getPartialXRDS().getNumChildren()));
                xrdsOut.add(e.getPartialXRDS());
                throw new PartialResolutionException(xrdsOut);
            }
            xrdsOut.addAll(tmpXRDS);
            parent = tmpXRDS.getFinalXRD();
            for (int k = 0; k < tmpXRDS.getNumChildren(); ++k) {
                XRISubSegment subseg2 = remainingSegment.getSubSegmentAt(k);
                parentXRI = parentXRI + subseg2;
            }
            tmpXRDS = null;
            try {
                if (parent.getNumRedirects() <= 0) continue;
                log.debug((Object)"resolveAuthSegment - processing Redirect(s)");
                tmpXRDS = this.processRedirects(qxri, parent, currentFlags, state);
                xrdsOut.addAll(tmpXRDS);
                parent = tmpXRDS.getFinalXRD();
                continue;
            }
            catch (PartialResolutionException e) {
                xrdsOut.addAll(e.getPartialXRDS());
                log.debug((Object)"resolveAuthSegment - got PRE while processing Ref or Redirect");
                throw new PartialResolutionException(xrdsOut);
            }
        }
        log.debug((Object)"resolveAuthSegment - successfully resolved all subsegments");
        if (parent.getStatus().getCID().equals("verified") && parent.getCanonicalEquivID() != null) {
            log.debug((Object)"resolveAuthSegment - final XRD contains a CanonicalEquivID. Verifying...");
            String vStat = this.verifyCEID(qxri, parent, currentFlags, state);
            parent.getStatus().setCEID(vStat);
        }
        return xrdsOut;
    }

    protected XRDS processRefs(XRD parent, ResolverFlags flags, ResolverState state) throws PartialResolutionException {
        XRDS xrdsOut = new XRDS();
        ArrayList refs = parent.getPrioritizedRefs();
        Iterator it = refs.iterator();
        while (it.hasNext()) {
            XRI refXRI;
            Ref ref = (Ref)it.next();
            this.checkMaxRefs(xrdsOut, ref.getValue(), state);
            try {
                refXRI = this.parseAbsoluteQXRIOrError(ref.getValue());
            }
            catch (PartialResolutionException e) {
                xrdsOut.add(e.getPartialXRDS());
                continue;
            }
            state.pushFollowingRef(refXRI);
            try {
                XRDS tmpXRDS = this.resolveAuthority(refXRI, flags, state);
                xrdsOut.add(tmpXRDS);
                break;
            }
            catch (PartialResolutionException e) {
                xrdsOut.add(e.getPartialXRDS());
                if (it.hasNext()) continue;
                throw new PartialResolutionException(xrdsOut);
            }
        }
        return xrdsOut;
    }

    protected void checkMaxRefs(XRDS xrdsOut, String query, ResolverState state) {
    }

    protected boolean isTrustedDescriptor(XRISubSegment subseg2, XRD xrd, Service parentService) {
        String sXMLID = xrd.getXmlID();
        if (sXMLID == null || sXMLID.length() == 0) {
            return false;
        }
        String sAuthorityID = xrd.getProviderID();
        if (sAuthorityID == null || sAuthorityID.length() == 0) {
            return false;
        }
        String sSubsegment = subseg2.toString();
        if (xrd.getQuery() == null || !xrd.getQuery().equals(sSubsegment)) {
            return false;
        }
        Assertion oAssertion = xrd.getSAMLAssertion();
        if (oAssertion == null) {
            return false;
        }
        if (!oAssertion.isValid()) {
            return false;
        }
        Subject oSubject = oAssertion.getSubject();
        if (oSubject == null) {
            return false;
        }
        NameID oNameID = oSubject.getNameID();
        if (oNameID == null) {
            return false;
        }
        if (!sSubsegment.equals(oNameID.getValue())) {
            return false;
        }
        if (!sAuthorityID.equals(oNameID.getNameQualifier())) {
            return false;
        }
        AttributeStatement oAttrStmt = oAssertion.getAttributeStatement();
        if (oAttrStmt == null) {
            return false;
        }
        Attribute oAttr = oAttrStmt.getAttribute();
        if (oAttr.getName() == null || !oAttr.getName().equals("xri://$xrd*($v*2.0)")) {
            return false;
        }
        String sValue = oAttr.getValue();
        if (sValue == null || !sValue.equals("#" + sXMLID)) {
            return false;
        }
        if (parentService == null) {
            return false;
        }
        if (parentService.getProviderId() == null || !parentService.getProviderId().equals(sAuthorityID)) {
            return false;
        }
        KeyInfo oKeyInfo = parentService.getKeyInfo();
        if (oKeyInfo == null) {
            log.debug((Object)"KeyInfo is missing from describing Authority.");
            return false;
        }
        try {
            xrd.verifySignature(oKeyInfo.getPublicKey());
        }
        catch (XMLSecurityException oEx) {
            log.debug((Object)"Assertion verification failed.", (Throwable)oEx);
            return false;
        }
        return true;
    }

    public List selectServiceFromXRD(XRDS xrdsOut, XRD xrd, XRI qxri, String sepType, String sepMediaType, ResolverFlags flags, ResolverState state) throws PartialResolutionException {
        String path = null;
        XRIAbsolutePath absPath = qxri.getXRIAbsolutePath();
        if (absPath != null) {
            path = absPath.toURINormalForm();
        }
        List selectedSvcs = this.selectServices(xrd.getServices(), sepType, path, sepMediaType, flags);
        xrd.setSelectedServices(selectedSvcs);
        if (selectedSvcs.size() == 0) {
            Status s = xrd.getStatus();
            s.setCode("241");
            s.setText("Requested service endpoint not found");
            throw new PartialResolutionException(xrdsOut);
        }
        Service srv = (Service)selectedSvcs.get(0);
        if (srv.getNumRedirects() > 0) {
            selectedSvcs = this.processServiceRedirects(xrdsOut, srv, xrd, qxri, sepType, sepMediaType, flags, state);
        } else if (srv.getNumRefs() > 0) {
            selectedSvcs = this.processServiceRefs(xrdsOut, srv, xrd, qxri, sepType, sepMediaType, flags, state);
        }
        return selectedSvcs;
    }

    private List processServiceRedirects(XRDS xrdsOut, Service srv, XRD parent, XRI qxri, String sepType, String sepMediaType, ResolverFlags flags, ResolverState state) throws PartialResolutionException {
        ArrayList redirects = srv.getPrioritizedRedirects();
        Iterator it = redirects.iterator();
        if (!it.hasNext()) {
            throw new RuntimeException("processServiceRedirects: No redirect to process!");
        }
        while (it.hasNext()) {
            XRD err;
            XRDS tmpXRDS;
            URI uri;
            block6: {
                Redirect r = (Redirect)it.next();
                try {
                    uri = new URI(r.getValue());
                    if (r.getAppend() == null) break block6;
                    String constructedURI = this.constructURI(uri, r.getAppend(), qxri);
                    uri = new URI(constructedURI);
                }
                catch (URISyntaxException e) {
                    tmpXRDS = new XRDS();
                    err = this.createErrorXRD(r.getValue(), "251", "Invalid Redirect URI");
                    tmpXRDS.add(err);
                    xrdsOut.add(tmpXRDS);
                    continue;
                }
            }
            try {
                XRDS tmpXRDS2 = this.fetchRedirectXRDS(uri, parent, qxri, flags, state);
                xrdsOut.add(tmpXRDS2);
                XRD finalXRD = tmpXRDS2.getFinalXRD();
                tmpXRDS2 = new XRDS();
                List services = this.selectServiceFromXRD(tmpXRDS2, finalXRD, qxri, sepType, sepMediaType, flags, state);
                xrdsOut.addAll(tmpXRDS2);
                return services;
            }
            catch (XRIResolutionException e) {
                tmpXRDS = new XRDS();
                err = this.createErrorXRD(uri.toString(), "250", "Error fetching XRDS: " + e.getMessage());
                tmpXRDS.add(err);
                xrdsOut.add(tmpXRDS);
            }
        }
        throw new PartialResolutionException(xrdsOut);
    }

    protected List processServiceRefs(XRDS xrdsOut, Service srv, XRD parent, XRI qxri, String sepType, String sepMediaType, ResolverFlags flags, ResolverState state) throws PartialResolutionException {
        ArrayList refs = srv.getPrioritizedRefs();
        for (Ref ref : refs) {
            XRI refXRI;
            this.checkMaxRefs(xrdsOut, ref.getValue(), state);
            try {
                refXRI = this.parseAbsoluteQXRIOrError(ref.getValue());
            }
            catch (PartialResolutionException e) {
                xrdsOut.add(e.getPartialXRDS());
                continue;
            }
            state.pushFollowingRef(refXRI);
            try {
                XRDS tmpXRDS = this.resolveSEPToXRDS(refXRI, sepType, sepMediaType, flags, state);
                xrdsOut.add(tmpXRDS);
                return tmpXRDS.getFinalXRD().getSelectedServices().getList();
            }
            catch (PartialResolutionException e) {
                xrdsOut.add(e.getPartialXRDS());
            }
        }
        throw new PartialResolutionException(xrdsOut);
    }

    protected ArrayList selectServices(Vector services, String type, String path, String mediaType, ResolverFlags flags) {
        if (services == null || services.size() == 0) {
            return new ArrayList();
        }
        SEPSelector selector = new SEPSelector(new ArrayList(services));
        List selectedServices = SEPSelector.select(services, type, mediaType, path, flags);
        if (selectedServices == null || selectedServices.size() == 0) {
            return new ArrayList();
        }
        PrioritizedList list = new PrioritizedList();
        for (int i = 0; i < selectedServices.size(); ++i) {
            Service s = (Service)selectedServices.get(i);
            String priority = s.getPriority() == null ? "null" : s.getPriority().toString();
            list.addObject(priority, s);
        }
        return list.getList();
    }

    protected InputStream getDataFromURI(URI uri, String query, ResolverFlags flags, ResolverState state) throws XRIResolutionException, IOException {
        HttpURLConnection conn = null;
        InputStream in = null;
        try {
            int n;
            LinkedHashMap<String, String> requestProp = new LinkedHashMap<String, String>();
            String sContentType = "application/xrds+xml;" + flags.getTrustParameters();
            requestProp.put("Accept", sContentType);
            conn = IO.getConnectionToURI(uri, "GET", requestProp, this.moSocketFactory, this.maxFollowRedirects, false);
            if (conn.getResponseCode() != 200) {
                conn.disconnect();
                throw new XRIResolutionException("Got bad response code from URI: " + uri.toString() + ", code = " + conn.getResponseCode());
            }
            int bufSize = 4096;
            byte[] buf = new byte[bufSize];
            int bufIndex = 0;
            in = conn.getInputStream();
            while ((n = in.read()) != -1) {
                if (this.maxBytesPerRequest >= 0 && bufIndex >= this.maxBytesPerRequest) {
                    throw new XRIResolutionException("202", "Maximum response size exceeded");
                }
                if (this.maxTotalBytes >= 0 && state.getNumBytesReceived() + bufIndex >= this.maxTotalBytes) {
                    throw new XRIResolutionException("202", "Maximum total received bytes exceeded");
                }
                if (bufIndex >= bufSize) {
                    byte[] newBuf = new byte[bufSize * 2];
                    System.arraycopy(buf, 0, newBuf, 0, bufSize);
                    buf = newBuf;
                    bufSize *= 2;
                }
                buf[bufIndex++] = (byte)n;
            }
            String bufString = new String(buf, 0, bufIndex, "iso-8859-1");
            state.pushResolved(query, flags.toString(), bufString, uri);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(buf, 0, bufIndex);
            return byteArrayInputStream;
        }
        catch (IOException e) {
            log.warn((Object)("Failed XRI lookup from " + uri.toString() + ".  IOException " + e));
            throw e;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
    }

    protected XRDS fetchRedirectXRDS(URI uri, XRD parent, XRI qxri, ResolverFlags flags, ResolverState state) throws PartialResolutionException {
        Status stat;
        XRDS xrdsOut = new XRDS();
        String query = qxri.toURINormalForm();
        xrdsOut.setRedirect(uri.toString());
        XRDS tmpXRDS = null;
        try {
            log.info((Object)("fetchRedirectXRDS - fetching from URI(" + uri + ")"));
            InputStream in = this.getDataFromURI(uri, query, flags, state);
            log.info((Object)("fetchRedirectXRDS - reading content from URI(" + uri + ")"));
            tmpXRDS = this.readXRDS(in);
            log.debug((Object)("fetchRedirectXRDS - got XRDS = " + tmpXRDS.toString()));
        }
        catch (IOException e) {
            log.error((Object)("fetchRedirectXRDS - got IOException from URI " + uri));
            throw this.makeResolutionException(xrdsOut, query, "320", "Networking error encountered");
        }
        catch (Exception e) {
            log.error((Object)("fetchRedirectXRDS - unexpected error: " + e));
            e.printStackTrace();
            throw this.makeResolutionException(xrdsOut, query, "220", e.getMessage());
        }
        if (tmpXRDS.getNumChildren() != 1 || !tmpXRDS.isXRDAt(0)) {
            throw this.makeResolutionException(xrdsOut, query, "322", "Invalid XRDS document: single XRD element expected");
        }
        if (!tmpXRDS.isXRDAt(0)) {
            throw this.makeResolutionException(xrdsOut, query, "322", "Authority XRDS document should not contain XRDS element");
        }
        XRD xrd = tmpXRDS.getDescriptorAt(0);
        xrdsOut.add(xrd);
        ServerStatus sstat = xrd.getServerStatus();
        if (sstat == null) {
            stat = xrd.getStatus();
        } else {
            stat = new Status(sstat.getCode(), sstat.getText());
            xrd.setStatus(stat);
        }
        if (stat == null) {
            throw this.makeResolutionException(xrdsOut, query, "322", "Missing ServerStatus or Status element in Redirect XRD");
        }
        if (!stat.getCode().equals("100")) {
            throw new PartialResolutionException(xrdsOut);
        }
        if (!xrd.isValid()) {
            xrd.setStatus(new Status("321", "XRD is not valid (stale?)"));
            throw new PartialResolutionException(xrdsOut);
        }
        String err = this.verifyRedirectXRD(xrd, parent);
        if (err != null) {
            xrd.setStatus(new Status("253", err));
            throw new PartialResolutionException(xrdsOut);
        }
        stat.setCID(xrd.getCanonicalID() == null ? "absent" : parent.getStatus().getCID());
        stat.setCEID(parent.getStatus().getCEID());
        try {
            if (xrd.getNumRedirects() > 0) {
                log.info((Object)("fetchRedirectXRDS - XRD at URI(" + uri + ") contains Redirect(s), following.."));
                tmpXRDS = this.processRedirects(qxri, xrd, flags, state);
                xrdsOut.addAll(tmpXRDS);
            } else if (xrd.getNumRefs() > 0) {
                if (!flags.isRefs()) {
                    throw this.makeResolutionException(xrdsOut, query, "262", "Ref not followed");
                }
                log.info((Object)("fetchRedirectXRDS - XRD at URI(" + uri + ") contains Ref(s), following.."));
                tmpXRDS = this.processRefs(xrd, flags, state);
                xrdsOut.addAll(tmpXRDS);
            }
        }
        catch (PartialResolutionException e) {
            xrdsOut.addAll(e.getPartialXRDS());
            throw new PartialResolutionException(xrdsOut);
        }
        return xrdsOut;
    }

    protected XRDS readXRDS(InputStream in) throws XRIResolutionException {
        XRDS xrds = null;
        if (in == null) {
            return xrds;
        }
        try {
            log.debug((Object)"readXRDS - parsing input stream");
            DOMParser domParser = DOMUtils.getDOMParser();
            domParser.parse(new InputSource(in));
            Document doc = domParser.getDocument();
            Element element = doc.getDocumentElement();
            log.debug((Object)"readXRDS - successfully read XML document into DOM");
            xrds = new XRDS(element, true);
            log.debug((Object)"readXRDS - successfully parsed XRDS document");
        }
        catch (IOException e) {
            throw new XRIResolutionException("I/O error while reading XRDS document: " + e, e);
        }
        catch (SAXException e) {
            throw new XRIResolutionException("Invalid XRDS document: " + e, e);
        }
        catch (URISyntaxException e) {
            throw new XRIResolutionException("Error parsing XRDS document (URISyntaxException): " + e, e);
        }
        catch (ParseException e) {
            throw new XRIResolutionException("Error parsing XRDS document (ParseException)", e);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {}
        }
        return xrds;
    }

    public Resolver(Properties properties) throws URISyntaxException, ParseException {
        this();
        if (properties == null) {
            properties = new Properties();
            try {
                properties.load(this.getClass().getResourceAsStream("resolver.properties"));
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        int maxFollowRedirects = Integer.parseInt(properties.getProperty("MaxFollowRedirects", "10"));
        int maxFollowRefs = Integer.parseInt(properties.getProperty("MaxFollowRefs", "10"));
        int maxRequests = Integer.parseInt(properties.getProperty("MaxRequests", "10"));
        int maxTotalBytes = Integer.parseInt(properties.getProperty("MaxTotalBytes", "1048576"));
        int maxBytesPerRequest = Integer.parseInt(properties.getProperty("MaxBytesPerRequest", "512000"));
        XRD equalsAuthority = XRD.parseXRD(properties.getProperty("EqualsAuthority"), false);
        XRD atAuthority = XRD.parseXRD(properties.getProperty("AtAuthority"), false);
        XRD bangAuthority = XRD.parseXRD(properties.getProperty("BangAuthority"), false);
        String supports = properties.getProperty("SupportedResMediaTypes");
        this.setMaxFollowRedirects(maxFollowRedirects);
        this.setMaxFollowRefs(maxFollowRefs);
        this.setMaxRequests(maxRequests);
        this.setMaxTotalBytes(maxTotalBytes);
        this.setMaxBytesPerRequest(maxBytesPerRequest);
        this.setAuthority("=", equalsAuthority);
        this.setAuthority("@", atAuthority);
        this.setAuthority("!", bangAuthority);
    }

    public XRD createErrorXRD(String query, String code, String msg) {
        XRD err = new XRD();
        err.setQuery(query);
        Status stat = new Status(code, msg);
        err.setStatus(stat);
        return err;
    }

    public URI constructAuthResURI(String sepURI, String segment) throws URISyntaxException {
        StringBuffer sb = new StringBuffer(sepURI.toString());
        if (sb.length() == 0 || sb.charAt(sb.length() - 1) != '/') {
            sb.append('/');
        }
        sb.append(segment);
        return new URI(sb.toString());
    }

    public String constructURI(URI sepURI, String append, XRI qxri) {
        log.trace((Object)("constructURI - sepURI=" + sepURI + ", append=" + append + ", qxri=" + qxri));
        if (append == null) {
            return sepURI.toString();
        }
        StringBuffer result = new StringBuffer(sepURI.toString());
        if (!append.equals("none")) {
            if (append.equals("local")) {
                XRIQuery query;
                XRIPath path = qxri.getXRIPath();
                if (path != null) {
                    result.append(path.toURINormalForm());
                }
                if ((query = qxri.getQuery()) != null) {
                    result.append('?');
                    result.append(query);
                }
            } else if (append.equals("authority")) {
                AuthorityPath a = qxri.getAuthorityPath();
                if (a != null) {
                    result.append(a.toURINormalForm());
                }
            } else if (append.equals("path")) {
                XRIAbsolutePath p = qxri.getXRIAbsolutePath();
                if (p != null) {
                    result.append(p.toURINormalForm());
                }
            } else if (append.equals("query")) {
                XRIQuery q = qxri.getQuery();
                if (q != null && q.toString().length() > 0) {
                    result.append("?" + q.toString());
                }
            } else if (append.equals("qxri")) {
                String qxriParam = qxri.toURINormalForm();
                if (qxriParam.startsWith("xri://")) {
                    qxriParam = qxriParam.substring(6);
                }
                result.append(qxriParam);
            }
        }
        log.trace((Object)("constructURI - returning '" + result + "'"));
        return result.toString();
    }

    private void constructURIinXRD(XRD finalXRD, XRI qxri) {
        ArrayList seps = finalXRD.getSelectedServices().getList();
        Iterator it = seps.iterator();
        log.debug((Object)"constructURIinXRD()");
        while (it.hasNext()) {
            log.debug((Object)"constructURIinXRD() got selected service");
            Service sep = (Service)it.next();
            List uris = sep.getURIs();
            for (SEPUri uri : uris) {
                String append = uri.getAppend();
                if (append == null) continue;
                String r = this.constructURI(uri.getURI(), uri.getAppend(), qxri);
                try {
                    uri.setURI(new URI(r));
                    uri.setAppend(null);
                }
                catch (URISyntaxException e) {}
            }
        }
        for (int i = 0; i < finalXRD.getNumServices(); ++i) {
            log.debug((Object)"constructURIinXRD() got service");
            Service sep = finalXRD.getServiceAt(i);
            List uris = sep.getURIs();
            for (SEPUri uri : uris) {
                String append = uri.getAppend();
                if (append == null) continue;
                String r = this.constructURI(uri.getURI(), uri.getAppend(), qxri);
                try {
                    uri.setURI(new URI(r));
                    uri.setAppend(null);
                }
                catch (URISyntaxException e) {}
            }
        }
    }

    private XRI parseAbsoluteQXRIOrError(String qxri) throws PartialResolutionException {
        try {
            XRI xri2 = new XRI(qxri);
            if (xri2.isRelative()) {
                XRD err = this.createErrorXRD(qxri, "211", "QXRI is not absolute.");
                throw new PartialResolutionException(err);
            }
            return xri2;
        }
        catch (XRIParseException e) {
            XRD err = this.createErrorXRD(qxri, "211", "QXRI parse error: " + e.getMessage());
            throw new PartialResolutionException(err);
        }
        catch (Exception e) {
            XRD err = this.createErrorXRD(qxri, "200", "Unexpected error while parsing input: " + e.getMessage());
            throw new PartialResolutionException(err);
        }
    }

    protected XRI parseAbsoluteXRI(String qxri) {
        try {
            XRI xri2 = new XRI(qxri);
            if (xri2.isRelative()) {
                log.warn((Object)("parseAbsoluteXRI - '" + qxri + "' is not absolute!"));
                return null;
            }
            return xri2;
        }
        catch (XRIParseException e) {
            log.warn((Object)("parseAbsoluteXRI - failed to parse '" + qxri + "' - " + e.getMessage()));
            return null;
        }
    }

    public void setMaxFollowRefs(int maxFollowRefs) {
        this.maxFollowRefs = maxFollowRefs;
    }

    public void setMaxRequests(int maxRequests) {
        this.maxRequests = maxRequests;
    }

    public void setMaxTotalBytes(int maxTotalBytes) {
        this.maxTotalBytes = maxTotalBytes;
    }

    public void setMaxBytesPerRequest(int maxBytesPerRequest) {
        this.maxBytesPerRequest = maxBytesPerRequest;
    }

    public boolean hasAuthority(String auth) {
        return this.root.containsKey(auth);
    }

    public XRD getAuthority(String auth) {
        Object xrd = this.root.get(auth);
        return xrd == null ? null : (XRD)xrd;
    }

    public void setAuthority(String auth, XRD authXRD) {
        this.root.put(auth, authXRD);
    }

    public void addHttpsBypassAuthority(String auth) {
        this.needNoHttps.put(auth.toLowerCase(), Boolean.TRUE);
    }

    public boolean isHttpsBypassAuthority(String auth) {
        return this.needNoHttps.containsKey(auth.toLowerCase());
    }

    public URI getProxyURI() {
        return this.proxyURI;
    }

    public void setProxyURI(URI proxyURI) {
        this.proxyURI = proxyURI;
    }
}

