/*
 * Decompiled with CFR 0.152.
 */
package org.openxri;

import org.openxri.ParseStream;
import org.openxri.XRIParseException;

public abstract class Parsable
implements Comparable {
    String msValue = null;
    boolean mbParsed = false;
    boolean mbParseResult = false;

    Parsable() {
        this.setValue(null);
    }

    Parsable(String sValue) {
        this.setValue(sValue);
    }

    private void setValue(String sValue) {
        this.msValue = sValue;
    }

    public String toString() {
        return this.msValue;
    }

    void parse() {
        String sValue = this.msValue;
        if (!this.mbParsed) {
            ParseStream oStream = new ParseStream(this.msValue);
            if (this.scan(oStream)) {
                this.mbParseResult = oStream.getData().length() == 0;
            }
            this.mbParsed = true;
        }
        if (!this.mbParseResult) {
            throw new XRIParseException("Not a valid " + this.getClass().getName() + " class: \"" + sValue + "\"");
        }
    }

    boolean scan(ParseStream oParseStream) {
        if (oParseStream == null) {
            return false;
        }
        ParseStream oStream = oParseStream.begin();
        if (this.doScan(oStream)) {
            this.setParsedValue(oParseStream.getConsumed(oStream));
            oParseStream.end(oStream);
            return true;
        }
        return false;
    }

    abstract boolean doScan(ParseStream var1);

    void setParsedValue(String sValue) {
        this.msValue = sValue != null ? sValue : "";
        this.mbParsed = true;
        this.mbParseResult = true;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Parsable)) {
            return false;
        }
        Parsable other = (Parsable)object;
        if (this.msValue == null && other.msValue != null) {
            return false;
        }
        if (this.msValue != null && other.msValue == null) {
            return false;
        }
        return this.msValue == null || other.msValue == null || this.msValue.equals(other.msValue);
    }

    public int hashCode() {
        return this.msValue == null ? 0 : this.msValue.hashCode();
    }

    public int compareTo(Object object) {
        Parsable other = (Parsable)object;
        if (object == null || this.msValue == null || other.msValue == null) {
            throw new NullPointerException();
        }
        return this.msValue.compareTo(other.msValue);
    }
}

