/*
 * Decompiled with CFR 0.152.
 */
package org.openid4java.discovery.xri;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openid4java.discovery.DiscoveryException;
import org.openid4java.discovery.DiscoveryInformation;
import org.openid4java.discovery.XriIdentifier;
import org.openid4java.discovery.xri.XriResolver;
import org.openxri.XRI;
import org.openxri.resolve.Resolver;
import org.openxri.resolve.ResolverFlags;
import org.openxri.resolve.ResolverState;
import org.openxri.resolve.exception.PartialResolutionException;
import org.openxri.xml.CanonicalID;
import org.openxri.xml.SEPUri;
import org.openxri.xml.Service;
import org.openxri.xml.XRD;
import org.openxri.xml.XRDS;

public class LocalXriResolver
implements XriResolver {
    private static Log _log = LogFactory.getLog(LocalXriResolver.class);
    private static final boolean DEBUG = _log.isDebugEnabled();
    private Resolver _openXriResolver;

    public LocalXriResolver() {
        if (DEBUG) {
            _log.debug((Object)"Initializing local XRI resolver...");
        }
        try {
            this._openXriResolver = new Resolver(null);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot initialize OpenXRI Resolver: " + e.getMessage(), e);
        }
    }

    public Resolver getResolver() {
        return this._openXriResolver;
    }

    public List discover(XriIdentifier xri2) throws DiscoveryException {
        try {
            XRD xrd;
            ResolverFlags flags = new ResolverFlags();
            flags.setCid(true);
            flags.setRefs(true);
            ResolverState state = new ResolverState();
            XRDS xrds = this._openXriResolver.resolveAuthToXRDS(new XRI(xri2.getIdentifier()), flags, state);
            if (DEBUG) {
                _log.debug((Object)("Retrieved XRDS:\n" + xrds.dump()));
            }
            if (!(xrd = xrds.getFinalXRD()).getStatus().getCID().equals("verified")) {
                _log.error((Object)("Unverified CanonicalID: " + xrd.getCanonicalID() + " of: " + xri2.getIdentifier()));
                throw new RuntimeException("Unverified CanonicalID: " + xrd.getCanonicalID() + " of: " + xri2.getIdentifier());
            }
            CanonicalID canonical = xrd.getCanonicalID();
            if (canonical == null) {
                throw new RuntimeException("Missing CanonicalID of: " + xri2.getIdentifier());
            }
            _log.info((Object)("XRI resolution succeeded on " + xri2.toString()));
            return this.extractDiscoveryInformation(xrds, xri2, this._openXriResolver);
        }
        catch (Exception e) {
            throw new DiscoveryException("Cannot resolve XRI: " + xri2, (Throwable)e);
        }
    }

    public XriIdentifier parseIdentifier(String identifier) throws DiscoveryException {
        XRI xri2 = new XRI(identifier);
        return new XriIdentifier(identifier, xri2.toIRINormalForm(), xri2.toURINormalForm());
    }

    protected List extractDiscoveryInformation(XRDS xrds, XriIdentifier identifier, Resolver xriResolver) throws DiscoveryException {
        ArrayList endpoints = new ArrayList();
        XRD xrd = xrds.getFinalXRD();
        this.extractDiscoveryInformationOpenID(xriResolver, endpoints, xrd, identifier, "http://specs.openid.net/auth/2.0/server", false);
        this.extractDiscoveryInformationOpenID(xriResolver, endpoints, xrd, identifier, "http://specs.openid.net/auth/2.0/signon", true);
        this.extractDiscoveryInformationOpenID(xriResolver, endpoints, xrd, identifier, "http://openid.net/signon/1.1", true);
        this.extractDiscoveryInformationOpenID(xriResolver, endpoints, xrd, identifier, "http://openid.net/signon/1.0", true);
        if (endpoints.size() == 0) {
            _log.info((Object)"No OpenID service types found in the XRDS.");
        }
        return endpoints;
    }

    protected boolean extractDiscoveryInformationOpenID(Resolver xriResolver, ArrayList out, XRD baseXRD, XriIdentifier identifier, String srvType, boolean wantCID) {
        try {
            ResolverFlags flags = new ResolverFlags();
            flags.setCid(true);
            flags.setRefs(true);
            flags.setNoDefaultT(srvType != null);
            ResolverState state = new ResolverState();
            List services = xriResolver.selectServiceFromXRD(new XRDS(), baseXRD, new XRI(identifier.getIdentifier()), srvType, null, flags, state);
            XriIdentifier claimedIdentifier = null;
            if (!baseXRD.getStatus().getCID().equals("verified")) {
                _log.error((Object)("Unverified CanonicalID: " + baseXRD.getCanonicalID() + " of:" + identifier.getIdentifier()));
                return false;
            }
            if (wantCID) {
                CanonicalID canonID = baseXRD.getCanonicalID();
                if (canonID == null) {
                    _log.error((Object)("No CanonicalID found for " + srvType + " after XRI resolution of: " + identifier.getIdentifier()));
                    return false;
                }
                claimedIdentifier = this.parseIdentifier(canonID.getValue());
                _log.info((Object)("Using canonicalID as claimedID: " + claimedIdentifier.getIdentifier() + " for " + srvType));
            }
            for (Service srv : services) {
                for (SEPUri sepURI : srv.getPrioritizedURIs()) {
                    try {
                        String urlString = xriResolver.constructURI(sepURI.getURI(), sepURI.getAppend(), new XRI(identifier.toString()));
                        URL opEndpointUrl = new URL(urlString);
                        DiscoveryInformation extracted = new DiscoveryInformation(opEndpointUrl, wantCID ? claimedIdentifier : null, null, srvType);
                        _log.info((Object)("Added " + srvType + " endpoint: " + opEndpointUrl));
                        out.add(extracted);
                    }
                    catch (MalformedURLException mue) {
                        _log.warn((Object)("Ignoring malformed OP endpoint URL in XRDS file: " + sepURI.toString()), (Throwable)mue);
                    }
                    catch (IllegalArgumentException ee) {
                        _log.warn((Object)("Ignoring invalid OP endpoint URL in XRDS file: " + sepURI.toString()), (Throwable)ee);
                    }
                }
            }
            return true;
        }
        catch (PartialResolutionException e) {
            _log.error((Object)("XRI resolution failed for " + srvType), (Throwable)e);
        }
        catch (DiscoveryException de) {
            _log.error((Object)("XRDS discovery failed for " + srvType), (Throwable)de);
        }
        return false;
    }
}

