/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.provider.ui.client;

import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.provider.stub.IdentityProviderAdminServiceStub;

public class IdentityProviderClient {
    private static final Log log = LogFactory.getLog(IdentityProviderClient.class);
    private IdentityProviderAdminServiceStub stub = null;

    public IdentityProviderClient(String cookie, String backendServerURL, ConfigurationContext configCtx) throws AxisFault {
        String serviceURL = backendServerURL + "IdentityProviderAdminService";
        this.stub = new IdentityProviderAdminServiceStub(configCtx, serviceURL);
        ServiceClient client = this.stub._getServiceClient();
        Options option = client.getOptions();
        option.setManageSession(true);
        option.setProperty("Cookie", (Object)cookie);
    }

    public String getOpenID(String username) throws AxisFault {
        try {
            return this.stub.getPrimaryOpenID(username);
        }
        catch (Exception e) {
            this.handleException("Error ouccured while retreiving OpeniD", e);
            return null;
        }
    }

    public String[] getAllOpenIDs(String userName) throws Exception {
        return this.stub.getAllOpenIDs(userName);
    }

    public void removeOpenIDSignUp(String openID) throws Exception {
        this.stub.removeOpenID(openID);
    }

    private void handleException(String msg, Exception e) throws AxisFault {
        log.error((Object)msg, (Throwable)e);
        throw new AxisFault(msg, (Throwable)e);
    }
}

