/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.identity.oauth.IdentityOAuthAdminException;
import org.wso2.carbon.identity.oauth.OAuthUtil;
import org.wso2.carbon.identity.oauth.internal.OAuthComponentServiceHolder;
import org.wso2.carbon.registry.api.RegistryService;
import org.wso2.carbon.user.core.service.RealmService;

public class OAuthServiceComponent {
    private static Log log = LogFactory.getLog(OAuthServiceComponent.class);

    protected void activate(ComponentContext context) {
        try {
            OAuthUtil.parseAuthzCallbackHandlersConfig();
        }
        catch (IdentityOAuthAdminException identityOAuthAdminException) {
            // empty catch block
        }
        if (log.isDebugEnabled()) {
            log.info((Object)"Identity OAuth bundle is activated");
        }
    }

    protected void deactivate(ComponentContext context) {
        if (log.isDebugEnabled()) {
            log.info((Object)"Identity OAuth bundle is deactivated");
        }
    }

    protected void setRegistryService(org.wso2.carbon.registry.core.service.RegistryService registryService) {
        if (log.isDebugEnabled()) {
            log.info((Object)"RegistryService set in Identity OAuth bundle");
        }
        OAuthComponentServiceHolder.setRegistryService((RegistryService)registryService);
    }

    protected void unsetRegistryService(org.wso2.carbon.registry.core.service.RegistryService registryService) {
        if (log.isDebugEnabled()) {
            log.info((Object)"RegistryService unset in Identity OAuth bundle");
        }
        OAuthComponentServiceHolder.setRegistryService(null);
    }

    protected void setRealmService(RealmService realmService) {
        if (log.isDebugEnabled()) {
            log.info((Object)"Setting the Realm Service");
        }
        OAuthComponentServiceHolder.setRealmService(realmService);
    }

    protected void unsetRealmService(RealmService realmService) {
        if (log.isDebugEnabled()) {
            log.info((Object)"Unsetting the Realm Service");
        }
        OAuthComponentServiceHolder.setRealmService(null);
    }
}

