/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.core.persistence.JDBCPersistenceManager;
import org.wso2.carbon.identity.core.util.IdentityDatabaseUtil;
import org.wso2.carbon.identity.oauth.IdentityOAuthAdminException;
import org.wso2.carbon.identity.oauth.Parameters;

public class OAuthConsumerDAO {
    public static final Log log = LogFactory.getLog(OAuthConsumerDAO.class);

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getOAuthConsumerSecret(String consumerKey) throws IdentityOAuthAdminException {
        String consumerSecret = null;
        Connection connection = null;
        PreparedStatement prepStmt = null;
        ResultSet resultSet = null;
        try {
            connection = JDBCPersistenceManager.getInstance().getDBConnection();
            prepStmt = connection.prepareStatement("SELECT CONSUMER_SECRET FROM IDENTITY_OAUTH_CONSUMER_APPLICATIONS WHERE CONSUMER_KEY=?");
            prepStmt.setString(1, consumerKey);
            resultSet = prepStmt.executeQuery();
            if (resultSet.next()) {
                consumerSecret = resultSet.getString(1);
            } else {
                log.debug((Object)("Invalid Consumer Key : " + consumerKey));
            }
        }
        catch (IdentityException e) {
            try {
                String errorMsg = "Error when getting an Identity Persistence Store instance.";
                log.error((Object)errorMsg, (Throwable)e);
                throw new IdentityOAuthAdminException(errorMsg, e);
                catch (SQLException e2) {
                    log.error((Object)"Error when executing the SQL : SELECT CONSUMER_SECRET FROM IDENTITY_OAUTH_CONSUMER_APPLICATIONS WHERE CONSUMER_KEY=?");
                    log.error((Object)e2.getMessage(), (Throwable)e2);
                    throw new IdentityOAuthAdminException("Error when reading the consumer secret for consumer key : " + consumerKey);
                }
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeAllConnections((Connection)connection, resultSet, prepStmt);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, (ResultSet)resultSet, (PreparedStatement)prepStmt);
        return consumerSecret;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getOAuthTokenSecret(String token, Boolean isAccessToken) throws IdentityOAuthAdminException {
        String tokenSecret = null;
        Connection connection = null;
        PreparedStatement prepStmt = null;
        ResultSet resultSet = null;
        String sqlStmt = isAccessToken != false ? "SELECT ACCESS_TOKEN_SECRET FROM IDENTITY_OAUTH1A_ACCESS_TOKEN WHERE ACCESS_TOKEN=?" : "SELECT REQUEST_TOKEN_SECRET FROM IDENTITY_OAUTH1A_REQUEST_TOKEN WHERE REQUEST_TOKEN=?";
        try {
            connection = JDBCPersistenceManager.getInstance().getDBConnection();
            prepStmt = connection.prepareStatement(sqlStmt);
            prepStmt.setString(1, token);
            resultSet = prepStmt.executeQuery();
            if (!resultSet.next()) {
                log.error((Object)("Invalid token : " + token));
                throw new IdentityException("Invalid token. No such token is issued");
            }
            tokenSecret = resultSet.getString(1);
        }
        catch (IdentityException e) {
            try {
                String errorMsg = "Error when getting an Identity Persistence Store instance.";
                log.error((Object)errorMsg, (Throwable)e);
                throw new IdentityOAuthAdminException(errorMsg, e);
                catch (SQLException e2) {
                    log.error((Object)("Error when executing the SQL : " + sqlStmt));
                    log.error((Object)e2.getMessage(), (Throwable)e2);
                    throw new IdentityOAuthAdminException("Error when reading the consumer secret for consumer key : " + token);
                }
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeAllConnections((Connection)connection, resultSet, prepStmt);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, (ResultSet)resultSet, (PreparedStatement)prepStmt);
        return tokenSecret;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void createOAuthRequestToken(String consumerKey, String oauthToken, String oauthSecret, String userCallback, String scope) throws IdentityOAuthAdminException {
        String OUT_OF_BAND = "oob";
        if (userCallback == null || "oob".equals(userCallback)) {
            userCallback = this.getCallbackURLOfApp(consumerKey);
        }
        Connection connection = null;
        PreparedStatement prepStmt = null;
        try {
            connection = JDBCPersistenceManager.getInstance().getDBConnection();
            prepStmt = connection.prepareStatement("INSERT INTO IDENTITY_OAUTH1A_REQUEST_TOKEN (REQUEST_TOKEN, REQUEST_TOKEN_SECRET, CONSUMER_KEY, CALLBACK_URL, SCOPE, AUTHORIZED) VALUES (?,?,?,?,?,?)");
            prepStmt.setString(1, oauthToken);
            prepStmt.setString(2, oauthSecret);
            prepStmt.setString(3, consumerKey);
            prepStmt.setString(4, userCallback);
            prepStmt.setString(5, scope);
            prepStmt.setString(6, Boolean.toString(false));
            prepStmt.execute();
            connection.commit();
        }
        catch (IdentityException e) {
            try {
                String errorMsg = "Error when getting an Identity Persistence Store instance.";
                log.error((Object)errorMsg, (Throwable)e);
                throw new IdentityOAuthAdminException(errorMsg, e);
                catch (SQLException e2) {
                    log.error((Object)"Error when executing the SQL : INSERT INTO IDENTITY_OAUTH1A_REQUEST_TOKEN (REQUEST_TOKEN, REQUEST_TOKEN_SECRET, CONSUMER_KEY, CALLBACK_URL, SCOPE, AUTHORIZED) VALUES (?,?,?,?,?,?)");
                    log.error((Object)e2.getMessage(), (Throwable)e2);
                    throw new IdentityOAuthAdminException("Error when creating the request token for consumer : " + consumerKey);
                }
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, prepStmt);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, (PreparedStatement)prepStmt);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Parameters authorizeOAuthToken(String oauthToken, String userName, String oauthVerifier) throws IdentityException {
        Connection connection = null;
        PreparedStatement prepStmt = null;
        try {
            connection = JDBCPersistenceManager.getInstance().getDBConnection();
            prepStmt = connection.prepareStatement("UPDATE IDENTITY_OAUTH1A_REQUEST_TOKEN SET AUTHORIZED=?, OAUTH_VERIFIER=?, AUTHZ_USER=? WHERE REQUEST_TOKEN=?");
            prepStmt.setString(1, Boolean.toString(true));
            prepStmt.setString(2, oauthVerifier);
            prepStmt.setString(3, userName);
            prepStmt.setString(4, oauthToken);
            prepStmt.execute();
            connection.commit();
        }
        catch (IdentityException e) {
            try {
                String errorMsg = "Error when getting an Identity Persistence Store instance.";
                log.error((Object)errorMsg, (Throwable)e);
                throw new IdentityOAuthAdminException(errorMsg, e);
                catch (SQLException e2) {
                    log.error((Object)"Error when executing the SQL : UPDATE IDENTITY_OAUTH1A_REQUEST_TOKEN SET AUTHORIZED=?, OAUTH_VERIFIER=?, AUTHZ_USER=? WHERE REQUEST_TOKEN=?");
                    log.error((Object)e2.getMessage(), (Throwable)e2);
                    throw new IdentityOAuthAdminException("Error when authorizing the request token : " + oauthToken);
                }
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, prepStmt);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, (PreparedStatement)prepStmt);
        Parameters params = new Parameters();
        params.setOauthCallback(this.getCallbackURLOfReqToken(oauthToken));
        return params;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Parameters getRequestToken(String oauthToken) throws IdentityOAuthAdminException {
        Parameters params = new Parameters();
        Connection connection = null;
        PreparedStatement prepStmt = null;
        ResultSet resultSet = null;
        try {
            connection = JDBCPersistenceManager.getInstance().getDBConnection();
            prepStmt = connection.prepareStatement("SELECT * FROM IDENTITY_OAUTH1A_REQUEST_TOKEN WHERE REQUEST_TOKEN=?");
            prepStmt.setString(1, oauthToken);
            resultSet = prepStmt.executeQuery();
            if (!resultSet.next()) {
                log.error((Object)("Invalid request token : " + oauthToken));
                throw new IdentityException("Invalid request token. No such token issued.");
            }
            params.setOauthToken(resultSet.getString(1));
            params.setOauthTokenSecret(resultSet.getString(2));
            params.setOauthConsumerKey(resultSet.getString(3));
            params.setOauthCallback(resultSet.getString(4));
            params.setScope(resultSet.getString(5));
            params.setOauthTokenVerifier(resultSet.getString(7));
            params.setAuthorizedbyUserName(resultSet.getString(8));
            String tokenIssued = resultSet.getString(6);
            if ("true".equals(tokenIssued)) {
                params.setAccessTokenIssued(true);
            }
        }
        catch (IdentityException e) {
            try {
                String errorMsg = "Error when getting an Identity Persistence Store instance.";
                log.error((Object)errorMsg, (Throwable)e);
                throw new IdentityOAuthAdminException(errorMsg, e);
                catch (SQLException e2) {
                    log.error((Object)"Error when executing the SQL : SELECT * FROM IDENTITY_OAUTH1A_REQUEST_TOKEN WHERE REQUEST_TOKEN=?");
                    log.error((Object)e2.getMessage(), (Throwable)e2);
                    throw new IdentityOAuthAdminException("Error when request token from the persistence store : " + oauthToken);
                }
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeAllConnections((Connection)connection, resultSet, prepStmt);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, (ResultSet)resultSet, (PreparedStatement)prepStmt);
        return params;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void issueAccessToken(String consumerKey, String accessToken, String accessTokenSecret, String requestToken, String authorizedUser, String scope) throws IdentityOAuthAdminException {
        Connection connection = null;
        PreparedStatement removeReqTokStmt = null;
        PreparedStatement issueAccessTokStmt = null;
        try {
            connection = JDBCPersistenceManager.getInstance().getDBConnection();
            removeReqTokStmt = connection.prepareStatement("DELETE FROM IDENTITY_OAUTH1A_REQUEST_TOKEN WHERE REQUEST_TOKEN=?");
            removeReqTokStmt.setString(1, requestToken);
            removeReqTokStmt.execute();
            issueAccessTokStmt = connection.prepareStatement("INSERT INTO IDENTITY_OAUTH1A_ACCESS_TOKEN VALUES (?,?,?,?,?)");
            issueAccessTokStmt.setString(1, accessToken);
            issueAccessTokStmt.setString(2, accessTokenSecret);
            issueAccessTokStmt.setString(3, consumerKey);
            issueAccessTokStmt.setString(4, scope);
            issueAccessTokStmt.setString(5, authorizedUser);
            connection.commit();
        }
        catch (IdentityException e) {
            try {
                String errorMsg = "Error when getting an Identity Persistence Store instance.";
                log.error((Object)errorMsg, (Throwable)e);
                throw new IdentityOAuthAdminException(errorMsg, e);
                catch (SQLException e2) {
                    log.error((Object)e2.getMessage(), (Throwable)e2);
                    throw new IdentityOAuthAdminException("Error when creating the request token for consumer : " + consumerKey);
                }
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeStatement(issueAccessTokStmt);
                IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, (PreparedStatement)removeReqTokStmt);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeStatement((PreparedStatement)issueAccessTokStmt);
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, (PreparedStatement)removeReqTokStmt);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String validateAccessToken(String consumerKey, String oauthToken, String reqScope) throws IdentityException {
        Connection connection = null;
        PreparedStatement prepStmt = null;
        ResultSet resultSet = null;
        String scope = null;
        String authorizedUser = null;
        try {
            connection = JDBCPersistenceManager.getInstance().getDBConnection();
            prepStmt = connection.prepareStatement("SELECT SCOPE, AUTHZ_USER FROM IDENTITY_OAUTH1A_ACCESS_TOKEN WHERE ACCESS_TOKEN=?");
            prepStmt.setString(1, consumerKey);
            resultSet = prepStmt.executeQuery();
            if (!resultSet.next()) {
                throw new IdentityException("Invalid access token. No such token issued.");
            }
            scope = resultSet.getString(1);
            authorizedUser = resultSet.getString(2);
        }
        catch (IdentityException e) {
            try {
                String errorMsg = "Error when getting an Identity Persistence Store instance.";
                log.error((Object)errorMsg, (Throwable)e);
                throw new IdentityOAuthAdminException(errorMsg, e);
                catch (SQLException e2) {
                    log.error((Object)"Error when executing the SQL : SELECT CALLBACK_URL FROM IDENTITY_OAUTH_CONSUMER_APPLICATIONS WHERE CONSUMER_KEY=?");
                    log.error((Object)e2.getMessage(), (Throwable)e2);
                    throw new IdentityOAuthAdminException("Error when reading the callback url for consumer key : " + consumerKey);
                }
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeAllConnections((Connection)connection, resultSet, prepStmt);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, (ResultSet)resultSet, (PreparedStatement)prepStmt);
        if (reqScope != null && reqScope.equals(scope)) {
            return authorizedUser;
        }
        throw new IdentityException("Scope of the access token doesn't match with the original scope");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getCallbackURLOfApp(String consumerKey) throws IdentityOAuthAdminException {
        String callbackURL = null;
        Connection connection = null;
        PreparedStatement prepStmt = null;
        ResultSet resultSet = null;
        try {
            connection = JDBCPersistenceManager.getInstance().getDBConnection();
            prepStmt = connection.prepareStatement("SELECT CALLBACK_URL FROM IDENTITY_OAUTH_CONSUMER_APPLICATIONS WHERE CONSUMER_KEY=?");
            prepStmt.setString(1, consumerKey);
            resultSet = prepStmt.executeQuery();
            if (resultSet.next()) {
                callbackURL = resultSet.getString(1);
            }
        }
        catch (IdentityException e) {
            try {
                String errorMsg = "Error when getting an Identity Persistence Store instance.";
                log.error((Object)errorMsg, (Throwable)e);
                throw new IdentityOAuthAdminException(errorMsg, e);
                catch (SQLException e2) {
                    log.error((Object)"Error when executing the SQL : SELECT CALLBACK_URL FROM IDENTITY_OAUTH_CONSUMER_APPLICATIONS WHERE CONSUMER_KEY=?");
                    log.error((Object)e2.getMessage(), (Throwable)e2);
                    throw new IdentityOAuthAdminException("Error when reading the callback url for consumer key : " + consumerKey);
                }
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeAllConnections((Connection)connection, resultSet, prepStmt);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, (ResultSet)resultSet, (PreparedStatement)prepStmt);
        return callbackURL;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getCallbackURLOfReqToken(String oauthToken) throws IdentityOAuthAdminException {
        String callbackURL = null;
        Connection connection = null;
        PreparedStatement prepStmt = null;
        ResultSet resultSet = null;
        try {
            connection = JDBCPersistenceManager.getInstance().getDBConnection();
            prepStmt = connection.prepareStatement("SELECT CALLBACK_URL FROM IDENTITY_OAUTH1A_REQUEST_TOKEN WHERE REQUEST_TOKEN=?");
            prepStmt.setString(1, oauthToken);
            resultSet = prepStmt.executeQuery();
            if (resultSet.next()) {
                callbackURL = resultSet.getString(1);
            }
        }
        catch (IdentityException e) {
            try {
                String errorMsg = "Error when getting an Identity Persistence Store instance.";
                log.error((Object)errorMsg, (Throwable)e);
                throw new IdentityOAuthAdminException(errorMsg, e);
                catch (SQLException e2) {
                    log.error((Object)"Error when executing the SQL : SELECT CALLBACK_URL FROM IDENTITY_OAUTH1A_REQUEST_TOKEN WHERE REQUEST_TOKEN=?");
                    log.error((Object)e2.getMessage(), (Throwable)e2);
                    throw new IdentityOAuthAdminException("Error when reading the callback url for OAuth Token : " + oauthToken);
                }
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeAllConnections((Connection)connection, resultSet, prepStmt);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, (ResultSet)resultSet, (PreparedStatement)prepStmt);
        return callbackURL;
    }
}

