/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth.authz;

import javax.security.auth.callback.Callback;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.oauth.authz.OAuthAuthorizationCallback;
import org.wso2.carbon.identity.oauth.authz.OAuthAuthorizationCallbackHandler;
import org.wso2.carbon.identity.oauth.authz.OAuthCallbackHandlerRegistry;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;

public class OAuthAuthorizationHandler {
    private static Log log = LogFactory.getLog(OAuthAuthorizationHandler.class);
    private OAuthCallbackHandlerRegistry callbackHandlerRegistry;

    public OAuthAuthorizationHandler() throws IdentityOAuth2Exception {
        this.init();
        this.callbackHandlerRegistry = OAuthCallbackHandlerRegistry.getInstance();
    }

    private void init() throws IdentityOAuth2Exception {
        this.callbackHandlerRegistry.initAuthzCallbackHandlers();
    }

    public void handleAuthorization(OAuthAuthorizationCallback authzCallback) throws IdentityOAuth2Exception {
        try {
            OAuthAuthorizationCallbackHandler authzCbHandler = this.callbackHandlerRegistry.getOAuthAuthzHandler(authzCallback);
            if (authzCbHandler != null) {
                authzCbHandler.handle(new Callback[]{authzCallback});
            }
        }
        catch (Exception e) {
            log.error((Object)"Error while calling OAuthAuthorization Handler. ", (Throwable)e);
            throw new IdentityOAuth2Exception("Error while calling OAuthAuthorization Handler. ", e);
        }
    }
}

