/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.identity.core.model.OAuthAppDO;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.oauth.OAuthUtil;
import org.wso2.carbon.identity.oauth.dao.OAuthAppDAO;
import org.wso2.carbon.identity.oauth.dto.OAuthConsumerAppDTO;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class OAuthAdminService
extends AbstractAdmin {
    protected Log log = LogFactory.getLog(OAuthAdminService.class);

    public String[] registerOAuthConsumer() throws Exception {
        String loggedInUser = this.getLoggedInUser();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Adding a consumer secret for the logged in user " + loggedInUser));
        }
        String tenantUser = MultitenantUtils.getTenantAwareUsername((String)loggedInUser);
        int tenantId = IdentityUtil.getTenantIdOFUser((String)loggedInUser);
        OAuthAppDAO dao = new OAuthAppDAO();
        return dao.addOAuthConsumer(tenantUser, tenantId);
    }

    public OAuthConsumerAppDTO[] getAllOAuthApplicationData() throws Exception {
        int tenantId;
        String userName = this.getLoggedInUser();
        OAuthConsumerAppDTO[] dtos = new OAuthConsumerAppDTO[]{};
        if (userName == null) {
            if (this.log.isErrorEnabled()) {
                this.log.debug((Object)"User not logged in");
            }
            throw new Exception("User not logged in");
        }
        OAuthAppDAO dao = new OAuthAppDAO();
        String tenantUser = MultitenantUtils.getTenantAwareUsername((String)userName);
        OAuthAppDO[] apps = dao.getOAuthConsumerAppsOfUser(tenantUser, tenantId = IdentityUtil.getTenantIdOFUser((String)userName));
        if (apps != null && apps.length > 0) {
            dtos = new OAuthConsumerAppDTO[apps.length];
            OAuthConsumerAppDTO dto = null;
            OAuthAppDO app = null;
            for (int i = 0; i < apps.length; ++i) {
                app = apps[i];
                dto = new OAuthConsumerAppDTO();
                dto.setApplicationName(app.getApplicationName());
                dto.setCallbackUrl(app.getCallbackUrl());
                dto.setOauthConsumerKey(app.getOauthConsumerKey());
                dto.setOauthConsumerSecret(app.getOauthConsumerSecret());
                dto.setOAuthVersion(app.getOauthVersion());
                dtos[i] = dto;
            }
        }
        return dtos;
    }

    public OAuthConsumerAppDTO getOAuthApplicationData(String consumerKey) throws Exception {
        OAuthConsumerAppDTO dto = new OAuthConsumerAppDTO();
        OAuthAppDAO dao = new OAuthAppDAO();
        OAuthAppDO app = dao.getAppInformation(consumerKey);
        if (app != null) {
            dto.setApplicationName(app.getApplicationName());
            dto.setCallbackUrl(app.getCallbackUrl());
            dto.setOauthConsumerKey(app.getOauthConsumerKey());
            dto.setOauthConsumerSecret(app.getOauthConsumerSecret());
            dto.setOAuthVersion(app.getOauthVersion());
        }
        return dto;
    }

    public void registerOAuthApplicationData(OAuthConsumerAppDTO application) throws Exception {
        String userName = this.getLoggedInUser();
        if (userName != null) {
            String tenantUser = MultitenantUtils.getTenantAwareUsername((String)userName);
            int tenantId = IdentityUtil.getTenantIdOFUser((String)userName);
            OAuthAppDAO dao = new OAuthAppDAO();
            OAuthAppDO app = new OAuthAppDO();
            if (application != null) {
                app.setApplicationName(application.getApplicationName());
                app.setCallbackUrl(application.getCallbackUrl());
                if (application.getOauthConsumerKey() == null) {
                    app.setOauthConsumerKey(OAuthUtil.getRandomNumber());
                    app.setOauthConsumerSecret(OAuthUtil.getRandomNumber());
                } else {
                    app.setOauthConsumerKey(application.getOauthConsumerKey());
                    app.setOauthConsumerSecret(application.getOauthConsumerSecret());
                }
                app.setUserName(tenantUser);
                app.setTenantId(tenantId);
                if (application.getOAuthVersion() != null) {
                    app.setOauthVersion(application.getOAuthVersion());
                } else {
                    app.setOauthVersion("OAuth-2.0");
                }
                dao.addOAuthApplication(app);
            }
        }
    }

    public void updateConsumerApplication(OAuthConsumerAppDTO consumerAppDTO) throws Exception {
        String userName = this.getLoggedInUser();
        String tenantAwareUsername = MultitenantUtils.getTenantAwareUsername((String)userName);
        int tenantId = IdentityUtil.getTenantIdOFUser((String)userName);
        OAuthAppDAO dao = new OAuthAppDAO();
        OAuthAppDO oauthappdo = new OAuthAppDO();
        oauthappdo.setUserName(tenantAwareUsername);
        oauthappdo.setTenantId(tenantId);
        oauthappdo.setOauthConsumerKey(consumerAppDTO.getOauthConsumerKey());
        oauthappdo.setOauthConsumerSecret(consumerAppDTO.getOauthConsumerSecret());
        oauthappdo.setCallbackUrl(consumerAppDTO.getCallbackUrl());
        dao.updateConsumerApplication(oauthappdo);
    }

    public void removeOAuthApplicationData(String consumerKey) throws Exception {
        OAuthAppDAO dao = new OAuthAppDAO();
        dao.removeConsumerApplication(consumerKey);
    }

    private String getLoggedInUser() {
        MessageContext msgContext = MessageContext.getCurrentMessageContext();
        HttpServletRequest request = (HttpServletRequest)msgContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
        HttpSession httpSession = request.getSession(false);
        if (httpSession != null) {
            return (String)httpSession.getAttribute("wso2carbon.admin.logged.in");
        }
        return null;
    }
}

