/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth2;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.oauth.internal.OAuthComponentServiceHolder;
import org.wso2.carbon.identity.oauth2.AbstractAuthorizationGrantHandler;
import org.wso2.carbon.identity.oauth2.dto.OAuth2AccessTokenReqDTO;
import org.wso2.carbon.identity.oauth2.dto.OAuth2AccessTokenRespDTO;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.api.UserStoreManager;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class PasswordGrantHandler
extends AbstractAuthorizationGrantHandler {
    private static Log log = LogFactory.getLog(PasswordGrantHandler.class);

    public PasswordGrantHandler(OAuth2AccessTokenReqDTO reqDTO) {
        super(reqDTO);
    }

    @Override
    public boolean validate() throws IdentityException {
        boolean authStatus;
        String username = this.oAuth2AccessTokenReqDTO.getResourceOwnerUsername();
        int tenantId = IdentityUtil.getTenantIdOFUser((String)username);
        if (tenantId < 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Token request with Password Grant Type for an invalid tenant : " + MultitenantUtils.getTenantDomain((String)username)));
            }
            return false;
        }
        RealmService realmService = OAuthComponentServiceHolder.getRealmService();
        try {
            UserStoreManager userStoreManager = realmService.getTenantUserRealm(tenantId).getUserStoreManager();
            authStatus = userStoreManager.authenticate(MultitenantUtils.getTenantAwareUsername((String)username), (Object)this.oAuth2AccessTokenReqDTO.getResourceOwnerPassword());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Token request with Password Grant Type received. Username : " + username + "Scope : " + this.oAuth2AccessTokenReqDTO.getScope() + ", Authentication State : " + authStatus));
            }
        }
        catch (UserStoreException e) {
            throw new IdentityException("Error when authenticating the user credentials.", (Throwable)e);
        }
        this.authorizedUser = this.oAuth2AccessTokenReqDTO.getResourceOwnerUsername();
        return authStatus;
    }

    @Override
    public OAuth2AccessTokenRespDTO issue() throws IdentityException {
        return super.issue();
    }
}

