/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth2;

import java.sql.Timestamp;
import java.util.Date;
import org.apache.amber.oauth2.as.issuer.MD5Generator;
import org.apache.amber.oauth2.as.issuer.OAuthIssuer;
import org.apache.amber.oauth2.as.issuer.OAuthIssuerImpl;
import org.apache.amber.oauth2.as.issuer.ValueGenerator;
import org.apache.amber.oauth2.common.exception.OAuthSystemException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.oauth2.AuthorizationGrantHandler;
import org.wso2.carbon.identity.oauth2.dao.TokenMgtDAO;
import org.wso2.carbon.identity.oauth2.dto.OAuth2AccessTokenReqDTO;
import org.wso2.carbon.identity.oauth2.dto.OAuth2AccessTokenRespDTO;

public abstract class AbstractAuthorizationGrantHandler
implements AuthorizationGrantHandler {
    private static Log log = LogFactory.getLog(AbstractAuthorizationGrantHandler.class);
    protected OAuth2AccessTokenReqDTO oAuth2AccessTokenReqDTO;
    protected TokenMgtDAO tokenMgtDAO = new TokenMgtDAO();
    protected final OAuthIssuer oauthIssuerImpl = new OAuthIssuerImpl((ValueGenerator)new MD5Generator());
    protected String authorizedUser;
    protected String scope;

    public AbstractAuthorizationGrantHandler(OAuth2AccessTokenReqDTO reqDTO) {
        this.oAuth2AccessTokenReqDTO = reqDTO;
    }

    @Override
    public abstract boolean validate() throws IdentityException;

    @Override
    public OAuth2AccessTokenRespDTO issue() throws IdentityException {
        String refreshToken;
        String accessToken;
        OAuth2AccessTokenRespDTO tokenRespDTO = new OAuth2AccessTokenRespDTO();
        try {
            accessToken = this.oauthIssuerImpl.accessToken();
            refreshToken = this.oauthIssuerImpl.refreshToken();
        }
        catch (OAuthSystemException e) {
            throw new IdentityException("Error when generating the tokens.", (Throwable)e);
        }
        Timestamp timestamp = new Timestamp(new Date().getTime());
        long validityPeriod = 3600L;
        this.tokenMgtDAO.storeAccessToken(accessToken, refreshToken, this.oAuth2AccessTokenReqDTO.getClientId(), this.authorizedUser, timestamp, validityPeriod, this.scope, "Active");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Persisted an access token with Client ID : " + this.oAuth2AccessTokenReqDTO.getClientId() + "authorized user : " + this.authorizedUser + "timestamp : " + timestamp + "validity period : " + validityPeriod + "scope : " + this.scope + "Token State : " + "Active"));
        }
        tokenRespDTO.setAccessToken(accessToken);
        tokenRespDTO.setRefreshToken(refreshToken);
        return tokenRespDTO;
    }
}

