/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.core.model.OAuthAppDO;
import org.wso2.carbon.identity.core.persistence.JDBCPersistenceManager;
import org.wso2.carbon.identity.core.util.IdentityDatabaseUtil;
import org.wso2.carbon.identity.oauth.IdentityOAuthAdminException;
import org.wso2.carbon.identity.oauth.OAuthUtil;

public class OAuthAppDAO {
    public static final Log log = LogFactory.getLog(OAuthAppDAO.class);

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addOAuthApplication(OAuthAppDO consumerAppDO) throws IdentityOAuthAdminException {
        Connection connection = null;
        PreparedStatement prepStmt = null;
        if (this.isDuplicateApplication(consumerAppDO.getUserName(), consumerAppDO.getTenantId(), consumerAppDO)) throw new IdentityOAuthAdminException("Error when adding the consumer application. An application with the same name already exists.");
        try {
            connection = JDBCPersistenceManager.getInstance().getDBConnection();
            prepStmt = connection.prepareStatement("INSERT INTO IDENTITY_OAUTH_CONSUMER_APPLICATIONS (CONSUMER_KEY, CONSUMER_SECRET, USERNAME, TENANT_ID, APP_NAME, OAUTH_VERSION, CALLBACK_URL) VALUES (?,?,?,?,?,?,?) ");
            prepStmt.setString(1, consumerAppDO.getOauthConsumerKey());
            prepStmt.setString(2, consumerAppDO.getOauthConsumerSecret());
            prepStmt.setString(3, consumerAppDO.getUserName());
            prepStmt.setInt(4, consumerAppDO.getTenantId());
            prepStmt.setString(5, consumerAppDO.getApplicationName());
            prepStmt.setString(6, consumerAppDO.getOauthVersion());
            prepStmt.setString(7, consumerAppDO.getCallbackUrl());
            prepStmt.execute();
            connection.commit();
        }
        catch (IdentityException e) {
            try {
                String errorMsg = "Error when getting an Identity Persistence Store instance.";
                log.error((Object)errorMsg, (Throwable)e);
                throw new IdentityOAuthAdminException(errorMsg, e);
                catch (SQLException e2) {
                    log.error((Object)"Error when executing the SQL : INSERT INTO IDENTITY_OAUTH_CONSUMER_APPLICATIONS (CONSUMER_KEY, CONSUMER_SECRET, USERNAME, TENANT_ID, APP_NAME, OAUTH_VERSION, CALLBACK_URL) VALUES (?,?,?,?,?,?,?) ");
                    log.error((Object)e2.getMessage(), (Throwable)e2);
                    throw new IdentityOAuthAdminException("Error when adding a new OAuth consumer application.");
                }
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, prepStmt);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, (PreparedStatement)prepStmt);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] addOAuthConsumer(String username, int tenantId) throws IdentityOAuthAdminException {
        String consumerKey;
        Connection connection = null;
        PreparedStatement prepStmt = null;
        String sqlStmt = null;
        String consumerSecret = OAuthUtil.getRandomNumber();
        while (this.isDuplicateConsumer(consumerKey = OAuthUtil.getRandomNumber())) {
        }
        try {
            connection = JDBCPersistenceManager.getInstance().getDBConnection();
            sqlStmt = "INSERT INTO IDENTITY_OAUTH_CONSUMER_APPLICATIONS (CONSUMER_KEY, CONSUMER_SECRET, USERNAME, TENANT_ID, OAUTH_VERSION) VALUES (?,?,?,?,?) ";
            prepStmt = connection.prepareStatement(sqlStmt);
            prepStmt.setString(1, consumerKey);
            prepStmt.setString(2, consumerSecret);
            prepStmt.setString(3, username);
            prepStmt.setInt(4, tenantId);
            prepStmt.setString(5, "OAuth-1.0a");
            prepStmt.execute();
            connection.commit();
        }
        catch (IdentityException e) {
            try {
                String errorMsg = "Error when getting an Identity Persistence Store instance.";
                log.error((Object)errorMsg, (Throwable)e);
                throw new IdentityOAuthAdminException(errorMsg, e);
                catch (SQLException e2) {
                    log.error((Object)("Error when executing the SQL : " + sqlStmt));
                    log.error((Object)e2.getMessage(), (Throwable)e2);
                    throw new IdentityOAuthAdminException("Error when adding a new OAuth consumer.");
                }
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, prepStmt);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, (PreparedStatement)prepStmt);
        return new String[]{consumerKey, consumerSecret};
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OAuthAppDO[] getOAuthConsumerAppsOfUser(String username, int tenantId) throws IdentityOAuthAdminException {
        OAuthAppDO[] oauthAppsOfUser;
        Connection connection = null;
        PreparedStatement prepStmt = null;
        ResultSet rSet = null;
        try {
            connection = JDBCPersistenceManager.getInstance().getDBConnection();
            prepStmt = connection.prepareStatement("SELECT CONSUMER_KEY, CONSUMER_SECRET, APP_NAME, OAUTH_VERSION, CALLBACK_URL FROM IDENTITY_OAUTH_CONSUMER_APPLICATIONS WHERE USERNAME=? AND TENANT_ID=?");
            prepStmt.setString(1, username);
            prepStmt.setInt(2, tenantId);
            rSet = prepStmt.executeQuery();
            ArrayList<OAuthAppDO> oauthApps = new ArrayList<OAuthAppDO>();
            while (rSet.next()) {
                if (rSet.getString(3) == null || rSet.getString(3).length() <= 0) continue;
                OAuthAppDO oauthApp = new OAuthAppDO();
                oauthApp.setUserName(username);
                oauthApp.setTenantId(tenantId);
                oauthApp.setOauthConsumerKey(rSet.getString(1));
                oauthApp.setOauthConsumerSecret(rSet.getString(2));
                oauthApp.setApplicationName(rSet.getString(3));
                oauthApp.setOauthVersion(rSet.getString(4));
                oauthApp.setCallbackUrl(rSet.getString(5));
                oauthApps.add(oauthApp);
            }
            oauthAppsOfUser = oauthApps.toArray(new OAuthAppDO[oauthApps.size()]);
        }
        catch (IdentityException e) {
            try {
                String errorMsg = "Error when getting an Identity Persistence Store instance.";
                log.error((Object)errorMsg, (Throwable)e);
                throw new IdentityOAuthAdminException(errorMsg, e);
                catch (SQLException e2) {
                    log.error((Object)"Error when executing the SQL : SELECT CONSUMER_KEY, CONSUMER_SECRET, APP_NAME, OAUTH_VERSION, CALLBACK_URL FROM IDENTITY_OAUTH_CONSUMER_APPLICATIONS WHERE USERNAME=? AND TENANT_ID=?");
                    log.error((Object)e2.getMessage(), (Throwable)e2);
                    throw new IdentityOAuthAdminException("Error when reading the application information from the persistence store.");
                }
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeAllConnections((Connection)connection, rSet, prepStmt);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, (ResultSet)rSet, (PreparedStatement)prepStmt);
        return oauthAppsOfUser;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OAuthAppDO getAppInformation(String consumerKey) throws IdentityOAuthAdminException {
        Connection connection = null;
        PreparedStatement prepStmt = null;
        ResultSet rSet = null;
        OAuthAppDO oauthApp = null;
        try {
            connection = JDBCPersistenceManager.getInstance().getDBConnection();
            prepStmt = connection.prepareStatement("SELECT CONSUMER_SECRET, APP_NAME, OAUTH_VERSION, CALLBACK_URL FROM IDENTITY_OAUTH_CONSUMER_APPLICATIONS WHERE CONSUMER_KEY=? ");
            prepStmt.setString(1, consumerKey);
            rSet = prepStmt.executeQuery();
            ArrayList<OAuthAppDO> oauthApps = new ArrayList<OAuthAppDO>();
            while (rSet.next()) {
                if (rSet.getString(3) == null || rSet.getString(3).length() <= 0) continue;
                oauthApp = new OAuthAppDO();
                oauthApp.setOauthConsumerKey(consumerKey);
                oauthApp.setOauthConsumerSecret(rSet.getString(1));
                oauthApp.setApplicationName(rSet.getString(2));
                oauthApp.setOauthVersion(rSet.getString(3));
                oauthApp.setCallbackUrl(rSet.getString(4));
                oauthApps.add(oauthApp);
            }
        }
        catch (IdentityException e) {
            try {
                String errorMsg = "Error when getting an Identity Persistence Store instance.";
                log.error((Object)errorMsg, (Throwable)e);
                throw new IdentityOAuthAdminException(errorMsg, e);
                catch (SQLException e2) {
                    log.error((Object)"Error when executing the SQL : SELECT CONSUMER_SECRET, APP_NAME, OAUTH_VERSION, CALLBACK_URL FROM IDENTITY_OAUTH_CONSUMER_APPLICATIONS WHERE CONSUMER_KEY=? ");
                    log.error((Object)e2.getMessage(), (Throwable)e2);
                    throw new IdentityOAuthAdminException("Error when reading the application information from the persistence store.");
                }
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeAllConnections((Connection)connection, rSet, prepStmt);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, (ResultSet)rSet, (PreparedStatement)prepStmt);
        return oauthApp;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateConsumerApplication(OAuthAppDO oauthAppDO) throws IdentityOAuthAdminException {
        Connection connection = null;
        PreparedStatement prepStmt = null;
        try {
            connection = JDBCPersistenceManager.getInstance().getDBConnection();
            prepStmt = connection.prepareStatement("UPDATE IDENTITY_OAUTH_CONSUMER_APPLICATIONS SET CALLBACK_URL=? WHERE CONSUMER_KEY=? AND CONSUMER_SECRET=?");
            prepStmt.setString(1, oauthAppDO.getCallbackUrl());
            prepStmt.setString(2, oauthAppDO.getOauthConsumerKey());
            prepStmt.setString(3, oauthAppDO.getOauthConsumerSecret());
            int count = prepStmt.executeUpdate();
            if (log.isDebugEnabled()) {
                log.debug((Object)("No. of records updated for updating consumer application. : " + count));
            }
            connection.commit();
        }
        catch (IdentityException e) {
            try {
                String errorMsg = "Error when getting an Identity Persistence Store instance.";
                log.error((Object)errorMsg, (Throwable)e);
                throw new IdentityOAuthAdminException(errorMsg, e);
                catch (SQLException e2) {
                    log.error((Object)"Error when executing the SQL : UPDATE IDENTITY_OAUTH_CONSUMER_APPLICATIONS SET CALLBACK_URL=? WHERE CONSUMER_KEY=? AND CONSUMER_SECRET=?");
                    log.error((Object)e2.getMessage(), (Throwable)e2);
                    throw new IdentityOAuthAdminException("Error updating the consumer application.");
                }
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, prepStmt);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, (PreparedStatement)prepStmt);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeConsumerApplication(String consumerKey) throws IdentityOAuthAdminException {
        Connection connection = null;
        PreparedStatement prepStmt = null;
        try {
            connection = JDBCPersistenceManager.getInstance().getDBConnection();
            prepStmt = connection.prepareStatement("DELETE FROM IDENTITY_OAUTH_CONSUMER_APPLICATIONS WHERE CONSUMER_KEY=?");
            prepStmt.setString(1, consumerKey);
            prepStmt.execute();
            connection.commit();
        }
        catch (IdentityException e) {
            try {
                String errorMsg = "Error when getting an Identity Persistence Store instance.";
                log.error((Object)errorMsg, (Throwable)e);
                throw new IdentityOAuthAdminException(errorMsg, e);
                catch (SQLException e2) {
                    log.error((Object)"Error when executing the SQL : DELETE FROM IDENTITY_OAUTH_CONSUMER_APPLICATIONS WHERE CONSUMER_KEY=?");
                    log.error((Object)e2.getMessage(), (Throwable)e2);
                    throw new IdentityOAuthAdminException("Error removing the consumer application.");
                }
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, prepStmt);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, (PreparedStatement)prepStmt);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isDuplicateApplication(String username, int tenantId, OAuthAppDO consumerAppDTO) throws IdentityOAuthAdminException {
        Connection connection = null;
        PreparedStatement prepStmt = null;
        ResultSet rSet = null;
        boolean isDuplicateApp = false;
        try {
            connection = JDBCPersistenceManager.getInstance().getDBConnection();
            prepStmt = connection.prepareStatement("SELECT * FROM IDENTITY_OAUTH_CONSUMER_APPLICATIONS WHERE USERNAME=? AND TENANT_ID=? AND APP_NAME=?");
            prepStmt.setString(1, username);
            prepStmt.setInt(2, tenantId);
            prepStmt.setString(3, consumerAppDTO.getApplicationName());
            rSet = prepStmt.executeQuery();
            if (rSet.next()) {
                isDuplicateApp = true;
            }
        }
        catch (IdentityException e) {
            try {
                String errorMsg = "Error when getting an Identity Persistence Store instance.";
                log.error((Object)errorMsg, (Throwable)e);
                throw new IdentityOAuthAdminException(errorMsg, e);
                catch (SQLException e2) {
                    log.error((Object)"Error when executing the SQL : SELECT * FROM IDENTITY_OAUTH_CONSUMER_APPLICATIONS WHERE USERNAME=? AND TENANT_ID=? AND APP_NAME=?");
                    log.error((Object)e2.getMessage(), (Throwable)e2);
                    throw new IdentityOAuthAdminException("Error when reading the application information from the persistence store.");
                }
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeAllConnections((Connection)connection, rSet, prepStmt);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, (ResultSet)rSet, (PreparedStatement)prepStmt);
        return isDuplicateApp;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isDuplicateConsumer(String consumerKey) throws IdentityOAuthAdminException {
        Connection connection = null;
        PreparedStatement prepStmt = null;
        ResultSet rSet = null;
        boolean isDuplicateConsumer = false;
        try {
            connection = JDBCPersistenceManager.getInstance().getDBConnection();
            prepStmt = connection.prepareStatement("SELECT * FROM IDENTITY_OAUTH_CONSUMER_APPLICATIONS WHERE CONSUMER_KEY=?");
            prepStmt.setString(1, consumerKey);
            rSet = prepStmt.executeQuery();
            if (rSet.next()) {
                isDuplicateConsumer = true;
            }
        }
        catch (IdentityException e) {
            try {
                String errorMsg = "Error when getting an Identity Persistence Store instance.";
                log.error((Object)errorMsg, (Throwable)e);
                throw new IdentityOAuthAdminException(errorMsg, e);
                catch (SQLException e2) {
                    log.error((Object)"Error when executing the SQL : SELECT * FROM IDENTITY_OAUTH_CONSUMER_APPLICATIONS WHERE CONSUMER_KEY=?");
                    log.error((Object)e2.getMessage(), (Throwable)e2);
                    throw new IdentityOAuthAdminException("Error when reading the application information from the persistence store.");
                }
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeAllConnections((Connection)connection, rSet, prepStmt);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, (ResultSet)rSet, (PreparedStatement)prepStmt);
        return isDuplicateConsumer;
    }
}

