/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth;

import java.util.Iterator;
import java.util.Properties;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.utils.Base64;
import org.wso2.carbon.base.ServerConfigurationException;
import org.wso2.carbon.identity.core.util.IdentityConfigParser;
import org.wso2.carbon.identity.oauth.IdentityOAuthAdminException;
import org.wso2.carbon.identity.oauth.authz.OAuthAuthorizationCallbackHandlerMetaData;
import org.wso2.carbon.identity.oauth.authz.OAuthCallbackHandlerRegistry;
import org.wso2.carbon.registry.core.utils.UUIDGenerator;

public final class OAuthUtil {
    public static final Log log = LogFactory.getLog(OAuthUtil.class);
    public static final String CONFIG_ELEM_OAUTH = "OAuth";
    public static final String CONFIG_ELEM_AUTHORIZATION_CALLBACK_HANDLERS = "AuthorizationCallbackHandlers";
    public static final String CONFIG_ELEM_AUTHORIZATION_CALLBACK_HANDLER = "AuthorizationCallbackHandler";
    public static final String CONFIG_ATTR_CLASS = "Class";
    public static final String CONFIG_ELEM_PRIORITY = "Priority";
    public static final String CONFIG_ELEM_PROPERTIES = "Properties";
    public static final String CONFIG_ELEM_PROPERTY = "Property";
    public static final String CONFIG_ATTR_NAME = "Name";

    public static String getRandomNumber() throws IdentityOAuthAdminException {
        try {
            String secretKey = UUIDGenerator.generateUUID();
            String baseString = UUIDGenerator.generateUUID();
            SecretKeySpec key = new SecretKeySpec(secretKey.getBytes(), "HmacSHA1");
            Mac mac = Mac.getInstance("HmacSHA1");
            mac.init(key);
            byte[] rawHmac = mac.doFinal(baseString.getBytes());
            String random = Base64.encode((byte[])rawHmac);
            random = random.replace("/", "_");
            random = random.replace("=", "a");
            random = random.replace("+", "f");
            return random;
        }
        catch (Exception e) {
            log.error((Object)"Error when generating a random number.", (Throwable)e);
            throw new IdentityOAuthAdminException("Error when generating a random number.", e);
        }
    }

    public static void parseAuthzCallbackHandlersConfig() throws IdentityOAuthAdminException {
        try {
            IdentityConfigParser configParser = IdentityConfigParser.getInstance();
            OMElement oauthElem = configParser.getConfigElement(CONFIG_ELEM_OAUTH);
            if (oauthElem == null) {
                OAuthUtil.warnOnFaultyConfiguration("OAuth element is not available.");
                return;
            }
            OMElement callbackHandlersElem = oauthElem.getFirstChildWithName(new QName("http://wso2.org/projects/carbon/carbon.xml", CONFIG_ELEM_AUTHORIZATION_CALLBACK_HANDLERS));
            if (callbackHandlersElem == null) {
                OAuthUtil.warnOnFaultyConfiguration("AuthorizationCallbackHandlers element is not available.");
                return;
            }
            Iterator callbackHandlers = callbackHandlersElem.getChildrenWithLocalName(CONFIG_ELEM_AUTHORIZATION_CALLBACK_HANDLER);
            int callbackHandlerCount = 0;
            if (callbackHandlers != null) {
                while (callbackHandlers.hasNext()) {
                    OAuthAuthorizationCallbackHandlerMetaData cbHandlerMetadata = OAuthUtil.buildAuthzCallbackHandlerMetadata((OMElement)callbackHandlers.next());
                    if (cbHandlerMetadata == null) continue;
                    OAuthCallbackHandlerRegistry.getInstance().addOAuthAuthorizationCallbackHandlerMetadata(cbHandlerMetadata);
                    log.info((Object)("OAuthAuthorizationCallbackHandleMetadata was added. Class : " + cbHandlerMetadata.getClassName()));
                    ++callbackHandlerCount;
                }
            }
            if (callbackHandlerCount <= 0) {
                OAuthUtil.warnOnFaultyConfiguration("No AuthorizationCallbackHandler elements were found.");
            }
        }
        catch (ServerConfigurationException e) {
            log.error((Object)"Error when reading the OAuthAuthorizationHandler Configurations.", (Throwable)e);
            throw new IdentityOAuthAdminException("Error when reading the OAuthAuthorizationHandler Configurations.", e);
        }
    }

    private static void warnOnFaultyConfiguration(String logMsg) {
        log.warn((Object)("Error in OAuth Configuration. " + logMsg));
    }

    private static OAuthAuthorizationCallbackHandlerMetaData buildAuthzCallbackHandlerMetadata(OMElement omElement) {
        String className = omElement.getAttributeValue(new QName(CONFIG_ATTR_CLASS));
        if (className == null) {
            log.error((Object)"Mandatory attribute \"Class\" is not present in the AuthorizationCallbackHandler element. AuthorizationCallbackHandler will not be registered.");
            return null;
        }
        int priority = 1;
        OMElement priorityElem = omElement.getFirstChildWithName(new QName("http://wso2.org/projects/carbon/carbon.xml", CONFIG_ELEM_PRIORITY));
        if (priorityElem != null) {
            priority = Integer.parseInt(priorityElem.getText());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Priority level of : " + priority + " is set for the " + "AuthorizationCallbackHandler with the class : " + className));
        }
        OMElement paramsElem = omElement.getFirstChildWithName(new QName("http://wso2.org/projects/carbon/carbon.xml", CONFIG_ELEM_PROPERTIES));
        Properties properties = null;
        if (paramsElem != null) {
            Iterator paramItr = paramsElem.getChildrenWithLocalName(CONFIG_ELEM_PROPERTY);
            properties = new Properties();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Registering Properties for AuthorizationCallbackHandler class : " + className));
            }
            while (paramItr.hasNext()) {
                OMElement paramElem = (OMElement)paramItr.next();
                String paramName = paramElem.getAttributeValue(new QName(CONFIG_ATTR_NAME));
                String paramValue = paramElem.getText();
                properties.put(paramName, paramValue);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Property name : " + paramName + ", Property Value : " + paramValue));
            }
        }
        return new OAuthAuthorizationCallbackHandlerMetaData(className, properties, priority);
    }
}

